/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * unattached_gdl_treeview.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: unattached_gdl_treeview.c,v 1.4 2004/01/16 18:58:09 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <db.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "unattached_gdl_treeview.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "gtk_helper.h"
#include "dc_gui2_com_channel_client.h"

/****************************************************************************************************/
/* this function calls the given fnc for each selected entry of the "unattached_gdl_treeview" clist */
/****************************************************************************************************/
void generic_selected_unattached_gdl_calls(GtkTreeSelectionForeachFunc fnc, void *data)
{
   GtkWidget *w;
   GtkTreeSelection *slc;

   w=get_widget_by_widget_name(main_window,"unattached_gdl_treeview");
   if(w==NULL)
      return;

   slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(w));
   gtk_tree_selection_selected_foreach(slc,fnc,data);
}

/**************************************************************************/
/* return the address of the Nth field of the string (separator is a '|') */
/**************************************************************************/
static const char *nth_field(const char *row, int num_field)
{
	if(num_field==0)
		return row;

	while((*row)&&(num_field>0))
	{
		if(*row=='|')
		{
			num_field--;
		}

		row++;

		if(num_field==0)
			return row;
	}

	return NULL;
}

static void cut_string(GString *final)
{
	char *t;

	t=strchr(final->str,'|');
	if(t!=NULL)
	{
		g_string_truncate(final,t-final->str);
	}
}

static void parse_file_and_populate_row(const char *cmd_file, GtkListStore *gls, GtkTreeIter *iter)
{
	int fd;
	struct stat st;

	fd=open(cmd_file,O_RDONLY);
	if(fd!=-1)
	{
		char *fic;
		ssize_t sz;
		gchar **rows;
		int i;
		const char *str_size=NULL;
		guint nb_sources=0;
		guint64 ttl_dl=0;
		const char *final_fname=NULL;
		const char *final_dir=NULL;
		guint64 file_size=0;
		GString *final;

		if(fstat(fd,&st)!=0)
		{
			close(fd);
			goto undefined;
		}

		fic=malloc(st.st_size);
		if(fic==NULL)
		{
			close(fd);
			goto undefined;
		}
		
		sz=read(fd,fic,st.st_size);
		if(sz!=st.st_size)
		{
			free(fic);
			close(fd);
			goto undefined;
		}
		close(fd);

		rows=g_strsplit(fic,"\n",0);
		free(fic);

		i=0;
		while(rows[i]!=NULL)
		{
			if(rows[i][0]=='G')		/* GDL name entry */
			{
				str_size=nth_field(rows[i],3);
			}
			else if(rows[i][0]=='O')	/* file renaming */
			{
				final_fname=nth_field(rows[i],1);
				final_dir=nth_field(rows[i],2);
			}
			else if(rows[i][0]=='S')	/* source */
			{
				nb_sources++;
			}
			else if(rows[i][0]=='R')	/* range */
			{
				const char *fld1, *fld2;
				fld1=nth_field(rows[i],2);
				fld2=nth_field(rows[i],3);

				if((fld1!=NULL)&&(fld2!=NULL))
				{
					ttl_dl+=(strtoul(fld2,NULL,10)-strtoul(fld1,NULL,10));
				}
			}

			i++;
		}

		if(str_size!=NULL)
		{
			char stt[512];
			file_size=strtoul(str_size,NULL,10);
#ifndef NO_PRINTF_LOCALE
			sprintf(stt,"%'llu",file_size);
#else
			sprintf(stt,"%llu",file_size);
#endif
			gtk_list_store_set(gls,iter,UAG_SIZE_COL,stt,
											-1);
		}

		final=g_string_new("");
		if(final_fname!=NULL)
		{
			if(final_dir!=NULL)
			{
				final=g_string_assign(final,final_dir);
				cut_string(final);
				final=g_string_append_c(final,'/');
			}

			g_string_append(final,final_fname);
			cut_string(final);

			if(utf8_mode==FALSE)
			{
				char *utf8;

				utf8=g_locale_to_utf8(final->str,-1,NULL,NULL,NULL);
				g_string_assign(final,utf8);
				g_free(utf8);
			}
		}
		{
			char cr[512];
			gfloat gcr;
			sprintf(cr,"%.2f",gcr=100.0*((gfloat)(ttl_dl))/((gfloat)(file_size)));

			gtk_list_store_set(gls,iter,UAG_NB_SRC_COL,nb_sources,
										 	UAG_COMPRATIO_COL,cr,
										 	UAG_FINALNAME_COL,final->str,
										 	UAG_COMPRATIO,gcr,
										 	UAG_SIZE_AS_VAL,(gulong)file_size,
										 	-1);
		}
		g_strfreev(rows);
		g_string_free(final,TRUE);
	}
	else
	{
		undefined:
		gtk_list_store_set(gls,iter,UAG_SIZE_COL,"unknown",
										 UAG_NB_SRC_COL,(guint)0,
										 UAG_COMPRATIO_COL,"?",
										 UAG_FINALNAME_COL,"?",
										 UAG_COMPRATIO,(gfloat)0.0,
										 UAG_SIZE_AS_VAL,(gulong)0,
										 -1);
	}
}

static void try_to_add_to_unattached_gdl_treeview(const char *dir1, const char *dir2, GtkListStore *gls)
{
	GString *str;
	int fd;

	str=g_string_new("");
	g_string_sprintf(str,"%s/%s/.lock",dir1,dir2);

	fd=open(str->str,O_RDWR);
	if(fd!=-1)
	{
		if(lockf(fd,F_TEST,1)==0)
		{
			/* .lock file exists and is lockable, so nobody uses this entry */
			GtkTreeIter iter;

			gtk_list_store_append(gls,&iter);

			if(utf8_mode==TRUE)
			{
				gtk_list_store_set(gls,&iter,UAG_FILENAME_COL,dir2,
														UAG_FILENAME,dir2,
														-1);
			}
			else
			{
				gchar *utf8;

				utf8=g_locale_to_utf8(dir2,-1,NULL,NULL,NULL);

				gtk_list_store_set(gls,&iter,UAG_FILENAME_COL,utf8,
														UAG_FILENAME,dir2,
														-1);
				
				g_free(utf8);
			}

			close(fd);

			g_string_sprintf(str,"%s/%s/.cmd",dir1,dir2);
			parse_file_and_populate_row(str->str,gls,&iter);
		}
		else
			close(fd);
	}
	else
	{
		if(!strncmp(dir2,"broken$",strlen("broken$")))
		{
			/* the filename starts with "broken$", let's try the broken GDL method */
			g_string_assign(str,dir1);
			g_string_append_c(str,'/');
			//g_string_append(str,dir2+strlen("broken$"));
			g_string_append(str,dir2);
			g_string_append(str,"/.crc");

			fd=open(str->str,O_RDWR);
			if(fd!=-1)
			{
				if(lockf(fd,F_TEST,1)==0)
				{
					/* .crc file exists and is lockable, so nobody uses this entry */
					GtkTreeIter iter;
					GString *b_name;

					b_name=g_string_new("(corrupted file) ");
					g_string_append(b_name,dir2+strlen("broken$"));

					gtk_list_store_append(gls,&iter);

					if(utf8_mode==TRUE)
					{
						gtk_list_store_set(gls,&iter,UAG_FILENAME_COL,b_name->str,
														UAG_FILENAME,dir2+strlen("broken$"),
														-1);
					}
					else
					{
						gchar *utf8;
		
						utf8=g_locale_to_utf8(b_name->str,-1,NULL,NULL,NULL);
		
						gtk_list_store_set(gls,&iter,UAG_FILENAME_COL,utf8,
																UAG_FILENAME,dir2+strlen("broken$"),
																-1);
						
						g_free(utf8);
					}
		
					close(fd);
					g_string_free(b_name,TRUE);
		
					g_string_sprintf(str,"%s/%s/.cmd",dir1,dir2);
					parse_file_and_populate_row(str->str,gls,&iter);
				}
				else
					close(fd);
			}
		}
	}
	g_string_free(str,TRUE);
}

/*****************************************************************/
/* load the GDL/ directory into the unattached_gdl_treeview list */
/*****************************************************************/
void load_unattached_gdl_treeview(void)
{
	GtkWidget *w;
	GtkTreeModel *gtm;
	GtkListStore *gls;
	gchar *t;
	DIR *dir;
	struct dirent *obj;
	SORT_VARS( )

	w=get_widget_by_widget_name(main_window,"unattached_gdl_treeview");

	if(w==NULL)
		return;

	gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));

	SORT_SAVE_GLS_TO_UNSORTED(,gtm,gls)

	gtk_list_store_clear(gls);

	t=gconf_client_get_string(gconf_engine,"/apps/Dc_gui2/Profile/default/dl_dir_entry_ent_cnt",NULL);
	if((t!=NULL)&&(strlen(t)))
	{
		GString *st1;

		st1=g_string_new(t);
		st1=g_string_append(st1,"/GDL");
		dir=opendir(st1->str);
		if(dir!=NULL)
		{
			while((obj=readdir(dir))!=NULL)
			{
				try_to_add_to_unattached_gdl_treeview(st1->str,obj->d_name,gls);
			}
			closedir(dir);
		}
		g_string_free(st1,TRUE);
	}
	if(t)
		g_free(t);
	SORT_RESTORE(,gtm)
}

/**************************************************************/
/* build modele and view for the unattached_gdl_treeview list */
/**************************************************************/
void bmav4_unattached_gdl_treeview(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_UAG_COL,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_UINT,
													G_TYPE_STRING,G_TYPE_STRING, G_TYPE_STRING,
													G_TYPE_FLOAT, G_TYPE_ULONG);

	view=get_widget_by_widget_name(main_window,"unattached_gdl_treeview");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);
	
	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UAG_FILENAME_COL,_("Filename"),rend,"text",UAG_FILENAME_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	g_object_set(rend,"xalign",(gfloat)1.0,NULL);
	MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UAG_SIZE_COL,UAG_SIZE_AS_VAL,_("Size"),rend,"text",UAG_SIZE_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	g_object_set(rend,"xalign",(gfloat)1.0,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UAG_NB_SRC_COL,_("#src"),rend,"text",UAG_NB_SRC_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	g_object_set(rend,"xalign",(gfloat)1.0,NULL);
	MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UAG_COMPRATIO_COL,UAG_COMPRATIO,_("%"),rend,"text",UAG_COMPRATIO_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UAG_FINALNAME_COL,_("Final filename"),rend,"text",UAG_FINALNAME_COL,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}

