/* C++ code produced by gperf version 3.0.4 */
/* Command-line: gperf  */
/* Computed positions: -k'1-2,$' */

#if !((' ' == 32) && ('!' == 33) && ('"' == 34) && ('#' == 35) \
      && ('%' == 37) && ('&' == 38) && ('\'' == 39) && ('(' == 40) \
      && (')' == 41) && ('*' == 42) && ('+' == 43) && (',' == 44) \
      && ('-' == 45) && ('.' == 46) && ('/' == 47) && ('0' == 48) \
      && ('1' == 49) && ('2' == 50) && ('3' == 51) && ('4' == 52) \
      && ('5' == 53) && ('6' == 54) && ('7' == 55) && ('8' == 56) \
      && ('9' == 57) && (':' == 58) && (';' == 59) && ('<' == 60) \
      && ('=' == 61) && ('>' == 62) && ('?' == 63) && ('A' == 65) \
      && ('B' == 66) && ('C' == 67) && ('D' == 68) && ('E' == 69) \
      && ('F' == 70) && ('G' == 71) && ('H' == 72) && ('I' == 73) \
      && ('J' == 74) && ('K' == 75) && ('L' == 76) && ('M' == 77) \
      && ('N' == 78) && ('O' == 79) && ('P' == 80) && ('Q' == 81) \
      && ('R' == 82) && ('S' == 83) && ('T' == 84) && ('U' == 85) \
      && ('V' == 86) && ('W' == 87) && ('X' == 88) && ('Y' == 89) \
      && ('Z' == 90) && ('[' == 91) && ('\\' == 92) && (']' == 93) \
      && ('^' == 94) && ('_' == 95) && ('a' == 97) && ('b' == 98) \
      && ('c' == 99) && ('d' == 100) && ('e' == 101) && ('f' == 102) \
      && ('g' == 103) && ('h' == 104) && ('i' == 105) && ('j' == 106) \
      && ('k' == 107) && ('l' == 108) && ('m' == 109) && ('n' == 110) \
      && ('o' == 111) && ('p' == 112) && ('q' == 113) && ('r' == 114) \
      && ('s' == 115) && ('t' == 116) && ('u' == 117) && ('v' == 118) \
      && ('w' == 119) && ('x' == 120) && ('y' == 121) && ('z' == 122) \
      && ('{' == 123) && ('|' == 124) && ('}' == 125) && ('~' == 126))
/* The character set is not based on ISO-646.  */
#error "gperf generated tables don't work with this execution character set. Please report a bug to <bug-gnu-gperf@gnu.org>."
#endif


#include <string.h>
#include <limits.h>
#include "dballe/core/var.h"
#include "dballe/core/record.h"

using namespace wreport;

namespace dballe {
struct tagdef { const char* tag; dba_keyword index; };

#define TOTAL_KEYWORDS 47
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 11
#define MIN_HASH_VALUE 6
#define MAX_HASH_VALUE 90
/* maximum key range = 85, duplicates = 0 */

class RecordKeywords
{
private:
  static inline unsigned int hash (const char *str, unsigned int len);
public:
  static struct tagdef *find (const char *str, unsigned int len);
};

inline unsigned int
RecordKeywords::hash (register const char *str, register unsigned int len)
{
  static unsigned char asso_values[] =
    {
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 60,
       0, 56, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91,  5, 10, 10,
      30,  0,  0, 91, 40, 10, 25, 91, 20,  0,
       5, 35,  0,  0,  5, 10, 20, 40, 20, 91,
       0,  0, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
      91, 91, 91, 91, 91, 91, 91
    };
  return len + asso_values[(unsigned char)str[1]+1] + asso_values[(unsigned char)str[0]] + asso_values[(unsigned char)str[len - 1]];
}

static struct tagdef wordlist[] =
  {
    {""}, {""}, {""}, {""}, {""}, {""},
    {"mobile",      DBA_KEY_MOBILE},
    {"yearmax",     DBA_KEY_YEARMAX},
    {"monthmax",    DBA_KEY_MONTHMAX},
    {"year",        DBA_KEY_YEAR},
    {""}, {""},
    {"yearmin",     DBA_KEY_YEARMIN},
    {"monthmin",    DBA_KEY_MONTHMIN},
    {""}, {""},
    {"secmax",      DBA_KEY_SECMAX},
    {"priomax",     DBA_KEY_PRIOMAX},
    {"priority",    DBA_KEY_PRIORITY},
    {""}, {""},
    {"secmin",      DBA_KEY_SECMIN},
    {"priomin",     DBA_KEY_PRIOMIN},
    {"sec",         DBA_KEY_SEC},
    {""},
    {"query",       DBA_KEY_QUERY},
    {"lonmax",      DBA_KEY_LONMAX},
    {""},
    {"lon",         DBA_KEY_LON},
    {""},
    {"leveltype2",  DBA_KEY_LEVELTYPE2},
    {"lonmin",      DBA_KEY_LONMIN},
    {"minumax",     DBA_KEY_MINUMAX},
    {"min",         DBA_KEY_MIN},
    {""},
    {"ident",       DBA_KEY_IDENT},
    {"latmax",      DBA_KEY_LATMAX},
    {"minumin",     DBA_KEY_MINUMIN},
    {"var",         DBA_KEY_VAR},
    {""},
    {"pindicator",  DBA_KEY_PINDICATOR},
    {"latmin",      DBA_KEY_LATMIN},
    {""},
    {"day",         DBA_KEY_DAY},
    {""},
    {"month",       DBA_KEY_MONTH},
    {"daymax",      DBA_KEY_DAYMAX},
    {"hourmax",     DBA_KEY_HOURMAX},
    {"rep_memo",    DBA_KEY_REP_MEMO},
    {"hour",        DBA_KEY_HOUR},
    {"context_id",  DBA_KEY_CONTEXT_ID},
    {"daymin",      DBA_KEY_DAYMIN},
    {"hourmin",     DBA_KEY_HOURMIN},
    {"lat",         DBA_KEY_LAT},
    {""},
    {"ana_filter",  DBA_KEY_ANA_FILTER},
    {"data_filter", DBA_KEY_DATA_FILTER},
    {"varlist",     DBA_KEY_VARLIST},
    {"p2",          DBA_KEY_P2},
    {""}, {""},
    {"attr_filter", DBA_KEY_ATTR_FILTER},
    {"p1",          DBA_KEY_P1},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"limit",		 DBA_KEY_LIMIT},
    {"var_related", DBA_KEY_VAR_RELATED},
    {""}, {""}, {""}, {""},
    {"ana_id",      DBA_KEY_ANA_ID},
    {""},
    {"l2",          DBA_KEY_L2},
    {""}, {""}, {""},
    {"l1",          DBA_KEY_L1},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"leveltype1",  DBA_KEY_LEVELTYPE1}
  };

struct tagdef *
RecordKeywords::find (register const char *str, register unsigned int len)
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].tag;

          if (*str == *s && !strncmp (str + 1, s + 1, len - 1) && s[len] == '\0')
            return &wordlist[key];
        }
    }
  return 0;
}


#define DEF_STRING(len) 0, 0, len, 0, len*8
#define DEF_MAXINT 0, 0, 10, 0, 31
#define DEF_INT(digits) 0, 0, digits, 0, digits*8

namespace {

struct keyword_infos
{
	struct _Varinfo infos[DBA_KEY_COUNT];

	keyword_infos()
	{
		infos[DBA_KEY_PRIORITY	 ].set(0, "Priority of this type of report",         "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_PRIOMAX	 ].set(0, "Maximum priority of reports queried",     "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_PRIOMIN	 ].set(0, "Minimum priority of reports queried",     "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_REP_MEMO	 ].set(0, "Mnemonic alias for type of report",     "CCITTIA5", DEF_STRING(20));
		infos[DBA_KEY_ANA_ID	 ].set(0, "Station database ID",                    "NUMERIC", DEF_MAXINT);
		infos[DBA_KEY_MOBILE	 ].set(0, "Station is mobile",                      "NUMERIC", DEF_MAXINT);
		infos[DBA_KEY_IDENT	 ].set(0, "Identifier of flight or ship",          "CCITTIA5", DEF_STRING(64));
		infos[DBA_KEY_LAT	 ].set(0, "Latitude",                                "DEGREE", 5, 0,   7,  -9000000, 25);
		infos[DBA_KEY_LON	 ].set(0, "Longitude",                               "DEGREE", 5, 0,   8, -18000000, 26);
		infos[DBA_KEY_LATMAX	 ].set(0, "Maximum latitude queried",                "DEGREE", 5, 0,   7,  -9000000, 25);
		infos[DBA_KEY_LATMIN	 ].set(0, "Minimum latitude queried",                "DEGREE", 5, 0,   7,  -9000000, 25);
		infos[DBA_KEY_LONMAX	 ].set(0, "Maximum longitude queried",               "DEGREE", 5, 0,   8, -18000000, 26);
		infos[DBA_KEY_LONMIN	 ].set(0, "Minimum longitude queried",               "DEGREE", 5, 0,   8, -18000000, 26);
		infos[DBA_KEY_YEAR	 ].set(0, "Year",                                      "YEAR", DEF_INT(4));
		infos[DBA_KEY_MONTH	 ].set(0, "Month",                                    "MONTH", DEF_INT(2));
		infos[DBA_KEY_DAY	 ].set(0, "Day",                                        "DAY", DEF_INT(2));
		infos[DBA_KEY_HOUR	 ].set(0, "Hour",                                      "HOUR", DEF_INT(2));
		infos[DBA_KEY_MIN	 ].set(0, "Minutes",                                 "MINUTE", DEF_INT(2));
		infos[DBA_KEY_SEC	 ].set(0, "Seconds",                                 "SECOND", DEF_INT(2));
		infos[DBA_KEY_YEARMAX	 ].set(0, "Maximum year queried",                      "YEAR", DEF_INT(4));
		infos[DBA_KEY_YEARMIN	 ].set(0, "Year or minimum year queried",              "YEAR", DEF_INT(4));
		infos[DBA_KEY_MONTHMAX	 ].set(0, "Maximum month queried",                    "MONTH", DEF_INT(2));
		infos[DBA_KEY_MONTHMIN	 ].set(0, "Minimum month queried",                    "MONTH", DEF_INT(2));
		infos[DBA_KEY_DAYMAX	 ].set(0, "Maximum day queried",                        "DAY", DEF_INT(2));
		infos[DBA_KEY_DAYMIN	 ].set(0, "Minimum day queried",                        "DAY", DEF_INT(2));
		infos[DBA_KEY_HOURMAX	 ].set(0, "Maximum hour queried",                      "HOUR", DEF_INT(2));
		infos[DBA_KEY_HOURMIN	 ].set(0, "Minumum hour queried",                      "HOUR", DEF_INT(2));
		infos[DBA_KEY_MINUMAX	 ].set(0, "Maxminum minutes queried",                "MINUTE", DEF_INT(2));
		infos[DBA_KEY_MINUMIN	 ].set(0, "Minimum minutes queried",                 "MINUTE", DEF_INT(2));
		infos[DBA_KEY_SECMAX	 ].set(0, "Maxminum seconds queried",                "SECOND", DEF_INT(2));
		infos[DBA_KEY_SECMIN	 ].set(0, "Minimum seconds queried",                 "SECOND", DEF_INT(2));
		infos[DBA_KEY_LEVELTYPE1 ].set(0, "Type of first level",                     "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_L1	 ].set(0, "Level layer L1",                          "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_LEVELTYPE2 ].set(0, "Type of second level",                    "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_L2	 ].set(0, "Level layer L2",                          "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_PINDICATOR ].set(0, "P indicator for time range",              "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_P1	 ].set(0, "Time range P1",                           "SECOND", DEF_MAXINT);
		infos[DBA_KEY_P2	 ].set(0, "Time range P2",                           "SECOND", DEF_MAXINT);
		infos[DBA_KEY_VAR	 ].set(0, "Variable queried",                      "CCITTIA5", DEF_STRING(7));
		infos[DBA_KEY_VARLIST	 ].set(0, "List of variables to query",            "CCITTIA5", DEF_STRING(255));
		infos[DBA_KEY_CONTEXT_ID ].set(0, "Context ID of the variable",             "NUMERIC", DEF_MAXINT);
		infos[DBA_KEY_QUERY	 ].set(0, "Query behaviour modifier",              "CCITTIA5", DEF_STRING(255));
		infos[DBA_KEY_ANA_FILTER ].set(0, "Filter on anagraphical data",           "CCITTIA5", DEF_STRING(255));
		infos[DBA_KEY_DATA_FILTER].set(0, "Filter on data", 		           "CCITTIA5", DEF_STRING(255));
		infos[DBA_KEY_ATTR_FILTER].set(0, "Filter on data attributes",             "CCITTIA5", DEF_STRING(255));
		infos[DBA_KEY_LIMIT	 ].set(0, "Maximum number of results to return",     "NUMBER", DEF_MAXINT);
		infos[DBA_KEY_VAR_RELATED].set(0, "Variable related to attribute queried", "CCITTIA5", DEF_STRING(6));

		// Increment refcounts
		for (int i = 0; i < DBA_KEY_COUNT; ++i)
			infos[i].do_ref();
	}
};

static struct keyword_infos* infos = NULL;

}

static const char* keyword_names[] = {
	"priority",
	"priomax",
	"priomin",
	"rep_memo",
	"ana_id",
	"mobile",
	"ident",
	"lat",
	"lon",
	"latmax",
	"latmin",
	"lonmax",
	"lonmin",
	"year",
	"month",
	"day",
	"hour",
	"min",
	"sec",
	"yearmax",
	"yearmin",
	"monthmax",
	"monthmin",
	"daymax",
	"daymin",
	"hourmax",
	"hourmin",
	"minumax",
	"minumin",
	"secmax",
	"secmin",
	"leveltype1",
	"l1",
	"leveltype2",
	"l2",
	"pindicator",
	"p1",
	"p2",
	"var",
	"varlist",
	"context_id",
	"query",
	"ana_filter",
	"data_filter",
	"attr_filter",
	"limit",
	"var_related",
};

const char* Record::keyword_name(dba_keyword key)
{
	return keyword_names[key];
}

Varinfo Record::keyword_info(dba_keyword keyword)
{
	if (infos == NULL) infos = new keyword_infos;
	return &(infos->infos[keyword]);
}

dba_keyword Record::keyword_byname(const char* tag)
{
	struct tagdef* res = RecordKeywords::find(tag, strlen(tag));
	if (res == NULL)
		return DBA_KEY_ERROR;
	else
		return res->index;
}

dba_keyword Record::keyword_byname_len(const char* tag, int len)
{
	struct tagdef* res = RecordKeywords::find(tag, len);
	if (res == NULL)
		return DBA_KEY_ERROR;
	else
		return res->index;
}

/*
dba_err dba_record_keyword_selftest()
{
	dba_keyword i, j;
	for (i = 0; i < DBA_KEY_COUNT; i++)
	{
		if (wordlist[i + 1].index != i)
			return dba_error_consistency("wordlist entry %d has index %d that does not match the position",
				i, wordlist[i + 1].index);
		j = dba_record_keyword_byname(wordlist[i + 1].tag);
		if (j != i)
			return dba_error_consistency("hashing of entry '%s' did not give expected index %d",
				wordlist[i + 1].tag, i);
	}
	return dba_error_ok();
}
*/

}

/* vim:set ts=4 sw=4: */
