/* Copyright (C) 2007 db4objects Inc. http://www.db4o.com */

package com.db4odoc.systeminfo;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

import com.db4o.DatabaseFileLockedException;
import com.db4o.Db4o;
import com.db4o.ObjectContainer;


public class SystemInfoExample {

	private final static String DB4O_FILE_NAME = "reference.db4o";
	
	private final static String LOG_FILE_NAME = "db4o.log";

	private final static long MAX_DB_SIZE = 20000000;
	
	private final static long MAX_FS_SIZE = 2000000;
	
	private static ObjectContainer _container = null;
	
	private static PrintStream _logPS = null;
	
	private static  FileOutputStream  _logFout = null;
	
	public static void main(String[] args) throws IOException{
		initialize();
		testSystemInfo();
		close();
	}
	// end main

	private static void testSystemInfo() {
		long dbSize = _container.ext().systemInfo().totalSize();
		long fsSize = _container.ext().systemInfo().freespaceSize();
		if (dbSize > MAX_DB_SIZE) {
			System.out.println("Attention! Database file size is over the limit. Maintenance required");
		}
		_logPS.println("Total database size: " + dbSize);
		if (fsSize > MAX_FS_SIZE) {
			System.out.println("Attention! Freespace size is over the limit. Maintenance required");
		}
		_logPS.println("Database freespace size: " + fsSize);
		_logPS.println("Database freespace entries: " + _container.ext().systemInfo().freespaceEntryCount());
	}
	// end testSystemInfo
	
	private static void initialize() throws IOException {
		_logFout = new FileOutputStream(LOG_FILE_NAME);
		_logPS = new PrintStream(_logFout);
		
			try {
				_container = Db4o.openFile(DB4O_FILE_NAME);
			} catch (DatabaseFileLockedException ex) {
				System.out.println(ex.getMessage());
			}
			_logPS.println("Database check-up: " + new Date(System.currentTimeMillis()).toString());
	}

	// end initialize

	private static void close() throws IOException  {
		if (_container != null) {
			_container.close();
			_container = null;
		}
		_logPS.println("Done.");
		_logFout.close();
	}

	// end close

}
