#ifndef __HPP_KAVSCAN
#define __HPP_KAVSCAN

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  Written by m4d.
//

#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/un.h>

#include "VirusEngine.hpp"
#include "OptionContainer.hpp"


using namespace std;


// this class implements the VirusEngine api for kaspersky/aveserver v5
//
class KAV5Engine:public VirusEngine
{
private:
  string err_str;
  string vname;

  int recv_line (int _sock, char *_buf, int _size);

public:
    KAV5Engine ();
    virtual ~ KAV5Engine ();

  virtual int loadEngine ()
  {                             /* nothing to do here */
    return 0;
  }
  virtual int reloadEngine ()
  {                             /* nothing to do here */
    return 0;
  }
  virtual int unloadEngine ()
  {                             /* nothing to do here */
    return 0;
  }

  virtual int scanFile (const char *_fname);

  virtual const char *getVirusName ()
  {
    return vname.c_str ();
  }
  virtual const char *getErrString ()
  {
    return err_str.c_str ();
  }

  virtual void setVirusName (const char *_vname)
  {
    vname = _vname;
  }
  virtual void setErrString (const char *_err_str)
  {
    err_str = _err_str;
  }
};

#endif
