#ifndef __HPP_CLAMDSCAN
#define __HPP_CLAMDSCAN

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  Written by Aecio F. Neto (afn@harvest.com.br)
//              Harvest Consultoria (www.harvest.com.br)
//
//  and somewhat hacked by m4d.
//

#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/un.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <cerrno>

#include "VirusEngine.hpp"
#include "OptionContainer.hpp"


using namespace std;


// this class implements the VirusEngine api for clamav/clamdscan
//
class ClamDEngine:public VirusEngine
{
private:
  bool stream_scan;
  string err_str;
  string vname;                 // extra virus name field, in case we manually need to set one
  // (e.g. forked scanning needs this; child->parent data handover)

  int dconnect ();
  int dsfile (int sockd, const char *filename);
  int dsstream (int sockd, const char *_fname);

public:
    ClamDEngine ();
    virtual ~ ClamDEngine ();

  virtual int loadEngine ()
  {                             /* nothing to do here */
    return 0;
  }
  virtual int reloadEngine ()
  {                             /* nothing to do here */
    return 0;
  }
  virtual int unloadEngine ()
  {                             /* nothing to do here */
    return 0;
  }

  virtual int scanFile (const char *_fname);

  virtual const char *getVirusName ()
  {
    return vname.c_str ();
  }
  virtual const char *getErrString ()
  {
    return err_str.c_str ();
  }

  virtual void setVirusName (const char *_vname)
  {
    vname = _vname;
  }
  virtual void setErrString (const char *_err_str)
  {
    err_str = _err_str;
  }
};

#endif
