/* $Id: str.h,v 1.6 2003/07/29 22:35:18 mastermind Exp $ */

/*
 * Copyright (c) 1998-2003, Alexander Marx
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer. 
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *
 */

#ifndef __easy_eSTR_H
#define __easy_eSTR_H 1


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>


/* ------------------------------------------------------------------------ */

#define BOOL		short
#define TRUE		1
#define FALSE		0

#define BSET(_f, _m)	((_f)|=(_m))
#define BTST(_f, _m)	(((_f)&(_m))==(_m))
#define BCLR(_f, _m)	((_f)&=(~(_m)))
#define BCHG(_f, _m)	((_f)^=(_m))

#define BnTST(_f, _m) 	((((_f)&(_m))^(_m))==(_m))

#define	eSTR_BLOCK_SIZE	512

#define	eSTR_HEAD	1
#define	eSTR_TAIL	2
#define	eSTR_FWD	3
#define	eSTR_BWD	4

#define	eSTR_LEAD	1
#define	eSTR_TRAIL	2
#define	eSTR_BODY	4
#define	eSTR_BOTH	(eSTR_LEAD|eSTR_TRAIL)
#define	eSTR_ALL	(eSTR_BOTH|eSTR_BODY)

#define eSTR_END	(NULL)


/* ------------------------------------------------------------------------ */

typedef struct {
	char *str;
	long idx, len;
} eSTR;


/* --- Public Functions --------------------------------------------------- */

eSTR *newSTR(const char *s);
eSTR *va_newSTR(const char *s, ...);
eSTR *clrSTR(eSTR *str);
eSTR *cpySTR(eSTR *dest_str, const eSTR *src_str);
eSTR *dupSTR(const eSTR *src_str);
eSTR *setSTR(eSTR *str, const char *s);
eSTR *spcSTR(unsigned long len);
void freeSTR(eSTR *str);

int putSTR(const eSTR *str, FILE *fh);
int putsSTR(const eSTR *str, FILE *fh);
eSTR *getSTR(FILE *fh);
eSTR *getlineSTR(FILE *fh);

char *strSTR(const eSTR *str);
long lenSTR(const eSTR *str);

char traverseSTR(eSTR *str, int move_to);
char *adrSTR(const eSTR *str);
long idxSTR(const eSTR *str);
char chrSTR(eSTR *str);

eSTR *upperSTR(eSTR *str);
eSTR *lowerSTR(eSTR *str);
eSTR *reverseSTR(eSTR *str);
eSTR *stripSTR(eSTR *str, int where, const char *s);

char *tokSTR(eSTR *str, const char *s);

eSTR *catSTR(eSTR *dest_str, const char *s);
eSTR *va_catSTR(eSTR *dest_str, ...);
eSTR *catSTRs(eSTR *dest_str, const eSTR *src_str);

eSTR *leftSTR(const eSTR *str, long idx);
eSTR *rightSTR(const eSTR *str, long idx);
eSTR *midSTR(const eSTR *str, long idx, long len);

long subsSTR(const eSTR *haystack, const char *needle);
long subcSTR(const eSTR *haystack, char needly);
BOOL verifySTR(const eSTR *str, const char *s);

int cmpSTR(const eSTR *str, const char *s);
int cmpSTRs(const eSTR *s1, const eSTR *s2);


/* new4cydump */

eSTR *infileSTR(const char *file);
int outfileSTR(const eSTR *str, const char *file);
int tounixSTR(eSTR *str);


/* --- Private Functions -------------------------------------------------- */

#ifdef __easy_eSTR_C

static int copy(eSTR *dest_str, const eSTR *src_str);
static void destroy(eSTR *str);
static void init(eSTR *str);

#endif


/* ------------------------------------------------------------------------ */

#endif /* eSTR_H */
