#!/bin/bash
#
# Written by Adam Shand <adam @ spack.org> in attempt at world domination.
# Moves one user from a Cyrus format mailbox to a new (dovecot-style) maildir stored 
# in /prefix/domain.co.nz/user
#
# You will need to tweak various paths to work in your environment.
#
# debug
#set -x
#

PATH="/bin:/usr/bin:/usr/local/bin:/usr/lib/cyrus-imapd:/usr/home/ashand/src/cyrus2courier-1.3/src"

# where is your cyrus data
CYRUS_LIB="/imap/lib"
CYRUS_SPOOL="/imap/spool"

if [ -z $2 ]; then
  echo "Usage: $0 <source_user> <dest_user@domain.co.nz>"
  exit 0
fi

USER="$1"
NEW_USER="${2//@*/}"
NEW_DOMAIN="${2//*@/}"
MAILDIR="/vol/mail/${NEW_DOMAIN}"


# make sure the user exists
if [ ! -r ${CYRUS_LIB}/user/${USER:0:1}/${USER}.seen ]; then
    echo "Error: The file ${CYRUS_LIB}/user/${USER:0:1}/${USER}.seen must exist."
    exit 1
fi

# make sure the new domain exists
if [ ! -w ${MAILDIR} ]; then
    echo "Error: Directory ${MAILDIR} must exist and be writable."
    exit 1
fi

# make sure the maildir's don't exist
if [ -d ${MAILDIR}/${USER} ]; then
    echo "Error: Maildir ${MAILDIR}/${USER} must not already exist."
    exit 1
fi
if [ -d ${MAILDIR}/${NEW_USER} ]; then
    echo "Error: Maildir ${MAILDIR}/${NEW_USER} must not already exist."
    exit 1
fi

TEMPDIR=`mktemp -d /tmp/cyrus2dovecot.XXXXXX`
trap 'rm -rf ${TMPDIR}; exit 1' 1 2 15

echo "Converting seen file from skiplist to flat"
cvt_cyrusdb ${CYRUS_LIB}/user/${USER:0:1}/${USER}.seen skiplist ${TEMPDIR}/${USER}.seen flat

# if new username != old username, create a symlink to help out cyrus2courier
if [ $USER != $NEW_USER ]; then
    echo "Creating helper link from $USER to $NEW_USER"
    mkdir ${MAILDIR}/${NEW_USER}
    ln -s ${MAILDIR}/${NEW_USER} ${MAILDIR}/${USER}
fi

echo "Migrating mail files into ${MAILDIR}/${NEW_USER} (can take a long time)"
cyrus2courier -d --hashed=s --seen-dir=${TEMPDIR} --subscribe-dir=${CYRUS_LIB}/user ${CYRUS_SPOOL}/user ${MAILDIR} ${USER}

echo "Fixing ${MAILDIR}/${NEW_USER} permissions"
chown -R vmail:vmail ${MAILDIR}/${NEW_USER}

if [ $USER != $NEW_USER ]; then
    echo "Removing helper link (${MAILDIR}/${USER})"
    rm ${MAILDIR}/${USER}
fi

echo "Removing ${TEMPDIR}"
rm -rf ${TEMPDIR}

