/***************************************************************************
                          fehler.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <cstdlib>
#include <cstdio>
//#include <signal.h>

#include "fehler.h"
#include "blop.h"
#include "global.h"



/** Erzeugt einen Fehler, bei dem der Text noch nicht gesetzt ist.
    Ist nur fr iFehler() gedacht. */
Fehler::Fehler(): mIntern(false), mMitZeile(false) {
  /* Wenn der Fehler whrend einer Gleichzeit passiert, soll letztere
     abgebrochen werden. */
  Blop::abbruchGleichzeitig();
  //raise(SIGTRAP);
}


Fehler::Fehler(const char * fmt, ...):
  mIntern(false), mMitZeile(false)
{
  /* Wenn der Fehler whrend einer Gleichzeit passiert, soll letztere
     abgebrochen werden. */
  Blop::abbruchGleichzeitig();
  
  va_list va;
  va_start(va, fmt);
  setText(fmt, va);
  va_end(va);
//  raise(SIGTRAP);
}



Fehler iFehler(const char * fmt, ...) {
  
  Fehler ret;
  
  /* Interner Fehler. */
  ret.mIntern = true; 
  
  /* Fehlertext setzen */
  va_list va;
  va_start(va, fmt);
  ret.setText(fmt, va);
  va_end(va);
  
  return ret;
}


/** Liefert true, wenn dieser Fehler gerne eine Log-Datei schicken wrde,
    d. h. wenn es ein interner Fehler ist oder - bei nicht internen
    Fehlern - wenn _keine_ ld-Datei an Cuyo bergeben wurde. */
bool Fehler::getSendLog() const {
  return mIntern || !gDateiUebergeben;
}



/** True, wenn ggf. "please send log" angehngt werden soll. GGf heit:
    Wenn getSendLog() true liefert. */
__String Fehler::getText(bool mitLog /*= false*/) const {
  if (getSendLog() && mitLog)
    return mText + "\n" + send_log_string;
  else
    return mText;
}




/** Macht aus einem Format-String und weiteren Argumenten 
    einen Fehlermeldungstext. */
void Fehler::setText(const char * fmt, va_list va) {
  /* Also eigentlich sollte man so was wie in der man-page von
     sprintf steht machen, wo die String-Gre richtig berechnet
     wird... */
  char aaa[1111];
  vsprintf(aaa, fmt, va);
  mText = aaa;
}




