
# This file is the first one included from main.ld.
# It contains all the definitions which are useful for more than
# one level: the schemas and the defaults



<<

# The whole icon depends on the four neighbours
schema16={
  switch {
    0?0?0?0? -> A;
    0?1?0?0? -> B;
    0?1?0?1? -> C;
    0?0?0?1? -> D;
    0?0?1?0? -> E;
    0?1?1?0? -> F;
    0?1?1?1? -> G;
    0?0?1?1? -> H;
    1?0?1?0? -> I;
    1?1?1?0? -> J;
    1?1?1?1? -> K;
    1?0?1?1? -> L;
    1?0?0?0? -> M;
    1?1?0?0? -> N;
    1?1?0?1? -> O;
    1?0?0?1? -> P;
  };
  *
};

# Each quarter depends on its three neighbours - but it may only depend
# on the diagonal neighbour if at least one of the two other neighbours
# exist... Not yet defined.
#schema7={
#};

# Each quarter normally depends on its two neighbours. In addition, there's
# a special case when all three neighbours exist.
schema5={
  [qu=Q_TL] {switch {
    0?????0? -> C;
    1?????0? -> D;
    0?????1? -> A;
    1?????10 -> B;
    1?????11 -> E;
  };*};
  [qu=Q_TR] {switch {
    0?0????? -> C;
    0?1????? -> A;
    1?0????? -> B;
    101????? -> E;
    111????? -> D;
  };*};
  [qu=Q_BL] {switch {
    ????0?0? -> C;
    ????0?1? -> E;
    ????1?0? -> D;
    ????101? -> A;
    ????111? -> B;
  };*};
  [qu=Q_BR] {switch {
    ??0?0??? -> C;
    ??0?1??? -> B;
    ??1?0??? -> E;
    ??101??? -> D;
    ??111??? -> A;
  };*}
};



# Each quarter depends on its two neighbours
schema4={
  [qu=Q_TL] {switch {
    0?????0? -> A;
    0?????1? -> B;
    1?????0? -> C;
    1?????1? -> D;
  };*};
  [qu=Q_TR] {switch {
    0?1????? -> A;
    0?0????? -> B;
    1?1????? -> C;
    1?0????? -> D;
  };*};
  [qu=Q_BL] {switch {
    ????1?0? -> A;
    ????1?1? -> B;
    ????0?0? -> C;
    ????0?1? -> D;
  };*};
  [qu=Q_BR] {switch {
    ??1?1??? -> A;
    ??0?1??? -> B;
    ??1?0??? -> C;
    ??0?0??? -> D;
  };*}
};



# Each Quarter depends on its three neighbours.
schemaDiag16={
  [qu=Q_TL] {switch {
    0?????00 -> E;
    0?????10 -> F;
    1?????00 -> N;
    1?????10 -> G;
    0?????01 -> C;
    0?????11 -> L;
    1?????01 -> J;
    1?????11 -> K;
  };*};
  [qu=Q_TR] {switch {
    000????? -> C;
    100????? -> G;
    001????? -> E;
    101????? -> K;
    010????? -> L;
    110????? -> N;
    011????? -> F;
    111????? -> J;
  };*};
  [qu=Q_BL] {switch {
    ????000? -> N;
    ????100? -> J;
    ????001? -> L;
    ????101? -> F;
    ????010? -> E;
    ????110? -> C;
    ????011? -> K;
    ????111? -> G;
  };*};
  [qu=Q_BR] {switch {
    ??000??? -> L;
    ??100??? -> K;
    ??001??? -> C;
    ??101??? -> J;
    ??010??? -> N;
    ??110??? -> E;
    ??011??? -> G;
    ??111??? -> F;
  };*}
};


# Each Quarter only depends on its diagonal neighbour.
schemaDiag2={
  [qu=Q_TL] {switch {
    ???????0 -> A;
    ???????1 -> B;
  };*};
  [qu=Q_TR] {switch {
    ?0?????? -> A;
    ?1?????? -> B;
  };*};
  [qu=Q_BL] {switch {
    ?????0?? -> A;
    ?????1?? -> B;
  };*};
  [qu=Q_BR] {switch {
    ???0???? -> A;
    ???1???? -> B;
  };*}
};


# For hex mode. Each Quarter depends on its three neighbours.
schemaHex8={
  [qu=Q_TL_TL] {switch {
    0???00 -> A*;
    1???00 -> E*;
    0???10 -> C*;
    1???10 -> G*;
  }};
  [qu=Q_BL_TL] {switch {
    0???01 -> D*;
    1???01 -> H*;
    0???11 -> B*;
    1???11 -> F*;
  }};
  [qu=Q_TR_TR] {switch {
    001??? -> C*;
    101??? -> G*;
    011??? -> A*;
    111??? -> E*;
  }};
  [qu=Q_BR_TR] {switch {
    000??? -> D*;
    100??? -> H*;
    010??? -> B*;
    110??? -> F*;
  }};
  [qu=Q_BL_BL] {switch {
    ???100 -> A*;
    ???000 -> E*;
    ???110 -> C*;
    ???010 -> G*;
  }};
  [qu=Q_TL_BL] {switch {
    ???001 -> D*;
    ???101 -> H*;
    ???011 -> B*;
    ???111 -> F*;
  }};
  [qu=Q_BR_BR] {switch {
    ?011?? -> C*;
    ?010?? -> G*;
    ?111?? -> A*;
    ?110?? -> E*;
  }};
  [qu=Q_TR_BR] {switch {
    ?000?? -> D*;
    ?001?? -> H*;
    ?100?? -> B*;
    ?101?? -> F*;
  }}
};

# Default when there's one file with one icon
default1 = *;

# Default when there's one file with more than one icon (except for
# the grass)
default2 = {schema16};

# Same as default2, but for the grass
default2g = {pos=version;*};

# Default when there are multiple files
default3 = {file=version;schema16};

>>
