/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "inkompatibel.h"

#include <cstdlib>
#include <time.h>
#include <qdatetime.h>
#include <qapp.h>

#include "pfaditerator.h"
#include "cuyointl.h"

#include "cuyo.h"

#include "config.h"

bool gDebug;


int main(int argc, char *argv[])
{
  
  /* Lokalisierung */
  /* PACKAGE und LOCALEDIR stammen aus config.h */
  //setlocale (LC_ALL, "");
  //bindtextdomain (PACKAGE, LOCALEDIR);
  //textdomain (PACKAGE);

  try {

    QApplication a(argc,argv);
    
    /* Der Pfaditerator braucht unser 0tes Argument, um in lokalen
       Verzeichnissen nach den Daten-Dateien zu suchen. */
    PfadIterator::init(argc, argv);
    
    srand(time(0));
    
    /* Letzter Parameter: Debug? (Nicht dokumentiert, da nicht fr
       Endbenutzer, die keine Quelltexte lesen.) */
    gDebug = argc >= 2 && strcmp(argv[1], "-d") == 0;
    Cuyo cuyo(0, "Cuyo-Fenster");
    a.setMainWidget(&cuyo);
    cuyo.show();
    return a.exec();

  } catch (Fehler f) {
    fprintf(stderr, _("Error: %s\n"), f.mText.data());
    return 1;
  }
  
}
