/***************************************************************************
                          nachbariterator.cpp  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "leveldaten.h"
#include "nachbariterator.h"

NachbarIterator::NachbarIterator(const Sorte * s, int x, int y):
    mNachbarschaft(s->mNachbarschaft), mX0(x), mY0(y), mI(0), mEnde(false)
{
  setXY();
}
NachbarIterator::~NachbarIterator(){
}


/** Nchster Nachbar */
NachbarIterator & NachbarIterator::operator++() {
  if (!mEnde) {
    mI++;
    setXY();
  }
  return *this;
}

	
void NachbarIterator::setXY() {
  char bx, by;
  switch (mNachbarschaft) {
  /* Die Nachbarschafts-Konstanten stehen in sorte.h */
  case nachbarschaft_normal:
    bx = "1232"[mI];
    by = "2321"[mI];
    break;
  case nachbarschaft_schraeg:
    bx = "1133"[mI];
    by = "1313"[mI];
    break;
  case nachbarschaft_6:
    bx =            "221133"[mI];
    by = ((mX0&1) ? "131212" : "132323")[mI];
    break;
  case nachbarschaft_6_schraeg:
    bx =            "1133"[mI];
    by = ((mX0&1) ? "1212" : "2323")[mI];
    break;
  case nachbarschaft_springer:
    bx = "00134431"[mI];
    by = "13443100"[mI];
    break;
  case nachbarschaft_dame:
    bx = "12321133"[mI];
    by = "23211313"[mI];
    break;
  default:
    ASSERT(false);
  }
  if (!bx)
    mEnde = true;
  else {
    mX = mX0 + bx - '2';
    mY = mY0 + by - '2';
  }
}
