/***************************************************************************
                          cuyo.h  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CUYO_H
#define CUYO_H

#include "inkompatibel.h"

#include <qwidget.h>

#include <qpopmenu.h>
#include <qmenubar.h>
#include <qlabel.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "spielfeld.h"

#include "bilddatei.h"

#define gmodus_kein_spiel 0
#define gmodus_spiel_start 1  // ... wie gmodus_spiel, aber Text muss noch gelscht werden
#define gmodus_spiel 2
#define gmodus_pause 20 // Nach Pause wird wieder in gmodus_spiel geschaltet
/* die folgenden beiden Modi bedeuten beide, dass das Spiel (der Level) zu Ende geht */
#define gmodus_warte_tot 3    	// ... weil ein Spieler tot ist
#define gmodus_warte_level 4  	// ... weil der Level fertig ist
#define gmodus_bonus_animation 5	// Zeit-Bonus bekommen...
#define gmodus_bonus_warte 6		// Nach dem Zeit-Bonus noch ein bisschen warten...

#define max_spielerzahl 2

/*** Defines fr Fenster-Layout ***/
/* Hhe von dem Bereich ber den Spielfeldern mit der Punkteanzeige */
#define L_oben_hoehe 20
/* Breite der Gras-Anzeigen */
#define L_graslabel_breite 50
/* Rand zwischen den verschiedenen Objekten */
#define L_rand 4
/* Fensterbreite */
#define L_fenster_breite (L_rand + (grx * gric + L_rand) * max_spielerzahl)

class KIPlayer;

/** Cuyo -- Das Fenster.

    Ein paar allgemeine Definitionen:
    
    Blop: eins von diesen Kgelchen. Auch Graue oder Gras, etc.
    
    Version (eines Blops): Untersorte (usprnglich vom Gras)
    
    Zustand eines Blops: 1. Wo in der Animation befindet es sich?
    2. Welche Version ist es?
    
    Standardblop: Kgelchen, aber kein Graues, etc.
    
    Farbe: eine Sorte von Standardblops.
    
    Bilddatei: Ein Pixmap so wie es geladen wurde.
    
    Bildchen: ein 16x16-Pixmap(-Ausschnitt).
    
    Schema: System, nach dem die Blob-Bildchen mit Anschlssen aus den xpms
    erzeugt werden
 */

class Cuyo : public QWidget {
  Q_OBJECT
    public:
  /** construtor */
  Cuyo(QWidget*parent=0,const char* name=0);
  /** destructor */
  ~Cuyo();
  /** liefert true, wenn das Spiel normal luft, false
      wenn das Spiel am zuende gehen ist. (Liefert whrend Pause
      auch true) */
  bool spielLaeuft();
  /** liefert true, wenn das Spiel gepaust ist. */
  bool spielPause() { return mGModus == gmodus_pause; }
  /** Liefert die Anzahl der Mitspieler zurck. */
  bool getSpielerZahl() const;


  /***** Debug-Variablen *****/
  /* Es gibt auerdem noch die globale Variable gDebug; */
  bool mZeitlupe;
  int mZaehlerZeitlupe;
  bool mRueberReihenTest;
  /** Fr verschiedenes... */
  bool mFlag;



  /** Das Bild, das angezeigt wird, whrend das Spiel auf Pause steht.
      (Etwas provisorisch public) */
  Bilddatei * mPauseBild;


 protected: // Private attributes


  /***** Q-Objekt-Variablen (widgets u. .) *****/
  /** Die Menleiste */
  QMenuBar* mMenuBar;
  /** Das Men */
  QPopupMenu * mSpielMenu;
  /** Die beiden Spielfelder... */
  Spielfeld* mSpielfeld[max_spielerzahl];
  /** Die Punkte-Anzeigen */
  QLabel * punkteLabel[max_spielerzahl];

  /** Der Timer fr's eigentliche Spiel. Wird in startSpiel() erzeugt
      und in stopSpiel() vernichtet */
  QTimer * mTimer;
  /** Computer-Spieler. (Existiert immer.) */
  KIPlayer * mKI;



  /***** Zustandsvariablen *****/

  /** global-Modus (Spielerbergreifend). ** Nur mit setGModus() ndern! ** */
  int mGModus;
  /** true, wenn das Spiel grad nicht weitergehen soll, sondern auf einen
      Tastendruck gewartet wird. (Wird dann von tasteWeiter() wieder auf
      true gesetzt.) */
  bool mWarteAufTaste;
  /* Wenn > 0, wird hchstens so lange auf Taste gewartet */
  int mWarteTimeout;
  
  /** Ein oder zwei Spieler? */
  int mSpielerZahl;
  /** Falls zwei Spieler: Gegen Computer? */
  bool mGegenKI;

  /** Aktuelle Level-Nummer; enthlt, wenn grade kein Spiel luft, die Nummer
      vom Level zum weiterspielen. Ist (wenn kein Spiel luft) 0, wenn es
      keine vorige Level-Nummer gibt */
  int mLevelNr;
  int mPunkte[max_spielerzahl];
  /** Wie viel Gras noch da ist; wenn = 0, dann neuer Level */
  int mGrasDaAnz;
  /** Wird nur whrend der Zeitbonus-Animation gebraucht... */
  int mZeitBonus;
	
  /***** Variablen aus den preferences *****/
  /** Die Steuer-Tasten... */
  int mTasten[max_spielerzahl][4];
  /** true, wenn im 1-Spieler-Modus die Tasten von Spieler 2 verwendet werden
      sollen */
  //bool mTaste1Spieler;
  /** Welche Level wurden schon gewonnen: im 1-Spieler-Modus und im
      Mehr-Spieler-Modus */
  QStrList mGewonneneLevel[2];
	
		
 public slots: // Public slots
  /** Fhrt alle Men-Befehle aus */
  void MenuAufruf(int id);
  /** stoppt das Spiel sofort (egal, ob grad ein Level luft oder nicht) */
  void stopSpiel();
  /** setzt Level hoch u. . */
  void spielSchritt();
  /**  */
  void neuePunkte(bool reSp, int pt);
  /**  */
  void grasGeplatzt();
  /** wird aufgerufen, wenn ein Spieler tot ist */
  void spielerTot();
  /** wird aufgerufen, wenn der Benutzer was-auch-immer
      fertiggelesen (und eine Taste gedrckt) hat. */
  void tasteWeiter();
 protected: // Protected methods
  /**  */
  void MenuErz();
  /** Startet das Spiel */
  void startSpiel();
  /** tut alles, was beim Starten eines Levels
      getan werden muss; liefert false, wenn es
      den Level gar nicht mehr gibt. Throwt bei Fehler. */
  bool startLevel();
  /** tut alles, was beim Stoppen eines Levels
      getan werden muss (ohne Animation, d. h. entweder
      ist die Animation schon vorbei oder es gibt halt keine).
      Wenn malen = true ist, Bildschirm sofort updaten */
  void stopLevel(bool malen);
  /**  */
  void setPunkte(int sp, int pu);
  /** Ein key-Event halt... (Kmmert sich um alle Tasten,
      die whrend des Spiels so gedrckt werden...) */
  void keyPressEvent(QKeyEvent * e);
  /** Ldt die Preferences aus wo-auch-immer-sie-abgespeichert-werden
      in die Variablen. */
  void liesPreferences();
  /** Schreibt die Preferences nach wo-auch-immer-sie-abgespeichert-werden. */
  void schreibPreferences();
  /** Setzt die Anzahl der Spieler. Auch in der Menleiste. */
  void setSpielerZahl(int a);
  /** ndert mGModus und aktualisiert das Enabled-Sein der Mens. */
  void setGModus(int gm);
  /** Setzt das Enabled-Sein der Mens auf das Richtige,
      abhngig von mGModus und mLevelNr */
  void aktualisiereMenuEnabled();
  /** Liefert den Namen und Pfad der Prefs-Datei zurck
      ($HOME/.cuyo) */
  __String getPrefsName() const;
};
#endif

