/***************************************************************************
                          bilddatei.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include <qimage.h>
#include <qpainter.h>

#include "cuyointl.h"
#include "bilddatei.h"
#include "leveldaten.h"
#include "fehler.h"
#include "pfaditerator.h"

#include "xpmladen.h"


Bilddatei::Bilddatei() {
}
Bilddatei::~Bilddatei() {
}


/** Ldt das Bild mit dem angegebenen Namen. Throwt ggf. */
void Bilddatei::laden(__String name) {
  QImage im;
  ladImage(im, name);
  mBild.convertFromImage(im, __ColorOnly);
}


/** Ldt das Bild mit dem angegebenen Namen und ndert alles, was wei ist,
    in die angegebene Farbe. Throwt ggf. */
void Bilddatei::ladenSpezial(__String name, QColor weissersatz) {
  QImage im;
  ladImage(im, name);
  
  /* Farbe verndern */
  for (int _ = 0; _ < im.numColors(); _++)
#if QT_VERSION >= 200
    if (im.color(_) == qRgb(255, 255, 255))
      im.setColor(_, weissersatz.rgb() | 0xff000000);
#else
  if (im.color(_) & RGB_MASK == qRgb(255, 255, 255))
    im.setColor(_, weissersatz.rgb() | 0xff000000);
  //                                   ~~~~~~~~~~~~
  // Warum ist das ntig, damit's funktioniert?
#endif
  
  mBild.convertFromImage(im, __ColorOnly);
}



/** ldt ein Bildchen und speichert es in bild; sucht in verschiedenen
    Pfaden danach. Throwt ggf. */
void Bilddatei::ladImage(QImage & bild, __String name){
  __String s;
  s.sprintf("pics/%s", name.data());

  /* Bild in verschiedenen Pfaden suchen... (Der Pfaditerator throwt ggf.) */
  //for (PfadIterator pi(s); !bild.load(pi.pfad()); ++pi);
  for (PfadIterator pi(s); !ladXPM(bild, pi.pfad()); ++pi);
}


/** malt das k-te Viertel vom n-te Bildchen an xx,yy. Oder evtl. das
    ganze Bildchen */
void Bilddatei::malBildchen(QPainter & p, int xx, int yy,
			    int n, int k /*= viertel_alle*/) const {

  /* bitBlt geht ein kleines bisschen schneller als drawPixmap... */

  QPoint pos = bildchenPos(n);
  if (k == viertel_alle)
    bitBlt(p.device(), QPoint(xx, yy), &mBild, QRect(pos, QSize(gric, gric)));
    //p.drawPixmap(QPoint(xx, yy), mBild, QRect(pos, QSize(gric, gric)));
  else {
    if (k == viertel_ro || k == viertel_ru) pos += QPoint(gric/2, 0);
    if (k == viertel_lu || k == viertel_ru) pos += QPoint(0, gric/2);
    bitBlt(p.device(), QPoint(xx, yy), &mBild, QRect(pos, QSize(gric/2, gric/2)));
    //p.drawPixmap(QPoint(xx, yy), mBild, QRect(pos, QSize(gric/2, gric/2)));
  }
}


/** liefert die Pos des Bildchens Nr. n */
QPoint Bilddatei::bildchenPos(int n) const {

  if (n >= anzBildchen()) {
    __String s;
    s.sprintf(_("Error: Pixmap too small for Icon %d"), n);
    throw Fehler(s);
  }

  int bpr = mBild.width() / gric; /* Bildchen pro Reihe... */
  int y = n / bpr;
	
  return QPoint(gric * (n % bpr), gric * y);
}

/** liefert zurck, wie viele Bildchen in dieser Datei sind. */
int Bilddatei::anzBildchen() const{
  return (mBild.width() / gric) * (mBild.height() / gric);
}

/** liefert die Gesamthoehe in Pixeln zurck */
int Bilddatei::getBreite() const {
  return mBild.width();
}

/** liefert die Gesamthoehe in Pixeln zurck */
int Bilddatei::getHoehe() const {
  return mBild.height();
}

/** malt das gesamte Bild */
void Bilddatei::malBild(QPainter & p, int xx, int yy) const{
  p.drawPixmap(QPoint(xx, yy), mBild);
}
