import AllSolutions
import Combinatorial
import Integer

-- apply a function to all list elements (predefined as `map'):
map_ ::  (a->b) -> [a] -> [b]

map_ _ []      = []
map_ f (x:xs)  = f x : map_ f xs

-- accumulate all list elements (predefined as `foldr'):
foldr_ ::  (a->b->b) -> b -> [a] -> b

foldr_ _ z []     = z
foldr_ f z (h:t)  = f h (foldr_ f z t)

-- increment function:
inc x = x+1

-- goals:
-- increment list elements:
g1 = map inc [0,2,1]
g2 = map (+ 1) [0,2,1]
-- sum of all list elements:
g3 = foldr (+) 0 [1,0,2]
-- product of all list elements:
g4 = foldr (*) 1 [1,2,3,4,5]
g5 = foldr (\ x y ->x * y) 1 [1,2,3,4,5]


-- Some demos of monadic I/O:

-- a simple echo:

echo = getChar >>= \c -> if    ord c == (-1) then    done    else putChar c >> echo


-- a simple dialog:
dialog = putStrLn "Ihr Name?" >> getLine >>= processName
  where processName str = putStr "Hallo " >>
                          putStr str >>
                          putStr ", rueckwaerts lautet Ihr Name: " >>
                          putStrLn (rev str)

rev []     = []
rev (x:xs) = rev xs++[x]

-- a call to "nondet" is not allowed since it would duplicate the world:
nondet :: IO ()
nondet | generate x  = putChar x  where x free

generate 'a' = success
generate 'b' = success

-- copy a file:
copyFile :: String -> String -> IO ()
copyFile from to = readFile from >>= writeFile to

-- reading and writing integers:
-- write an integer:
putInt n = if n<0 then putChar '-' >> putInt (-n) else if n<=9 then putChar(chr(ord '0' + n))
                     else putInt (n `div` 10) >>
                        putChar(chr(ord '0' + n `mod` 10))

-- parse an integer:
parseInt l = parseIntPrefix (dropWhile (==' ') l) 0
 where
   parseIntPrefix []     n = n
   parseIntPrefix (c:cs) n =
    let oc = ord c
      in if c==' ' then   n    else
        if c=='-' then  - parseIntPrefix cs n else
           if oc>=ord '0' && oc<=ord '9'
                 then parseIntPrefix cs (n*10+(oc)-(ord '0'))
                   else 0

-- read an integer:
getInt = getLine >>= \s -> return (parseInt s)

-- factorial function:
fac n | n==0      = 1
        | otherwise = fac(n-1)*n

-- an interactive factorial computation:
facint =
  putStr "Factorial computation: Type in a small natural number: " >>
  getInt >>= \n ->
  putStr "The factorial of  " >> putInt n >>
  putStr " is " >> putInt (fac n) >> putChar '\n'

-- Curry's solution to the "diamond" problem of the
-- Prolog programming contest at JICSLP'98 in Manchester

diamond n = lineloop1 1 1 >> lineloop2 1 (n*n-n+2)  where

 lineloop1 i j = if i<=n then   line j i >> lineloop1 (i+1) (j+n) else   done

 lineloop2 i j = if i<n then line j (n-i) >> lineloop2 (i+1) (j+1)    else done

 line s e = tab((n-e)*(size(n*n)+1)) >> lineloop 1 s
   where
      lineloop i t =
             if i<=e
             then putValue t >> tab (size(n*n)+1) >> lineloop (i+1) (t-n+1)
             else putChar '\n'

      putValue v = tab((size(n*n)+1)-size(v)) >> putStr (show v)


tab n = if n==0
  then done
    else putChar ' ' >> tab (n-1)

-- number of characters for the string representation of a number:
size n = if n<10 then 1
                    else size (n `div` 10) + 1

-- quicksort using a split function (demonstrating where/let declarations):

split _ [] = ([],[])
split e (x:xs) | e>=x  = (x:l,r)
                 | e<x   = (l,x:r)
               where (l,r) = split e xs


qsort []     = []
qsort (x:xs) = let (l,r) = split x xs
                in qsort l ++ (x:qsort r)


infixr 5 **

(**) :: [a] -> [a] -> [a]
a ** b = a Prelude.++ b


conc :: [a] -> [a] -> [a]
conc = (**)

-- some functions generating infinite lists:


-- the list of natural numbers:
from n = n : from (n+1)


-- Fibonacci numbers:
fibs = fibgen 1 1
fibgen n1 n2 = n1 : fibgen n2 (n1+n2)


-- the list of primes generated by the
-- Sieve of Erathostenes:
primes = sieve (from 2)

sieve (x:xs) = x : sieve (filter (\y -> y `mod` x > 0) xs)


-- Hamming numbers:
ordMerge (x:xs) (y:ys) | x==y = x:ordMerge xs ys
                         | x<y  = x:ordMerge xs (y:ys)
                      | x>y  = y:ordMerge (x:xs) ys

hamming = 1:ordMerge (map (*2) hamming)
                     (ordMerge (map (*3) hamming)
                               (map (*5) hamming))

married Christine Antony  = True
married Maria Bill        = True

mother Christine John   = True
mother Christine Alice  = True


father f c | let m free in (married m f && mother m c) =:= True  = True


grandfather g c | let f free
                   in (father g f && father f c) =:= True  = True
grandfather g c | let m free
                    in (father g m && mother m c) =:= True  = True


-- Some examples for the use of the module AllSolutions
-- The famous non-deterministic function:
coin :: Int
coin = 0
coin = 1

-- Principal use of getAllSolutions:
all1 = getAllSolutions (=:=(coin+coin)) >>= print

-- This example shows that no sharing is performed accress encapsulated search:
all2 = let cc = coin+coin in
  getAllSolutions (=:=cc) >>= print >>
  getAllSolutions (=:=cc) >>= print

-- Example for getOneValue:
first1 = getOneValue (coin+coin) >>= print

-- Generate search tree of depth 0 (similar to getAllSolutions):
tree0 = getSearchTree [] (=:=(x+y)) >>= print
        where
          x=coin
          y=coin
--> (Solutions [0,1,1,2])

-- Generate search tree of depth 1:
tree1 = getSearchTree [x+5] (=:=(x+y)) >>= print
        where
          x=coin
          y=coin
--> (SearchBranch [(5,(Solutions [0,1])),(6,(Solutions [1,2]))])

-- Generate search tree of depth 2:
tree2 = getSearchTree [x,y] (=:=(x+y=:=1)) >>= print
        where
          x=coin
          y=coin
--> (SearchBranch [(0,(SearchBranch [(0,(Solutions [])),(1,(Solutions [success]))])),(1,(SearchBranch [(0,(Solutions [success])),(1,(Solutions []))]))])


-- An application of getAllFailures:
--
-- Place n queens on a chessboard so that no queen can capture another queen: (this solution is due to Sergio Antoy)

queens n = getAllFailures (permute [1..n]) capture

capture y = let l1,l2,l3,y1,y2 free in
  l1 ++ [y1] ++ l2 ++ [y2] ++ l3 =:= y & abs (y1-y2) =:= length l2 + 1
