#ifndef __NeXT_NeXTKeymap_h
#define __NeXT_NeXTKeymap_h
//=============================================================================
//
//	Copyright (C)2000 by Eric Sunshine <sunshine@sunshineco.com>
//
// The contents of this file are copyrighted by Eric Sunshine.  This work is
// distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
// PARTICULAR PURPOSE.  You may distribute this file provided that this
// copyright notice is retained.  Send comments to <sunshine@sunshineco.com>.
//
//=============================================================================
//-----------------------------------------------------------------------------
// NeXTKeymap.h
//
//	A translation table which maps hardware scan codes to the raw
//	characters generated by those scan codes without any modifier keys
//	active.
//
//	See NeXTKeymap.m for an exhaustive explanation of purpose and use of
//	this class.
//
//-----------------------------------------------------------------------------
#import <objc/Object.h>
struct DataStream;

typedef struct _NeXTKeymapBinding
{
  unsigned short code;
  unsigned short character_set;
} NeXTKeymapBinding;

@interface NeXTKeymap : Object
{
@private
  NeXTKeymapBinding* bindings;
  unsigned long nbindings;
}

- (id)init;
- (id)free;
- (BOOL)isScanCodeBound:(unsigned short)code;
- (NeXTKeymapBinding const*)bindingForScanCode:(unsigned short)code;

@end

#endif // __NeXT_NeXTKeymap_h
