/*
 *  declarations for encryption/security mechanisms for cryptmount
 *  $Revision: 130 $, $Date: 2006-10-15 11:42:36 +0100 (Sun, 15 Oct 2006) $
 *  Copyright 2005-2006, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _ARMOUR_H
#define _ARMOUR_H

struct keyinfo;
struct cment;

void *sec_realloc(void *ptr, size_t size);
void mem_cleanse(unsigned char *addr, size_t sz);
void sec_free(void *ptr);


typedef struct keymanager {
    const char *ident;

    int initialized;
    int (*init_algs)();
    int (*free_algs)();

    /* replace NULL algo-fields in keyinfo with suitable defaults: */
    void (*mk_default)(struct keyinfo *keyinfo);

    /* determine whether this keymanager can handle given key: */
    int (*is_compat)(const struct keyinfo *keyinfo);

    /* extract encrypted key from file: */
    int (*get_key)(const char *ident, const struct keyinfo *keyinfo,
                    unsigned char **key, int *keylen, FILE *fp_key);

    /* write encrypted key into file: */
    int (*put_key)(const char *ident, const struct keyinfo *keyinfo,
                    const unsigned char *key, const int keylen, FILE *fp_key);

    /* message-digest computation (used as source of entropy): */
    void* (*md_prepare)();
    void (*md_block)(void *state, unsigned char *buff, unsigned len);
    void (*md_final)(void *state, unsigned char **mdval, unsigned *mdlen);
    void (*md_release)(void *state);

} keymanager_t;


keymanager_t *get_keymanager(const struct keyinfo *keyinfo);


int init_algorithms();
int free_algorithms();

keymanager_t *init_keymanager(keymanager_t *km);
int free_keymanagers();

int is_keysafe(const struct keyinfo *keyinfo);
int get_randkey(unsigned char *key, unsigned len);
int get_key(const char *ident, const struct keyinfo *keyinfo,
            unsigned char **key, int *keylen);
int put_key(const char *ident, const struct keyinfo *keyinfo,
            const unsigned char *key, const int keylen, FILE *fp_key);
int mk_key_string(const unsigned char *key, const int keylen, char *buff);

int sycheck_cmtab(const char *cmtab);
int sycheck_target(const struct cment *ent);

int cm_mutex_lock();
int cm_mutex_unlock();

#endif  /* _ARMOUR_H */

/*
 *  (C)Copyright 2005-2006, RW Penney
 */
