char *def_sounds[] = {
"#\n",
"# This is a reasonably heavily modified version of the sounds file from\n",
"# the server.\n",
"#\n",
"# Since the client has to load the sounds on its own, full path names\n",
"# are needed.\n",
"#\n",
"# There are two sections - one for normal sounds, and one for spell\n",
"# sounds.  They are differentiated by the header 'Standard Sounds:' and\n",
"# 'Spell Sounds:'\n",
"#\n",
"# Empty lines and lines starting with # are ignored.\n",
"#\n",
"# Format of the file:  pathname to sound, default volume (what volume gets\n",
"# played if it is centered on the player), symbolic name (not currently\n",
"# used for anything, but may be in the future for the server to communicated\n",
"# to the client), and sound number..  Symbolic name and sound number may\n",
"# be ommitted.  If sound number is missing, the sound will be assigned one\n",
"# higher than the last sound read in.\n",
"#\n",
"# the symbolic name can be DEFAULT, in which case all sounds for that section\n",
"# which are otherwise not set will be set to that value.  This can be\n",
"# especially useful for that magic section, since new spells get added\n",
"# fairly often.\n",
"#\n",
"# The volume of 100 means max volume.  Anything higher may break the sound\n",
"# handling.\n",
"#\n",
"# The server currently communicates what sound to play via the sound\n",
"# number - you should not change those.  However, you can change most\n",
"# of the other sounds without problem.\n",
"#\n",
"# If a copy of this file is in ~/.crossfire/, it will be loaded\n",
"#\n",
"Standard Sounds:\n",
"\n",
"/crossfire-client/sounds/su-fanf.raw	 30	SOUND_NEW_PLAYER	0\n",
"/crossfire-client/sounds/Teeswing.raw 	 80	SOUND_FIRE_ARROW	1\n",
"/crossfire-client/sounds/chord.raw	100	SOUND_LEARN_SPELL	2\n",
"/crossfire-client/sounds/Missed.raw	 70	SOUND_FUMBLE_SPELL	3\n",
"/crossfire-client/sounds/Missed.raw	 70	SOUND_WAND_POOF		4\n",
"/crossfire-client/sounds/Creaky-1.raw	 90	SOUND_OPEN_DOOR		5\n",
"/crossfire-client/sounds/blip.raw 	 80	SOUND_PUSH_PLAYER	6\n",
"/crossfire-client/sounds/click1.raw	 60	SOUND_PLAYER_HITS1	7\n",
"/crossfire-client/sounds/click2.raw	 70	SOUND_PLAYER_HITS2	8\n",
"/crossfire-client/sounds/click1.raw	 80	SOUND_PLAYER_HITS3	9\n",
"/crossfire-client/sounds/click2.raw	 90	SOUND_PLAYER_HITS4	10\n",
"/crossfire-client/sounds/FloorTom.raw	 70	SOUND_PLAYER_IS_HIT1	11\n",
"/crossfire-client/sounds/ouch1.raw	 80	SOUND_PLAYER_IS_HIT2	12\n",
"/crossfire-client/sounds/thru.raw 	 90	SOUND_PLAYER_IS_HIT3	13\n",
"/crossfire-client/sounds/drip.raw 	 80	SOUND_PLAYER_KILLS	14\n",
"/crossfire-client/sounds/squish.raw	 80	SOUND_PET_IS_KILLED	15\n",
"/crossfire-client/sounds/gong.raw 	150	SOUND_PLAYER_DIES	16\n",
"/crossfire-client/sounds/Whoosh.raw	100	SOUND_OB_EVAPORATE	17\n",
"/crossfire-client/sounds/Explosion.raw	100	SOUND_OB_EXPLODE	18\n",
"/crossfire-client/sounds/TowerClock.raw	130	SOUND_CLOCK		19\n",
"/crossfire-client/sounds/boink2.raw 	 80	SOUND_TURN_HANDLE	20\n",
"/crossfire-client/sounds/MetalCrash.raw 	200	SOUND_FALL_HOLE		21\n",
"/crossfire-client/sounds/Puke.raw 	130	SOUND_DRINK_POISON     	22\n",
"\n",
"# Spells :		SOUND_CAST_SPELL_0      23, 24, 25 ...\n",
"Spell Sounds:\n",
"\n",
"/crossfire-client/sounds/magic.raw	100	DEFAULT\n",
"/crossfire-client/sounds/swish.raw	 70	\"magic bullet\" 			/* 0 */\n",
"/crossfire-client/sounds/swish.raw	 60	\"small fireball\"\n",
"/crossfire-client/sounds/swish.raw	 80	\"medium fireball\"\n",
"/crossfire-client/sounds/swish.raw	100	\"large fireball\"\n",
"/crossfire-client/sounds/magic.raw	100	\"burning hands\"\n",
"/crossfire-client/sounds/lightning1.raw	 70	\"small lightning\"\n",
"/crossfire-client/sounds/lightning1.raw	 90	\"large lightning\"\n",
"/crossfire-client/sounds/swish.raw	100	\"magic missile\"\n",
"/crossfire-client/sounds/magic.raw	100	\"create bomb\"\n",
"/crossfire-client/sounds/magic.raw	100	\"summon golem\"\n",
"/crossfire-client/sounds/magic.raw	100	\"summon fire elemental\"		/* 10 */\n",
"/crossfire-client/sounds/magic.raw	100	\"summon earth elemental\"\n",
"/crossfire-client/sounds/magic.raw	100	\"summon water elemental\"\n",
"/crossfire-client/sounds/magic.raw	100	\"summon air elemental\"\n",
"/crossfire-client/sounds/first_try.raw	100	\"dimension door\"\n",
"/crossfire-client/sounds/magic.raw	100	\"create earth wall\"\n",
"/crossfire-client/sounds/Tear.raw 	100	\"paralyze\"\n",
"/crossfire-client/sounds/Missle1.raw	 80	\"icestorm\"\n",
"/crossfire-client/sounds/magic.raw	100	\"magic mapping\"\n",
"/crossfire-client/sounds/Tear.raw 	 90	\"turn undead\"\n",
"/crossfire-client/sounds/Tear.raw 	 90	\"fear\"				/* 20 */\n",
"/crossfire-client/sounds/Missle1.raw	100	\"poison cloud\"\n",
"/crossfire-client/sounds/magic.raw	100	\"wonder\"\n",
"/crossfire-client/sounds/Explosion.raw	 80	\"destruction\"\n",
"/crossfire-client/sounds/magic.raw	100	\"perceive self\"\n",
"/crossfire-client/sounds/sci_fi_gun.raw	100	\"word of recall\"\n",
"/crossfire-client/sounds/magic.raw	100	\"invisible\"\n",
"/crossfire-client/sounds/magic.raw	100	\"invisible to undead\"\n",
"/crossfire-client/sounds/magic.raw	100	\"probe\"\n",
"/crossfire-client/sounds/swish.raw	100	\"large bullet\"\n",
"/crossfire-client/sounds/magic.raw	100	\"improved invisibility\"		/* 30 */\n",
"/crossfire-client/sounds/Tear.raw 	100	\"holy word\"\n",
"/crossfire-client/sounds/magic.raw	100	\"minor healing\"\n",
"/crossfire-client/sounds/magic.raw	100	\"medium healing\"\n",
"/crossfire-client/sounds/magic.raw	100	\"major healing\"\n",
"/crossfire-client/sounds/magic.raw	100	\"heal\"\n",
"/crossfire-client/sounds/magic.raw	100	\"create food\"\n",
"/crossfire-client/sounds/Explosion.raw	 60	\"earth to dust\"\n",
"/crossfire-client/sounds/magic.raw	100	\"armour\"\n",
"/crossfire-client/sounds/magic.raw	100	\"strength\"\n",
"/crossfire-client/sounds/magic.raw	100	\"dexterity\"			/* 40 */\n",
"/crossfire-client/sounds/magic.raw	100	\"constitution\"\n",
"/crossfire-client/sounds/magic.raw	100	\"charisma\"\n",
"/crossfire-client/sounds/magic.raw	100	\"create fire wall\"\n",
"/crossfire-client/sounds/magic.raw	100	\"create frost wall\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from cold\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from electricity\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from fire\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from poison\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from slow\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from paralysis\"	/* 50 */\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from draining\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from magic\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from attack\"\n",
"/crossfire-client/sounds/magic.raw	100	\"levitate\"\n",
"/crossfire-client/sounds/Gun-5.raw	100	\"small speedball\"\n",
"/crossfire-client/sounds/Gun-5.raw	130	\"large speedball\"\n",
"/crossfire-client/sounds/Missle1.raw	150	\"hellfire\"\n",
"/crossfire-client/sounds/Missle1.raw	170	\"dragonbreath\"\n",
"/crossfire-client/sounds/Missle1.raw	170	\"large icestorm\"\n",
"/crossfire-client/sounds/magic.raw	100	\"charging\"			/* 60 */\n",
"/crossfire-client/sounds/magic.raw	100	\"polymorph\"\n",
"/crossfire-client/sounds/swish.raw	200	\"cancellation\"\n",
"/crossfire-client/sounds/Tear.raw 	100	\"confusion\"\n",
"/crossfire-client/sounds/Tear.raw 	150	\"mass confusion\"\n",
"/crossfire-client/sounds/magic.raw	100	\"summon pet monster\"\n",
"/crossfire-client/sounds/magic.raw 	100	\"slow\"\n",
"/crossfire-client/sounds/magic.raw	100	\"regenerate spellpoints\"\n",
"/crossfire-client/sounds/magic.raw	100	\"cure poison\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from confusion\"\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from cancellation\"	/* 70 */\n",
"/crossfire-client/sounds/magic.raw	100	\"protection from depletion\"\n",
"/crossfire-client/sounds/magic.raw	100	\"alchemy\"\n",
"/crossfire-client/sounds/Evil_Laugh.raw	100	\"remove curse\"\n",
"/crossfire-client/sounds/Evil_Laugh.raw	120	\"remove damnation\"\n",
"/crossfire-client/sounds/magic.raw	100	\"identify\"\n",
"/crossfire-client/sounds/magic.raw	100	\"detect magic\"\n",
"/crossfire-client/sounds/magic.raw	100	\"detect monster\"\n",
"/crossfire-client/sounds/magic.raw	100	\"detect evil\"\n",
"/crossfire-client/sounds/magic.raw	100	\"detect curse\"\n",
"/crossfire-client/sounds/Explosion.raw	100	\"heroism\"			/* 80 */\n",
"/crossfire-client/sounds/bugle_charge.raw	100	\"aggravation\"\n",
"/crossfire-client/sounds/magic.raw	100	\"firebolt\"\n",
"/crossfire-client/sounds/magic.raw	100	\"frostbolt\"\n",
"/crossfire-client/sounds/Explosion.raw	100	\"shockwave\"\n",
"/crossfire-client/sounds/magic.raw	100	\"color spray\"\n",
"/crossfire-client/sounds/magic.raw	100	\"haste\"\n",
"/crossfire-client/sounds/magic.raw	100	\"face of death\"\n",
"/crossfire-client/sounds/lightning1.raw	110	\"ball lightning\"\n",
"/crossfire-client/sounds/swish.raw	100	\"meteor swarm\"\n",
"/crossfire-client/sounds/swish.raw	100	\"comet\"				/* 90 */\n",
"/crossfire-client/sounds/magic.raw	100	\"mystic fist\"\n",
"/crossfire-client/sounds/magic.raw	100	\"raise dead\"\n",
"/crossfire-client/sounds/magic.raw	100	\"resurrection\"\n",
"/crossfire-client/sounds/magic.raw	100	\"reincarnation\"\n",
"/crossfire-client/sounds/magic.raw	100	\"immune cold\"\n",
"/crossfire-client/sounds/magic.raw	100	\"immune electricity\"\n",
"/crossfire-client/sounds/magic.raw	100	\"immune fire\"\n",
"/crossfire-client/sounds/magic.raw	100	\"immune poison\"\n",
"/crossfire-client/sounds/magic.raw	100	\"immune slow\"\n",
"/crossfire-client/sounds/magic.raw	100	\"immune paralysis\"		/* 100 */\n",
"/crossfire-client/sounds/magic.raw	100	\"immune drain\"\n",
"/crossfire-client/sounds/magic.raw	100	\"immune magic\"\n",
"/crossfire-client/sounds/magic.raw	100	\"immune attack\"\n",
"/crossfire-client/sounds/magic.raw	100	\"invulnerability\"\n",
"/crossfire-client/sounds/magic.raw	100	\"defense\n",
"/crossfire-client/sounds/magic.raw	100	\"rune fire\"\n",
"/crossfire-client/sounds/magic.raw	100	\"rune frost\"\n",
"/crossfire-client/sounds/magic.raw	100	\"rune shocking\"\n",
"/crossfire-client/sounds/magic.raw	100	\"rune blasting\"\n",
"/crossfire-client/sounds/magic.raw	100	\"rune death\"			/* 110 */\n",
"/crossfire-client/sounds/magic.raw	100	\"marking rune\"\n",
"/crossfire-client/sounds/magic.raw	100	\"build director\"\n",
"/crossfire-client/sounds/magic.raw	100	\"pool of chaos\"\n",
"/crossfire-client/sounds/magic.raw	100	\"build bullet wall\"\n",
"/crossfire-client/sounds/magic.raw	100	\"build ligtning wall\"\n",
"/crossfire-client/sounds/magic.raw	100	\"build fireball wall\"\n",
"/crossfire-client/sounds/magic.raw	100	\"magic \"\n",
"/crossfire-client/sounds/magic.raw	100	\"rune of magic drain\"\n",
"/crossfire-client/sounds/magic.raw	100	\"antimagic rune\"\n",
"/crossfire-client/sounds/magic.raw	100	\"rune transferrence\"		/* 120 */\n",
"/crossfire-client/sounds/magic.raw	100	\"transferrence\"\n",
"/crossfire-client/sounds/magic.raw	100	\"magic drain\"\n",
"/crossfire-client/sounds/magic.raw	100	\"counterspell\"\n",
"/crossfire-client/sounds/magic.raw	100	\"disarm\"\n",
"/crossfire-client/sounds/magic.raw	100	\"cure confusion\"\n",
"/crossfire-client/sounds/magic.raw	100	\"restoration\"\n",
"/crossfire-client/sounds/magic.raw	100	\"summon evil monster\"\n",
"/crossfire-client/sounds/magic.raw	100	\"counterwall\"\n",
"/crossfire-client/sounds/magic.raw	100	\"cause light wounds\"\n",
"/crossfire-client/sounds/magic.raw	100	\"cause medium wounds\"		/* 130 */\n",
"/crossfire-client/sounds/magic.raw	100	\"cause serious wounds\"\n",
"/crossfire-client/sounds/magic.raw	100	\"charm monsters\"\n",
"/crossfire-client/sounds/magic.raw	100	\"banishment\"\n",
"/crossfire-client/sounds/magic.raw	100	\"create missile\"\n",
};
