// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#include <Trace.hpp>
#include <PNG.hpp>
#include <SoftSurface.hpp>

SoftSurface::SoftSurface( int w, int h):
    BaseSurface( w, h)
{
    if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) 
    {
	LOG_ERROR << "Couldn't initialize SDL: " << SDL_GetError() << endl;
	exit(1);
    }
    Uint8  video_bpp = 8;
    Uint32 videoflags = SDL_SWSURFACE | SDL_FULLSCREEN;

    _surface = SDL_SetVideoMode(Width(), Height(), video_bpp, videoflags);

    SDL_ShowCursor( 0);
}

SoftSurface::~SoftSurface()
{
    SDL_Quit();
}

void SoftSurface::SetColor( int index, int red, int green, int blue)
{
    SDL_Color color;
    //the original code used 6-bit per color channel
    color.r = red << 2;
    color.g = green << 2;
    color.b = blue << 2;

    SDL_SetColors( _surface, &color, index, 1);
}

void SoftSurface::SetPixel( int x, int y, unsigned char colorIndex)
{
    Uint8 *p = (Uint8*) _surface->pixels;
    p[ y*_surface->pitch + x] = (Uint8)colorIndex;
}

unsigned char SoftSurface::GetPixel( int x, int y)
{
    Uint8 *p = (Uint8*) _surface->pixels;
    return (unsigned char) p[ y*_surface->pitch + x];
}

void SoftSurface::Flip( void)
{
    if(( _surface->flags & SDL_DOUBLEBUF) == SDL_DOUBLEBUF ) 
    {
	SDL_Flip( _surface);
    } 
    else 
    {
	SDL_UpdateRect( _surface, 0, 0, Width(), Height());
    }
}

void SoftSurface::Snapshot( void)
{
    //this is not exactly pretty...
    SDL_Surface *dummy =
        SDL_CreateRGBSurface(
	    SDL_SWSURFACE, Width(), Height(), 24, 
	    0x000000ff, 0x0000ff00, 0x00ff0000, 0x0);

    SDL_Surface *surface =
        SDL_ConvertSurface( _surface, dummy->format, SDL_SWSURFACE);

    PNG::Snapshot( surface, "snap.png");
}

//------------------------------------------------------------------------------
