[comment {-*- tcl -*- doctools manpage}]
[include version.inc]
[manpage_begin critcl_sources n [vset VERSION]]
[include include/module.inc]
[titledesc {Critcl - How To Get The Sources}]
[description]
[include include/welcome.inc]

[para] The audience of this document is anyone wishing to either have
just a look at Critcl's source code, or build the packages, or to
extend and modify them.

[para] For builders and developers we additionally provide

[list_begin enum]
[enum] [term {Critcl - License}].
[enum] [term {Critcl - The Installer's Guide}].
[enum] [term {Critcl - The Developer's Guide}].
[list_end]

respectively.

[section {Source Location}]

The official repository for Critcl can be found at
[uri http://andreas-kupries.github.com/critcl]

[section Retrieval]

Assuming that you simply wish to look at the sources, or build a
specific revision, the easiest way of retrieving it is to:

[list_begin enum]
[enum] Go to this site.
[enum] Follow the 'Fork me on Github' link (top-right corner) to the project sources.
[enum] Choose the revision under the Commits panel you wish to have and 
[enum] follow its 'Browse code' link to its detailed information page.
[enum] On that page, choose either the "ZIP" link to get a copy of this revision as a Zip archive.
[list_end]

[section {Source Code Management}]

For the curious (or a developer-to-be), the sources are managed by the
[uri http://www.git-scm.com {Git SCM}].

Binaries for popular platforms can be found directly at its
[uri http://www.fossil-scm.org/downloads {download page}].

[para]

With that tool available the full history can be retrieved via:

[example {
    git clone http://github.com/andreas-kupries/critcl
    cd critcl
}]

to get a checkout of the head of the trunk and move into it for browsing, editing, etc.

[include include/feedback.inc]
[manpage_end]

