// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

/////////////////////////////////////////////////////////////////////
// player.h
//
// Changes:
//   09-03-2001 - added p_briefing to Player class
//              - removed Create() and Load(), added constructor
//   29-04-2001 - added p_password and corresponding methods
/////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_PLAYER_H
#define _INCLUDE_PLAYER_H

#include "SDL.h"

#include "color.h"

#define PLAYER_ONE	0
#define PLAYER_TWO	1
#define PLAYER_NONE	2

#define LEVEL_EASY	1
#define LEVEL_NORMAL	2
#define LEVEL_HARD	3

#define P1_COLOR_LIGHT	0x00FEA604		// yellow
#define P1_COLOR_SHADOW	0x0056360C		// brown
#define P2_COLOR_LIGHT	0x0000AAFF		// light blue
#define P2_COLOR_SHADOW	0x0002265C		// dark blue

#define HUMAN           0
#define COMPUTER        1

#define MODE_OFF	0   // currently inactive
#define MODE_IDLE	1   // no unit selected
#define MODE_BUSY	2   // unit selected
#define MODE_REPLAY	3   // viewing turn history

class Player {
public:
  Player( SDL_RWops *file );
  int Save( SDL_RWops *file ) const;

  char Briefing( void ) const { return p_briefing; }
  void Colors( Color &light, Color &dark ) const
         { light = p_col_light; dark = p_col_dark; }
  unsigned char ID( void ) const { return p_id; }
  unsigned char Level( void ) const { return p_level; }
  unsigned char Mode( void ) const { return p_mode; }
  const char *Name( void ) const { return p_name; }
  const char *Password( void ) const;
  unsigned char Type( void ) const { return p_type; }

  void SetMode( unsigned char mode ) { p_mode = mode; }
  void SetPassword( const char *password );
  void SetType( unsigned char type ) { p_type = type; }

  unsigned char Success( char success ) { p_success += success; return p_success; }
  unsigned short Score( short points ) { p_score += points; return p_score; }
  unsigned short Units( short delta );

private:
  unsigned char p_id;
  unsigned char p_mode;
  unsigned char p_type;       // COMPUTER or HUMAN
  unsigned char p_level;
  unsigned short p_units;
  unsigned short p_score;

  unsigned char p_success;    // if p_success == 100 the level is completed
  char p_briefing;

  char p_name[16];
  char p_password[8];

  Color p_col_light;
  Color p_col_dark;
};

#endif	/* _INCLUDE_PLAYER_H */

