
/*
** Copyright 2000-2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"cmlmarchive.h"
#include	"afx/afx.h"
#include	"afx/afxtempl.h"
#include	"numlib/numlib.h"
#include        "rfc822/rfc822.h"
#include	<iostream>
#include	<iomanip>
#include	<fstream>
#include	<sysexits.h>
#include	<ctype.h>
#include	<stdio.h>
#include	<string.h>
#include	<fcntl.h>

#include <sys/types.h>
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

static const char rcsid[]="$Id: cmlmfetch.C,v 1.7 2004/09/14 23:35:36 mrsam Exp $";

////////////////////////////////////////////////////////////////////////////
//
//   Generate an archive index
//
////////////////////////////////////////////////////////////////////////////

struct idxinfo {
	CString		msgdate;
	CString		msgsubj;
	CString		msgsender;
	} ;

static void idxfirstlast(CString &buf, unsigned long f, unsigned long l)
{
char	fbuf[NUMBUFSIZE], lbuf[NUMBUFSIZE];
int	i;

	libmail_str_off_t(f, fbuf);
	libmail_str_off_t(l, lbuf);

	for (i=0; i+3<buf.GetLength(); i++)
	{
		if (buf[i] != '@' || buf[i+2] != '@')
			continue;
		switch (buf[i+1])	{
		case 'F':
			buf=buf.Left(i)+fbuf+buf.Mid(i+3);
			break;
		case 'L':
			buf=buf.Left(i)+lbuf+buf.Mid(i+3);
			break;
		}
	}
}

static void getmsginfo(unsigned long n, struct idxinfo &info)
{
	info.msgdate="";
	info.msgsubj="";
	info.msgsender="";

	CString	filename(Archive::filename(n));

	int msg_fd=open(filename, O_RDONLY);

	if (msg_fd < 0)
	  return;

	afxipipestream	msg(msg_fd);
	struct	stat	stat_buf;

	if (fstat(msg_fd, &stat_buf) == 0)
	{
	char	buf[200];
	struct	tm	*tmptr=localtime(&stat_buf.st_mtime);

		strftime(buf, sizeof(buf), "%x", tmptr);
		info.msgdate=buf;
	}

CString	headers;
CString	line;

	while ((line << msg) == 0)
	{
		headers += line;
		headers += '\n';
		if (headers.GetLength() == 0)	break;
	}
	msg.close();
	info.msgsubj=header(headers, "subject");
	info.msgsender=header(headers, "from");
	info.msgsubj.TrimLeft();
	info.msgsubj.TrimRight();
	info.msgsender.TrimLeft();
	info.msgsubj.TrimRight();
}

static void outhtml(ostream &o, const char *t)
{
	for ( ; *t; t++)
	{
		switch (*t){
		case ' ':
			o << "&nbsp;";
			break;
		case '&':
			o << "&amp;";
			break;
		case '<':
			o << "&lt;";
			break;
		case '>':
			o << "&gt;";
			break;
		default:
			o << (char)*t;
		}
	}
}

static int checksub(CString msg)
{
CString	from=header(msg, "from");

struct rfc822t *t=rfc822t_alloc(from, 0);

	if (!t)
	{
		perror("malloc");
		return (EX_TEMPFAIL);
	}

struct rfc822a *a=rfc822a_alloc(t);

	if (!a)
	{
		rfc822t_free(t);
		perror("malloc");
		return (EX_TEMPFAIL);
	}

char *nn=0;

	if (a->naddrs > 0)
	{
		nn=rfc822_getaddr(a, 0);
		if (!nn)
		{
			rfc822a_free(a);
			rfc822t_free(t);
			perror("malloc");
			return (EX_TEMPFAIL);
		}
	}
	rfc822a_free(a);
	rfc822t_free(t);
	if (nn)
	{
		from=nn;
		free(nn);
	}
	else	from="";

int	rc=is_subscriber(from);

	if (rc == EX_NOUSER)
	{
	CString	postoptions= cmdget("POSTARCHIVE");

		if (postoptions.GetLength() == 0 || postoptions == "all")
			rc=0;
	}

	if (rc)
	{
		if (rc == EX_NOUSER)
		{
			cout << "You are not subscribed to this mailing list."
				<< endl;
		}
		rc=EX_NOPERM;
	}
	return (rc);
}

int doindex(const char *n)
{
unsigned long nn=n ? atol(n):0;
CString	msg(readmsg());
int	i=msg.GetLength(), j;
unsigned long first=0, last=0;
unsigned long msgs[20];
struct	idxinfo msginfo[sizeof(msgs)/sizeof(msgs[0])];
int	nmsgs=0;

	for (j=1; j<i; j++)
		if (msg[j-1] == '\n' && msg[j] == '\n')
		{
			msg=msg.Left(j);
			break;
		}

int	rc=checksub(msg);

	if (rc)	return (rc);

	{
	ArchiveList	list;
	unsigned long x;

		while (list.Next(x) == 0)
		{
			if (!x)	continue;
			if (!first || x < first)	first=x;
			if (!last || x > last)		last=x;
			if ( nn && x > nn)	continue;
			if (nmsgs == sizeof(msgs)/sizeof(msgs[0]))
			{
				if (x < msgs[0])	continue;

				for (i=1; i<nmsgs; i++)
					msgs[i-1]=msgs[i];
				--nmsgs;
			}
			for (i=nmsgs; i; )
			{
				--i;
				if (msgs[i] < x)
				{
					++i;
					break;
				}
			}
			for (j=nmsgs; j>i; )
			{
				msgs[j]=msgs[j-1];
				--j;
			}
			msgs[i]=x;
			++nmsgs;
		}
	}

	for (i=0; i<nmsgs; i++)
		getmsginfo(msgs[i], msginfo[i]);

CString	addr;

	addr=header(msg, "reply-to");
	if (addr == "")	addr=header(msg, "from");

CString owner=get_verp_return("owner", 0);
pid_t	p;
afxopipestream ack(sendmail_bcc(p, owner));

	ack << "From: " << myname() << " <" << owner << ">" << endl
		<< "To: " << addr << endl
		<< "Bcc: " << addr << endl
		<< "Mime-Version: 1.0" << endl
		<< "Content-Type: multipart/mixed; boundary=courier1mlm" << endl
		<< "Content-Transfer-Encoding: 8bit" << endl;

	{
		int i=open("idxsubject.tmpl", O_RDONLY);

		if (i >= 0)
		{
			afxipipestream ifs(i);
			copyio_noseek(ifs, ack);
		}
	}

	ack << endl << "This is a MIME message" << endl << endl
		<< "--courier1mlm" << endl
		<< "Content-Type: multipart/alternative; boundary=courier2mlm"
				<< endl << endl
		<< "This is a MIME message" << endl << endl
		<< "--courier2mlm" << endl;


	{
	ifstream ifs("idxheadertxt.tmpl");
	CString	buf, line;

		while ((line << ifs) == 0)
		{
			buf += line;
			buf += "\n";
		}
		idxfirstlast(buf, first, last);
		ack << buf;
		for (i=0; i<nmsgs; i++)
		{
			ack << setiosflags(ios::right) << setw(10) << msgs[i]
				<< resetiosflags(ios::right) << " " <<
				setw(0) << msginfo[i].msgsubj << endl;
			ack << setiosflags(ios::right) << setw(10) <<
				msginfo[i].msgdate
				<< resetiosflags(ios::right) << " " <<
				setw(0) << msginfo[i].msgsender << endl << endl;
		}
	}

	ack << endl << "--courier2mlm" << endl;

	{
	ifstream ifs("idxheaderhtml.tmpl");
	CString	buf, line;

		while ((line << ifs) == 0)
		{
			buf += line;
			buf += "\n";
		}
		idxfirstlast(buf, first, last);
		ack << buf;

		for (i=0; i<nmsgs; i++)
		{
		char	buf[NUMBUFSIZE];
		char	buf2[10+NUMBUFSIZE];

			strcat(strcpy(buf2, "fetch-"),
				libmail_str_off_t(msgs[i], buf));

			ack << "<tr valign=top><td align=right>"
				"<a href=\"mailto:"
				<< get_verp_return(buf2, 0)
				<< "\">" << msgs[i]
				<< "</a><br />";
			outhtml(ack, msginfo[i].msgdate);
			ack << "</td><td>";
			outhtml(ack, msginfo[i].msgsubj);
			ack << "<br />";
			outhtml(ack, msginfo[i].msgsender);
			ack << "</td></tr>" << endl;
		}
	}

	{
		int i=open("idxheader2html.tmpl", O_RDONLY);

		if (i >= 0)
		{
			afxipipestream ifs(i);
			copyio_noseek(ifs, ack);
		}
	}

	ack << endl << "--courier2mlm--" << endl
		<< endl << "--courier1mlm" << endl
		<< "Content-Type: text/rfc822-headers"
		<< endl << endl
		<< msg << endl << "--courier1mlm--" << endl;
	ack.close();
	return (wait4sendmail(p));
}

////////////////////////////////////////////////////////////////////////////
//
//   Fetch messages from the archive
//
////////////////////////////////////////////////////////////////////////////

static const char *getn(const char *p, unsigned long &un)
{
	un=0;
	if (!isdigit((int)(unsigned char)*p))	return (0);

	while (isdigit((int)(unsigned char)*p))
	{
		un=un * 10 + (*p++ - '0');
	}
	return (p);
}

static int mkfetchlist(const char *fetchlist, CStringList &filenames)
{
CString	buf;

	while (*fetchlist)
	{
	unsigned long	from, to;

		if ((fetchlist=getn(fetchlist, from)) == 0)
		{
			cerr << "Invalid message number request." << endl;
			return (EX_SOFTWARE);
		}

		if (*fetchlist == '-')
		{
			++fetchlist;
			if ((fetchlist=getn(fetchlist, to)) == 0)
			{
				cerr << "Invalid message number request."
					<< endl;
				return (EX_SOFTWARE);
			}
		}
		else	to=from;
		if (*fetchlist == '+')	++fetchlist;

		{
		ArchiveList	list;
		unsigned long x;

			while (list.Next(x) == 0)
			{

				if (x < from || x > to)	continue;

			POSITION	pos;

				for (pos=filenames.GetTailPosition(); pos; )
				{
					buf=filenames.GetAt(pos);
					if ((unsigned long)atol(strrchr(buf,
						'/')+1) < x) break;
					filenames.GetPrev(pos);
				}

				buf=Archive::filename(x);

				if (pos)
					filenames.InsertAfter(pos, buf);
				else
					filenames.AddHead(buf);
			}
		}
	}
	return (0);
}

static int mkdigest(CStringList &msglist, int tmpfile_fd,
		    afxopipestream &tfile)
{
int	pipefd1[2], pipefd0[2];
pid_t	p;
CString	buf;

	if (pipe(pipefd1))
	{
		perror("pipe");
		return (EX_TEMPFAIL);
	}

	if (pipe(pipefd0))
	{
		perror("pipe");
		close(pipefd1[0]);
		close(pipefd1[1]);
		return (EX_TEMPFAIL);
	}

	if ((p=fork()) == -1)
	{
		perror("fork");
		close(pipefd1[0]);
		close(pipefd1[1]);
		close(pipefd0[0]);
		close(pipefd0[1]);
		return (EX_TEMPFAIL);
	}

	if (p == 0)
	{
		close(0);
		dup(pipefd0[0]);
		close(1);
		dup(pipefd1[1]);
		close(pipefd1[0]);
		close(pipefd1[1]);
		close(pipefd0[0]);
		close(pipefd0[1]);
		close(tmpfile_fd);
		execl(REFORMIME, "reformime", "-m", (char *)0);
		perror(REFORMIME);
		_exit(EX_TEMPFAIL);
	}
	close(pipefd0[0]);
	close(pipefd1[1]);

	{
	afxopipestream ofs(pipefd0[1]);

		while (!msglist.IsEmpty())
		{
			buf=msglist.RemoveHead();
			ofs << buf << endl;
		}
	}
	close(pipefd0[1]);

	afxipipestream	ifs(pipefd1[0]);

	buf=cmdget("MAXFETCHSIZE");

unsigned long	nbytes=atol(buf);

	if (nbytes == 0)	nbytes=100;
	nbytes *= 1024;

int	rc=copyio_noseek_cnt(ifs, tfile, &nbytes);

	ifs.close();
	close(pipefd1[0]);

int	waitstat;

	while ( wait(&waitstat) != p)
		;

	if (rc == 0)
	{
		rc=EX_SOFTWARE;
		if (WIFEXITED(waitstat))
			rc=WEXITSTATUS(waitstat);
	}
	return (rc);
}

int dofetch(const char *p)
{
CString	msg(readmsg());
CStringList	msglist;
int	i=msg.GetLength(), j;

	for (j=1; j<i; j++)
		if (msg[j-1] == '\n' && msg[j] == '\n')
		{
			msg=msg.Left(j);
			break;
		}

int	rc=checksub(msg);

	if (rc)	return (rc);

	rc=mkfetchlist(p, msglist);

	if (rc)	return (rc);

CString	tmpfile(TMP "/");

	tmpfile += mktmpfilename();

	trapsigs(tmpfile);

	int tmp_fd=open(tmpfile, O_RDWR|O_CREAT|O_TRUNC, 0666);

	if (tmp_fd < 0)
	  {
	    clearsigs(-1);
	    return (-1);
	  }

	afxopipestream	tmp_pipe(tmp_fd);

	rc=mkdigest(msglist, tmp_fd, tmp_pipe);

	tmp_pipe << flush;

	if (rc || tmp_pipe.bad())
	{
		rc= -1;
		tmp_pipe.close();
		clearsigs(rc);
		return (rc);
	}

	tmp_pipe.close();

	tmp_fd=open(tmpfile, O_RDONLY, 0666);

	if (tmp_fd < 0)
	{
		perror(tmpfile);
		clearsigs(-1);
		return (-1);
	}

	afxipipestream tmp(tmp_fd);

CString	addr;

	addr=header(msg, "reply-to");
	if (addr == "")	addr=header(msg, "from");

CString	boundary=mkboundary_msg(tmp);
CString owner=get_verp_return("owner", 0);
pid_t	pid;
afxopipestream ack(sendmail_bcc(pid, owner));

	ack << "From: " << myname() << " <" << owner << ">" << endl
		<< "To: " << addr << endl
		<< "Bcc: " << addr << endl
		<< "Mime-Version: 1.0" << endl
		<< "Content-Type: multipart/mixed; boundary=\""
			<< boundary << "\"" << endl
		<< "Content-Transfer-Encoding: 8bit" << endl;

	{
		int i_fd=open("fetchsubj.tmpl", O_RDONLY);

		if (i_fd >= 0)
		{
			afxipipestream ifs(i_fd);

			copyio_noseek(ifs, ack);
		}
	}


	ack << endl << "This is a MIME message" << endl
		<< endl << "--" << boundary << endl;

	{
		int i_fd=open("fetch.tmpl", O_RDONLY);

		if (i_fd >= 0)
		{
			afxipipestream ifs(i_fd);

			copyio_noseek(ifs, ack);
		}
	}

	ack << endl << "--" << boundary << endl
		<< "Content-Type: text/rfc822-headers" << endl << endl
		<< msg
		<< endl << "--" << boundary << endl;

	tmp.seekg(0);
	copyio_noseek(tmp, ack);
	ack << endl << "--" << boundary << "--" << endl;
	ack.close();
	tmp.close();
	unlink(tmpfile);
	clearsigs(0);
	return (wait4sendmail(pid));
}
