cat >certs/belsign-object-publishing-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, L=Brussels, O=BelSign NV, OU=BelSign Object Publishing Certificate Authority, CN=BelSign Object Publishing CA/Email=webmaster@belsign.be
        Validity
            Not Before: Sep 19 22:03:00 1997 GMT
            Not After : Sep 19 22:03:00 2007 GMT
        Subject: C=BE, L=Brussels, O=BelSign NV, OU=BelSign Object Publishing Certificate Authority, CN=BelSign Object Publishing CA/Email=webmaster@belsign.be
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c4:2e:1f:b6:bf:ee:82:40:dd:f9:b7:2e:41:d5:
                    9e:05:b1:5a:d0:26:7c:62:55:03:9b:fc:cb:61:de:
                    4b:ef:fe:e8:99:fe:87:b9:88:cf:90:da:0f:09:3c:
                    76:df:17:97:b6:cb:3f:25:45:fd:b4:bc:58:00:be:
                    b0:5a:b6:14:87:8f:ee:67:64:ad:1d:88:83:bb:67:
                    9f:65:61:00:58:08:80:50:9f:80:c9:31:f6:2a:90:
                    1c:2d:f7:4a:6c:10:f6:23:43:5d:38:09:60:88:57:
                    02:cd:16:6c:18:fc:cd:fb:92:2a:77:d0:9e:93:a3:
                    5d:88:64:d0:c8:f8:5d:54:51
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        63:76:17:7c:96:f0:53:a5:5d:01:1c:53:ce:29:c2:7e:75:ac:
        4c:0d:a2:08:73:b4:6a:31:fd:02:06:14:99:dc:54:04:a4:bf:
        c8:96:86:9f:31:43:32:25:57:f6:85:f6:25:bb:37:be:a1:79:
        23:c9:57:06:25:71:6b:45:4f:f8:f4:02:40:16:82:22:af:54:
        ea:32:28:f6:0d:ee:99:ba:4b:08:51:0f:6e:86:23:21:4c:2d:
        25:88:81:c4:2e:0e:f1:13:2c:38:8a:95:02:24:c3:3a:95:63:
        e4:93:8e:48:bb:08:47:72:5f:ae:e6:3a:5a:47:d6:71:c6:9e:
        9a:52
-----BEGIN CERTIFICATE-----
MIIDAzCCAmygAwIBAgIBATANBgkqhkiG9w0BAQQFADCBuzELMAkGA1UEBhMCQkUx
ETAPBgNVBAcTCEJydXNzZWxzMRMwEQYDVQQKEwpCZWxTaWduIE5WMTgwNgYDVQQL
Ey9CZWxTaWduIE9iamVjdCBQdWJsaXNoaW5nIENlcnRpZmljYXRlIEF1dGhvcml0
eTElMCMGA1UEAxMcQmVsU2lnbiBPYmplY3QgUHVibGlzaGluZyBDQTEjMCEGCSqG
SIb3DQEJARYUd2VibWFzdGVyQGJlbHNpZ24uYmUwHhcNOTcwOTE5MjIwMzAwWhcN
MDcwOTE5MjIwMzAwWjCBuzELMAkGA1UEBhMCQkUxETAPBgNVBAcTCEJydXNzZWxz
MRMwEQYDVQQKEwpCZWxTaWduIE5WMTgwNgYDVQQLEy9CZWxTaWduIE9iamVjdCBQ
dWJsaXNoaW5nIENlcnRpZmljYXRlIEF1dGhvcml0eTElMCMGA1UEAxMcQmVsU2ln
biBPYmplY3QgUHVibGlzaGluZyBDQTEjMCEGCSqGSIb3DQEJARYUd2VibWFzdGVy
QGJlbHNpZ24uYmUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMQuH7a/7oJA
3fm3LkHVngWxWtAmfGJVA5v8y2HeS+/+6Jn+h7mIz5DaDwk8dt8Xl7bLPyVF/bS8
WAC+sFq2FIeP7mdkrR2Ig7tnn2VhAFgIgFCfgMkx9iqQHC33SmwQ9iNDXTgJYIhX
As0WbBj8zfuSKnfQnpOjXYhk0Mj4XVRRAgMBAAGjFTATMBEGCWCGSAGG+EIBAQQE
AwIABzANBgkqhkiG9w0BAQQFAAOBgQBjdhd8lvBTpV0BHFPOKcJ+daxMDaIIc7Rq
Mf0CBhSZ3FQEpL/IloafMUMyJVf2hfYluze+oXkjyVcGJXFrRU/49AJAFoIir1Tq
Mij2De6ZuksIUQ9uhiMhTC0liIHELg7xEyw4ipUCJMM6lWPkk45IuwhHcl+u5jpa
R9Zxxp6aUg==
-----END CERTIFICATE-----
...EOF...
cat >certs/belsign-secure-server-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, L=Brussels, O=BelSign NV, OU=BelSign Secure Server Certificate Authority, CN=BelSign Secure Server CA/Email=webmaster@belsign.be
        Validity
            Not Before: Jul 16 22:00:54 1997 GMT
            Not After : Jul 16 22:00:54 2007 GMT
        Subject: C=BE, L=Brussels, O=BelSign NV, OU=BelSign Secure Server Certificate Authority, CN=BelSign Secure Server CA/Email=webmaster@belsign.be
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d6:01:12:78:92:f8:04:42:7f:c9:c7:22:83:fc:
                    7c:47:70:30:2b:49:0b:3e:36:40:90:28:da:21:73:
                    83:53:f2:c4:d1:16:40:c0:53:ff:ae:a6:c6:24:b3:
                    27:6d:a5:b3:3d:39:77:5d:a8:06:f6:e6:e9:bc:63:
                    11:4e:06:65:70:0a:9d:93:f9:a2:40:8b:7f:4a:84:
                    0e:8d:16:b1:d6:cc:08:64:12:0c:e0:28:4b:c8:a5:
                    84:90:17:fb:11:46:2e:d6:a7:85:18:cb:18:ae:63:
                    9a:b0:58:06:f4:00:cf:f8:c4:09:1a:35:0c:a1:f9:
                    ee:4a:fd:6d:de:fe:26:a5:3b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL Client, S/MIME
    Signature Algorithm: md5WithRSAEncryption
        6c:3d:99:c3:05:e2:1d:ca:e5:2d:aa:68:85:8b:40:31:20:66:
        13:68:e6:58:3a:89:d0:8d:75:b2:c5:62:d8:7d:82:8f:f7:d9:
        32:81:77:f6:35:5b:85:29:ce:67:b2:b9:bc:2b:19:78:cf:f3:
        87:fd:46:f1:95:75:b2:09:57:03:30:c1:7a:cd:72:47:71:80:
        ca:7d:9d:c9:65:3c:47:11:22:7d:fa:07:0b:28:78:a1:93:e8:
        05:45:48:e2:32:32:4a:3d:e8:53:1c:10:b7:c7:73:8c:07:50:
        e1:f9:c9:2b:53:41:f5:83:8d:e5:09:39:4a:8e:03:62:aa:40:
        63:8b
-----BEGIN CERTIFICATE-----
MIIC8zCCAlygAwIBAgIBATANBgkqhkiG9w0BAQQFADCBszELMAkGA1UEBhMCQkUx
ETAPBgNVBAcTCEJydXNzZWxzMRMwEQYDVQQKEwpCZWxTaWduIE5WMTQwMgYDVQQL
EytCZWxTaWduIFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MSEw
HwYDVQQDExhCZWxTaWduIFNlY3VyZSBTZXJ2ZXIgQ0ExIzAhBgkqhkiG9w0BCQEW
FHdlYm1hc3RlckBiZWxzaWduLmJlMB4XDTk3MDcxNjIyMDA1NFoXDTA3MDcxNjIy
MDA1NFowgbMxCzAJBgNVBAYTAkJFMREwDwYDVQQHEwhCcnVzc2VsczETMBEGA1UE
ChMKQmVsU2lnbiBOVjE0MDIGA1UECxMrQmVsU2lnbiBTZWN1cmUgU2VydmVyIENl
cnRpZmljYXRlIEF1dGhvcml0eTEhMB8GA1UEAxMYQmVsU2lnbiBTZWN1cmUgU2Vy
dmVyIENBMSMwIQYJKoZIhvcNAQkBFhR3ZWJtYXN0ZXJAYmVsc2lnbi5iZTCBnzAN
BgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA1gESeJL4BEJ/yccig/x8R3AwK0kLPjZA
kCjaIXODU/LE0RZAwFP/rqbGJLMnbaWzPTl3XagG9ubpvGMRTgZlcAqdk/miQIt/
SoQOjRax1swIZBIM4ChLyKWEkBf7EUYu1qeFGMsYrmOasFgG9ADP+MQJGjUMofnu
Sv1t3v4mpTsCAwEAAaMVMBMwEQYJYIZIAYb4QgEBBAQDAgCgMA0GCSqGSIb3DQEB
BAUAA4GBAGw9mcMF4h3K5S2qaIWLQDEgZhNo5lg6idCNdbLFYth9go/32TKBd/Y1
W4UpzmeyubwrGXjP84f9RvGVdbIJVwMwwXrNckdxgMp9ncllPEcRIn36BwsoeKGT
6AVFSOIyMko96FMcELfHc4wHUOH5yStTQfWDjeUJOUqOA2KqQGOL
-----END CERTIFICATE-----
...EOF...
cat >certs/class-1-public-primary-ocsp-responder.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            2b:68:d4:a3:46:9e:c5:3b:28:09:ab:38:5d:7f:27:20
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Validity
            Not Before: Aug  4 00:00:00 2000 GMT
            Not After : Aug  3 23:59:59 2004 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/RPA (c)00, CN=Class 1 Public Primary OCSP Responder
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b9:ed:5e:7a:3a:77:5f:ce:5f:3a:52:fc:cd:64:
                    f7:71:b5:6f:6a:96:c6:59:92:55:94:5d:2f:5b:2e:
                    c1:11:ea:26:8a:cb:a7:81:3c:f6:5a:44:de:7a:13:
                    2f:fd:5a:51:d9:7b:37:26:4a:c0:27:3f:04:03:6a:
                    56:c1:83:2c:e1:6f:5b:a9:54:50:24:4a:c6:2e:7a:
                    4c:a1:5b:37:54:24:21:31:1f:a1:78:18:76:a7:b1:
                    70:da:22:d0:6a:fe:07:62:40:c6:f7:f6:9b:7d:0c:
                    06:b8:4b:c7:28:e4:66:23:84:51:ef:46:b7:93:d8:
                    81:33:cb:e5:36:ac:c6:e8:05
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
                DirName:/CN=OCSP 1-1
            X509v3 CRL Distribution Points: 
                URI:http://crl.verisign.com/pca1.crl

            X509v3 Extended Key Usage: 
                OCSP Signing
            Authority Information Access: 
                OCSP - URI:$http://ocsp.verisign.com/ocsp/status

            X509v3 Certificate Policies: 
                Policy: 2.16.840.1.113733.1.7.1.1
                  CPS: https://www.verisign.com/RPA

            X509v3 Basic Constraints: 
                CA:FALSE
            X509v3 Key Usage: 
                Digital Signature
    Signature Algorithm: sha1WithRSAEncryption
        70:90:dd:b8:e4:be:53:17:7c:7f:02:e9:d5:f7:8b:99:93:31:
        60:8d:7e:e6:60:6b:24:ef:60:ac:d2:ce:91:de:80:6d:09:a4:
        d3:b8:38:e5:44:ca:72:5e:0d:2d:c1:77:9c:bd:2c:03:78:29:
        8d:a4:a5:77:87:f5:f1:2b:26:ad:cc:07:6c:3a:54:5a:28:e0:
        09:f3:4d:0a:04:ca:d4:58:69:0b:a7:b3:f5:dd:01:a5:e7:dc:
        f0:1f:ba:c1:5d:90:8d:b3:ea:4f:c1:11:59:97:6a:b2:2b:13:
        b1:da:ad:97:a1:b3:b1:a0:20:5b:ca:32:ab:8d:cf:13:f0:1f:
        29:c3
-----BEGIN CERTIFICATE-----
MIIDnjCCAwegAwIBAgIQK2jUo0aexTsoCas4XX8nIDANBgkqhkiG9w0BAQUFADBf
MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsT
LkNsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkw
HhcNMDAwODA0MDAwMDAwWhcNMDQwODAzMjM1OTU5WjCBpzEXMBUGA1UEChMOVmVy
aVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5
BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20v
UlBBIChjKTAwMS4wLAYDVQQDEyVDbGFzcyAxIFB1YmxpYyBQcmltYXJ5IE9DU1Ag
UmVzcG9uZGVyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC57V56Ondfzl86
UvzNZPdxtW9qlsZZklWUXS9bLsER6iaKy6eBPPZaRN56Ey/9WlHZezcmSsAnPwQD
albBgyzhb1upVFAkSsYuekyhWzdUJCExH6F4GHansXDaItBq/gdiQMb39pt9DAa4
S8co5GYjhFHvRreT2IEzy+U2rMboBQIDAQABo4IBEDCCAQwwIAYDVR0RBBkwF6QV
MBMxETAPBgNVBAMTCE9DU1AgMS0xMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9j
cmwudmVyaXNpZ24uY29tL3BjYTEuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMJMEIG
CCsGAQUFBwEBBDYwNDAyBggrBgEFBQcwAaYmFiRodHRwOi8vb2NzcC52ZXJpc2ln
bi5jb20vb2NzcC9zdGF0dXMwRAYDVR0gBD0wOzA5BgtghkgBhvhFAQcBATAqMCgG
CCsGAQUFBwIBFhxodHRwczovL3d3dy52ZXJpc2lnbi5jb20vUlBBMAkGA1UdEwQC
MAAwCwYDVR0PBAQDAgeAMA0GCSqGSIb3DQEBBQUAA4GBAHCQ3bjkvlMXfH8C6dX3
i5mTMWCNfuZgayTvYKzSzpHegG0JpNO4OOVEynJeDS3Bd5y9LAN4KY2kpXeH9fEr
Jq3MB2w6VFoo4AnzTQoEytRYaQuns/XdAaXn3PAfusFdkI2z6k/BEVmXarIrE7Ha
rZehs7GgIFvKMquNzxPwHynD
-----END CERTIFICATE-----
...EOF...
cat >certs/class-2-public-primary-ocsp-responder.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            09:46:17:e6:1d:d8:d4:1c:a0:0c:a0:62:e8:79:8a:a7
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority
        Validity
            Not Before: Aug  1 00:00:00 2000 GMT
            Not After : Jul 31 23:59:59 2004 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/RPA (c)00, CN=Class 2 Public Primary OCSP Responder
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d0:ca:63:31:61:7f:44:34:7c:05:7d:0b:3d:6a:
                    90:cb:79:4b:77:0a:3f:4b:c7:23:e5:c0:62:2d:7e:
                    9c:7e:3e:88:87:91:d0:ac:e8:4d:49:87:a2:96:90:
                    8a:dd:04:a5:02:3f:8c:9b:e9:89:fe:62:a0:e2:5a:
                    bd:c8:dd:b4:78:e6:a5:42:93:08:67:01:c0:20:4d:
                    d7:5c:f4:5d:da:b3:e3:37:a6:52:1a:2c:4c:65:4d:
                    8a:87:d9:a8:a3:f1:49:54:bb:3c:5c:80:51:68:c6:
                    fb:49:ff:0b:55:ab:15:dd:fb:9a:c1:b9:1d:74:0d:
                    b2:8c:44:5d:89:fc:9f:f9:83
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
                DirName:/CN=OCSP 1-2
            X509v3 CRL Distribution Points: 
                URI:http://crl.verisign.com/pca2.crl

            X509v3 Extended Key Usage: 
                OCSP Signing
            Authority Information Access: 
                OCSP - URI:$http://ocsp.verisign.com/ocsp/status

            X509v3 Certificate Policies: 
                Policy: 2.16.840.1.113733.1.7.1.1
                  CPS: https://www.verisign.com/RPA

            X509v3 Basic Constraints: 
                CA:FALSE
            X509v3 Key Usage: 
                Digital Signature
    Signature Algorithm: sha1WithRSAEncryption
        1f:7d:09:6e:24:46:75:04:9c:f3:26:9b:e3:39:6e:17:ef:bc:
        bd:a2:1b:d2:02:84:86:ab:d0:40:97:2c:c4:43:88:37:19:6b:
        22:a8:03:71:50:9d:20:dc:36:60:20:9a:73:2d:73:55:6c:58:
        9b:2c:c2:b4:34:2c:7a:33:42:ca:91:d9:e9:43:af:cf:1e:e0:
        f5:c4:7a:ab:3f:72:63:1e:a9:37:e1:5b:3b:88:b3:13:86:82:
        90:57:cb:57:ff:f4:56:be:22:dd:e3:97:a8:e1:bc:22:43:c2:
        dd:4d:db:f6:81:9e:92:14:9e:39:0f:13:54:de:82:d8:c0:5e:
        34:8d
-----BEGIN CERTIFICATE-----
MIIDnjCCAwegAwIBAgIQCUYX5h3Y1BygDKBi6HmKpzANBgkqhkiG9w0BAQUFADBf
MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsT
LkNsYXNzIDIgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkw
HhcNMDAwODAxMDAwMDAwWhcNMDQwNzMxMjM1OTU5WjCBpzEXMBUGA1UEChMOVmVy
aVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5
BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20v
UlBBIChjKTAwMS4wLAYDVQQDEyVDbGFzcyAyIFB1YmxpYyBQcmltYXJ5IE9DU1Ag
UmVzcG9uZGVyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDQymMxYX9ENHwF
fQs9apDLeUt3Cj9LxyPlwGItfpx+PoiHkdCs6E1Jh6KWkIrdBKUCP4yb6Yn+YqDi
Wr3I3bR45qVCkwhnAcAgTddc9F3as+M3plIaLExlTYqH2aij8UlUuzxcgFFoxvtJ
/wtVqxXd+5rBuR10DbKMRF2J/J/5gwIDAQABo4IBEDCCAQwwIAYDVR0RBBkwF6QV
MBMxETAPBgNVBAMTCE9DU1AgMS0yMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9j
cmwudmVyaXNpZ24uY29tL3BjYTIuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMJMEIG
CCsGAQUFBwEBBDYwNDAyBggrBgEFBQcwAaYmFiRodHRwOi8vb2NzcC52ZXJpc2ln
bi5jb20vb2NzcC9zdGF0dXMwRAYDVR0gBD0wOzA5BgtghkgBhvhFAQcBATAqMCgG
CCsGAQUFBwIBFhxodHRwczovL3d3dy52ZXJpc2lnbi5jb20vUlBBMAkGA1UdEwQC
MAAwCwYDVR0PBAQDAgeAMA0GCSqGSIb3DQEBBQUAA4GBAB99CW4kRnUEnPMmm+M5
bhfvvL2iG9IChIar0ECXLMRDiDcZayKoA3FQnSDcNmAgmnMtc1VsWJsswrQ0LHoz
QsqR2elDr88e4PXEeqs/cmMeqTfhWzuIsxOGgpBXy1f/9Fa+It3jl6jhvCJDwt1N
2/aBnpIUnjkPE1TegtjAXjSN
-----END CERTIFICATE-----
...EOF...
cat >certs/class-3-public-primary-ocsp-responder.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            2e:96:9e:bf:b6:62:6c:ec:7b:e9:73:cc:e3:6c:c1:84
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Validity
            Not Before: Aug  4 00:00:00 2000 GMT
            Not After : Aug  3 23:59:59 2004 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/RPA (c)00, CN=Class 3 Public Primary OCSP Responder
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:f1:e4:08:0e:83:bb:75:e3:48:e5:b8:db:a6:f0:
                    b9:ab:e9:3c:62:c7:5e:35:5b:d0:02:54:11:d8:c9:
                    d1:56:b9:76:4b:b9:ab:7a:e6:cd:ba:f6:0c:04:d6:
                    7e:d6:b0:0a:65:ac:4e:39:e3:f1:f7:2d:a3:25:39:
                    ef:b0:8b:cf:be:db:0c:5d:6e:70:f4:07:cd:70:f7:
                    3a:c0:3e:35:16:ed:78:8c:43:cf:c2:26:2e:47:d6:
                    86:7d:9c:f1:be:d6:67:0c:22:25:a4:ca:65:e6:1f:
                    7a:78:28:2f:3f:05:db:04:21:bf:e1:45:66:fe:3c:
                    b7:82:ed:5a:b8:16:15:b9:55
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
                DirName:/CN=OCSP 1-3
            X509v3 CRL Distribution Points: 
                URI:http://crl.verisign.com/pca3.1.1.crl

            X509v3 Extended Key Usage: 
                OCSP Signing
            Authority Information Access: 
                OCSP - URI:$http://ocsp.verisign.com/ocsp/status

            X509v3 Certificate Policies: 
                Policy: 2.16.840.1.113733.1.7.1.1
                  CPS: https://www.verisign.com/RPA

            X509v3 Basic Constraints: 
                CA:FALSE
            X509v3 Key Usage: 
                Digital Signature
    Signature Algorithm: sha1WithRSAEncryption
        02:f6:53:63:c0:a9:1e:f2:d0:8b:33:30:8f:48:9b:4c:b0:56:
        b4:83:71:4a:be:dc:50:d8:f5:b6:e0:0b:db:bd:78:4f:e9:cf:
        09:34:da:29:49:9d:01:73:5a:91:91:82:54:2c:13:0a:d3:77:
        23:cf:37:fc:63:de:a7:e3:f6:b7:b5:69:45:28:49:c3:91:dc:
        aa:47:1c:a9:88:99:2c:05:2a:8d:8d:8a:fa:62:e2:5a:b7:00:
        20:5d:39:c4:28:c2:cb:fc:9e:a8:89:ae:5b:3d:8e:12:ea:32:
        b2:fc:eb:14:d7:09:15:1a:c0:cd:1b:d5:b5:15:4e:41:d5:96:
        e3:4e
-----BEGIN CERTIFICATE-----
MIIDojCCAwugAwIBAgIQLpaev7ZibOx76XPM42zBhDANBgkqhkiG9w0BAQUFADBf
MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsT
LkNsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkw
HhcNMDAwODA0MDAwMDAwWhcNMDQwODAzMjM1OTU5WjCBpzEXMBUGA1UEChMOVmVy
aVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5
BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20v
UlBBIChjKTAwMS4wLAYDVQQDEyVDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IE9DU1Ag
UmVzcG9uZGVyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDx5AgOg7t140jl
uNum8Lmr6Txix141W9ACVBHYydFWuXZLuat65s269gwE1n7WsAplrE454/H3LaMl
Oe+wi8++2wxdbnD0B81w9zrAPjUW7XiMQ8/CJi5H1oZ9nPG+1mcMIiWkymXmH3p4
KC8/BdsEIb/hRWb+PLeC7Vq4FhW5VQIDAQABo4IBFDCCARAwIAYDVR0RBBkwF6QV
MBMxETAPBgNVBAMTCE9DU1AgMS0zMDUGA1UdHwQuMCwwKqAooCaGJGh0dHA6Ly9j
cmwudmVyaXNpZ24uY29tL3BjYTMuMS4xLmNybDATBgNVHSUEDDAKBggrBgEFBQcD
CTBCBggrBgEFBQcBAQQ2MDQwMgYIKwYBBQUHMAGmJhYkaHR0cDovL29jc3AudmVy
aXNpZ24uY29tL29jc3Avc3RhdHVzMEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHAQEw
KjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL1JQQTAJBgNV
HRMEAjAAMAsGA1UdDwQEAwIHgDANBgkqhkiG9w0BAQUFAAOBgQAC9lNjwKke8tCL
MzCPSJtMsFa0g3FKvtxQ2PW24AvbvXhP6c8JNNopSZ0Bc1qRkYJULBMK03cjzzf8
Y96n4/a3tWlFKEnDkdyqRxypiJksBSqNjYr6YuJatwAgXTnEKMLL/J6oia5bPY4S
6jKy/OsU1wkVGsDNG9W1FU5B1ZbjTg==
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-partners-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b9:d1:af
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Jan 28 12:00:00 1999 GMT
            Not After : Jan 28 12:00:00 2009 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Partners CA, CN=GlobalSign Partners CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:d2:2c:f8:32:ac:4a:12:7a:37:c8:29:91:a5:ae:
                    8c:6e:1e:0e:c0:34:33:88:e5:33:71:16:1c:78:84:
                    68:c3:18:34:50:2e:16:3e:b1:94:82:4f:b1:9a:9f:
                    00:f8:c6:11:35:c6:69:7b:98:02:ad:00:06:88:6c:
                    e7:4c:33:28:00:88:27:46:1f:87:b3:71:75:63:bc:
                    32:bb:88:de:66:18:0e:50:06:93:b4:f6:bc:14:37:
                    30:3d:22:df:3d:ff:75:7e:d9:0a:1a:c5:9f:b3:fc:
                    d0:ac:b3:08:7a:89:d3:01:e8:00:5c:e7:4a:0b:3d:
                    4d:7b:26:a2:b7:62:06:8b:da:46:dd:93:17:3f:3f:
                    5b:02:4b:0b:b6:88:20:11:92:00:ad:bb:c7:2e:d4:
                    e3:45:ae:f5:89:5a:7c:8d:a4:ad:85:64:32:c0:27:
                    8c:c6:f2:8a:80:92:86:24:56:59:8d:74:68:a2:83:
                    42:b3:9e:3d:50:41:86:6f:20:6e:f6:fd:ce:d3:19:
                    e3:32:cc:8f:ed:9a:5e:6d:1f:28:f5:52:ac:6e:18:
                    5e:f8:3d:d1:92:e5:ba:6c:01:88:4b:0a:f2:2d:de:
                    65:33:05:42:a0:4c:aa:31:76:be:fd:bf:81:78:f9:
                    71:1c:46:5e:2d:15:95:2d:30:59:8e:4c:41:d1:62:
                    ab:3d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                43:24:8D:70:15:08:62:55:9C:4F:0C:40:17:5D:86:5E:0F:A2:4C:FB
            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        66:ed:b4:88:69:11:99:82:21:83:ac:a1:6d:8b:9b:84:ad:0f:
        2d:c8:1e:8c:ca:7b:7e:ad:aa:d4:8e:de:07:d6:9e:45:c7:a5:
        b8:9c:07:39:60:25:55:1a:c0:4f:19:e5:cf:17:29:49:89:18:
        35:66:e5:eb:28:40:4e:57:c9:af:b3:e4:b8:20:05:a3:3b:95:
        50:91:49:94:29:7d:2c:e5:88:41:a5:45:88:5e:9d:82:27:f7:
        d2:ef:5b:b5:4f:9f:be:fe:35:65:2c:55:64:9f:e1:51:da:22:
        61:77:ba:58:4e:8f:c6:79:59:59:6e:30:80:a2:4f:90:6e:21:
        0b:ad:d0:68:39:90:10:9b:ed:22:65:6f:1e:11:38:e6:7f:8c:
        d2:f3:39:6d:47:d5:21:e8:ea:75:3a:41:d1:ad:f6:16:9d:5d:
        0b:21:bd:f3:1f:63:06:25:1d:c1:1f:35:71:2c:eb:20:19:d5:
        c1:b0:ec:3d:e5:6f:ed:02:07:3f:13:7b:66:92:d6:44:c1:98:
        f7:5f:50:8b:7a:5b:c2:6f:6d:b0:d1:f8:e5:74:a0:40:37:a3:
        25:0f:e4:3d:ca:64:31:93:90:5c:30:7b:b9:39:31:9a:5e:4c:
        cd:b9:41:4f:50:e4:3d:38:ae:c8:66:d9:c7:3b:5d:51:47:ac:
        9b:ab:f2:ad
-----BEGIN CERTIFICATE-----
MIIDnjCCAoagAwIBAgILAgAAAAAA1ni50a8wDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05OTAxMjgxMjAw
MDBaFw0wOTAxMjgxMjAwMDBaMF8xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRQwEgYDVQQLEwtQYXJ0bmVycyBDQTEfMB0GA1UEAxMWR2xv
YmFsU2lnbiBQYXJ0bmVycyBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
ggEBANIs+DKsShJ6N8gpkaWujG4eDsA0M4jlM3EWHHiEaMMYNFAuFj6xlIJPsZqf
APjGETXGaXuYAq0ABohs50wzKACIJ0Yfh7NxdWO8MruI3mYYDlAGk7T2vBQ3MD0i
3z3/dX7ZChrFn7P80KyzCHqJ0wHoAFznSgs9TXsmordiBovaRt2TFz8/WwJLC7aI
IBGSAK27xy7U40Wu9YlafI2krYVkMsAnjMbyioCShiRWWY10aKKDQrOePVBBhm8g
bvb9ztMZ4zLMj+2aXm0fKPVSrG4YXvg90ZLlumwBiEsK8i3eZTMFQqBMqjF2vv2/
gXj5cRxGXi0VlS0wWY5MQdFiqz0CAwEAAaNjMGEwDgYDVR0PAQH/BAQDAgAGMB0G
A1UdDgQWBBRDJI1wFQhiVZxPDEAXXYZeD6JM+zAfBgNVHSMEGDAWgBRge2YaRQ2X
yolQL30EzTSo//z9SzAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IB
AQBm7bSIaRGZgiGDrKFti5uErQ8tyB6Mynt+rarUjt4H1p5Fx6W4nAc5YCVVGsBP
GeXPFylJiRg1ZuXrKEBOV8mvs+S4IAWjO5VQkUmUKX0s5YhBpUWIXp2CJ/fS71u1
T5++/jVlLFVkn+FR2iJhd7pYTo/GeVlZbjCAok+QbiELrdBoOZAQm+0iZW8eETjm
f4zS8zltR9Uh6Op1OkHRrfYWnV0LIb3zH2MGJR3BHzVxLOsgGdXBsOw95W/tAgc/
E3tmktZEwZj3X1CLelvCb22w0fjldKBAN6MlD+Q9ymQxk5BcMHu5OTGaXkzNuUFP
UOQ9OK7IZtnHO11RR6ybq/Kt
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-primary-class-1-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b8:37:cf
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Sep 15 12:00:00 1998 GMT
            Not After : Jan 28 12:00:00 2009 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Primary Class 1 CA, CN=GlobalSign Primary Class 1 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:bd:20:35:47:d1:28:d6:08:a3:12:39:23:47:0d:
                    bd:70:21:52:0e:57:31:95:a6:34:57:6b:ec:7e:43:
                    79:c3:06:52:48:cd:bc:b5:a1:99:bd:d8:1f:32:bc:
                    cf:d7:6e:72:6d:2e:77:22:90:82:4e:4b:8f:9a:0c:
                    01:42:9a:d9:70:59:b6:9d:1f:e6:63:d1:0c:ad:1d:
                    4e:f8:85:81:f9:ae:ef:9f:a6:52:61:44:79:1a:75:
                    45:e0:61:56:45:6d:42:8c:3d:72:cb:a6:a4:12:b7:
                    9a:f5:d6:60:d0:60:50:b3:8e:a6:a6:ec:b4:f4:12:
                    cd:7f:a8:ce:ef:b3:e1:85:30:fe:72:c4:e6:e7:77:
                    b3:9e:58:41:d6:51:83:88:07:c6:b6:69:4f:36:de:
                    d1:0b:48:3f:bd:d6:9f:21:74:64:6f:27:06:3e:4b:
                    fd:0e:a6:9b:bf:a4:48:57:8c:90:ee:89:18:0b:02:
                    81:18:be:67:fe:53:60:88:27:ba:a3:73:34:4b:5a:
                    56:b4:de:73:05:ed:98:96:5d:ec:4a:e7:40:fc:4b:
                    09:62:eb:d0:e3:31:4f:85:d1:7a:ab:59:67:2b:fb:
                    88:0f:eb:aa:83:bd:35:fd:61:27:ec:66:0e:42:57:
                    f7:69:c2:0c:ef:fc:6a:c2:6e:49:da:8f:41:38:ae:
                    48:a9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                FC:E0:66:F6:5A:35:99:EB:40:1E:D2:B8:1E:43:BC:98:8E:1F:8A:C3
            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        9b:a3:08:44:ce:f2:90:9d:71:f3:32:b3:05:6a:b5:ea:cf:29:
        98:de:55:3e:a0:16:7d:06:7a:44:d6:af:d2:fa:13:58:8c:f8:
        1c:c7:ab:1d:b4:1b:ef:69:68:98:5c:08:39:8f:e0:f7:fb:48:
        cc:21:e7:b8:33:db:05:aa:34:24:6c:4a:e5:e9:7b:60:de:83:
        b3:1f:0a:be:41:75:fc:cc:30:48:b7:c1:26:1d:04:33:aa:b6:
        78:ed:2a:cb:ba:56:97:32:6e:f7:31:95:2e:46:f2:14:ee:27:
        c7:f7:62:89:b9:5c:5a:d3:38:8a:64:f5:37:b4:f1:b3:34:72:
        d5:d5:21:3d:4b:d7:78:93:d7:31:66:35:1e:a3:d8:47:49:6f:
        1c:ad:e1:80:7f:f8:98:24:6c:73:ac:0e:c2:1a:77:02:a3:26:
        07:b7:c7:6b:5d:bc:82:d5:2a:48:1d:63:cf:50:32:a6:fb:1c:
        18:47:15:0a:5b:0c:5c:38:24:9a:04:98:a8:08:48:5f:7c:34:
        87:63:ab:2d:8d:4c:00:77:94:1b:76:ba:f5:16:18:a3:15:af:
        2f:94:f6:29:00:76:c1:15:17:d3:e9:37:4d:76:d4:cb:4b:29:
        59:24:ac:da:4a:a0:ea:63:de:5f:54:b1:fa:f3:d1:45:cb:c5:
        64:b4:73:21
-----BEGIN CERTIFICATE-----
MIIDrDCCApSgAwIBAgILAgAAAAAA1ni4N88wDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MTUxMjAw
MDBaFw0wOTAxMjgxMjAwMDBaMG0xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRswGQYDVQQLExJQcmltYXJ5IENsYXNzIDEgQ0ExJjAkBgNV
BAMTHUdsb2JhbFNpZ24gUHJpbWFyeSBDbGFzcyAxIENBMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEAvSA1R9Eo1gijEjkjRw29cCFSDlcxlaY0V2vsfkN5
wwZSSM28taGZvdgfMrzP125ybS53IpCCTkuPmgwBQprZcFm2nR/mY9EMrR1O+IWB
+a7vn6ZSYUR5GnVF4GFWRW1CjD1yy6akErea9dZg0GBQs46mpuy09BLNf6jO77Ph
hTD+csTm53eznlhB1lGDiAfGtmlPNt7RC0g/vdafIXRkbycGPkv9Dqabv6RIV4yQ
7okYCwKBGL5n/lNgiCe6o3M0S1pWtN5zBe2Yll3sSudA/EsJYuvQ4zFPhdF6q1ln
K/uID+uqg701/WEn7GYOQlf3acIM7/xqwm5J2o9BOK5IqQIDAQABo2MwYTAOBgNV
HQ8BAf8EBAMCAAYwHQYDVR0OBBYEFPzgZvZaNZnrQB7SuB5DvJiOH4rDMB8GA1Ud
IwQYMBaAFGB7ZhpFDZfKiVAvfQTNNKj//P1LMA8GA1UdEwEB/wQFMAMBAf8wDQYJ
KoZIhvcNAQEEBQADggEBAJujCETO8pCdcfMyswVqterPKZjeVT6gFn0GekTWr9L6
E1iM+BzHqx20G+9paJhcCDmP4Pf7SMwh57gz2wWqNCRsSuXpe2Deg7MfCr5BdfzM
MEi3wSYdBDOqtnjtKsu6VpcybvcxlS5G8hTuJ8f3Yom5XFrTOIpk9Te08bM0ctXV
IT1L13iT1zFmNR6j2EdJbxyt4YB/+JgkbHOsDsIadwKjJge3x2tdvILVKkgdY89Q
Mqb7HBhHFQpbDFw4JJoEmKgISF98NIdjqy2NTAB3lBt2uvUWGKMVry+U9ikAdsEV
F9PpN0121MtLKVkkrNpKoOpj3l9Usfrz0UXLxWS0cyE=
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-primary-class-2-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b8:8d:8d
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Jan 28 12:00:00 1999 GMT
            Not After : Jan 28 12:00:00 2009 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Primary Class 2 CA, CN=GlobalSign Primary Class 2 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:92:8c:fe:ef:f4:45:8e:17:41:6e:fc:d8:bf:21:
                    6f:ab:06:9d:52:c1:2c:00:9d:3f:8e:85:b8:7f:4a:
                    8f:bd:a0:63:2a:ca:49:27:ae:5a:82:f4:74:e2:55:
                    92:ff:c2:d1:aa:79:a2:b6:fa:d5:9d:82:04:4f:c6:
                    b2:c6:5e:63:a7:3a:ba:d8:ee:eb:8a:6f:9f:b6:bb:
                    28:41:c0:22:fb:4e:48:1a:06:92:d7:bf:d7:cf:b9:
                    d9:bd:38:4f:3b:0d:44:6e:55:41:fe:fc:09:db:d8:
                    bf:f3:8e:21:f1:e8:12:b5:f6:13:a5:d3:c6:4c:93:
                    22:b0:02:ff:ee:1d:0c:c4:a8:6b:4f:75:68:56:e8:
                    dc:28:12:50:f7:a8:24:9d:2e:24:39:fb:09:05:de:
                    e5:a3:64:49:21:d0:68:7e:71:30:91:b1:60:e0:39:
                    f4:50:f8:7a:4d:98:00:6b:7c:79:ba:4e:ce:4a:e2:
                    ba:36:1d:b7:c5:36:15:95:9c:64:42:ea:5f:c4:ba:
                    f5:40:05:be:e1:3a:59:bd:84:a7:19:b8:de:4d:53:
                    50:ce:07:d1:d2:51:d3:ef:0d:81:6c:e6:e7:6d:cb:
                    5d:7c:3f:7c:cc:ec:4f:83:27:25:ff:70:50:f6:83:
                    59:75:84:06:66:58:2c:de:89:8d:00:a6:49:f9:a5:
                    43:77
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                7C:E7:B2:B1:2C:DE:B1:A7:6B:E9:76:0C:E1:A3:FD:4E:6C:C7:B9:F6
            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        63:dd:59:ce:8a:79:aa:98:9d:4e:c5:89:64:37:7e:8a:93:67:
        2f:10:ea:6f:27:c3:8d:77:6d:f2:5c:56:94:19:1a:69:60:30:
        46:5d:8f:f2:6d:45:3c:8e:35:97:7c:2f:b8:51:e2:e8:89:bd:
        88:cf:27:1c:08:34:5c:88:c1:68:24:db:91:85:e4:cf:fb:fb:
        43:8d:e8:25:01:1b:c4:0e:f7:00:42:48:86:1f:24:08:58:5a:
        8c:8d:f2:6b:47:2c:68:91:b1:69:42:fd:0d:8d:c9:26:e6:92:
        86:a6:64:6e:92:c5:ce:3e:3c:7d:71:e3:23:a4:ab:c7:d5:a8:
        a9:df:82:a7:3b:e8:86:d5:c3:4f:18:e3:44:d0:e0:dc:f3:c5:
        68:2e:fe:a5:2f:05:84:c8:7e:47:42:53:6b:87:4a:fe:32:ff:
        5e:3e:70:8c:b7:a8:15:cc:17:c2:ff:46:ec:d0:ec:2d:b4:6e:
        12:28:a9:f9:40:e9:eb:d4:66:97:53:a9:69:55:c0:a9:aa:b2:
        2e:cd:d1:69:f4:be:f8:bb:7c:69:ee:54:a6:db:9e:fb:5a:a6:
        3e:fe:9a:ef:94:51:4b:75:ee:d8:d4:e1:9a:f1:02:56:13:89:
        0e:a7:42:8b:96:8b:85:0c:1b:85:be:26:ae:ab:a6:99:bc:22:
        f1:73:df:42
-----BEGIN CERTIFICATE-----
MIIDrDCCApSgAwIBAgILAgAAAAAA1ni4jY0wDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05OTAxMjgxMjAw
MDBaFw0wOTAxMjgxMjAwMDBaMG0xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRswGQYDVQQLExJQcmltYXJ5IENsYXNzIDIgQ0ExJjAkBgNV
BAMTHUdsb2JhbFNpZ24gUHJpbWFyeSBDbGFzcyAyIENBMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEAkoz+7/RFjhdBbvzYvyFvqwadUsEsAJ0/joW4f0qP
vaBjKspJJ65agvR04lWS/8LRqnmitvrVnYIET8ayxl5jpzq62O7rim+ftrsoQcAi
+05IGgaS17/Xz7nZvThPOw1EblVB/vwJ29i/844h8egStfYTpdPGTJMisAL/7h0M
xKhrT3VoVujcKBJQ96gknS4kOfsJBd7lo2RJIdBofnEwkbFg4Dn0UPh6TZgAa3x5
uk7OSuK6Nh23xTYVlZxkQupfxLr1QAW+4TpZvYSnGbjeTVNQzgfR0lHT7w2BbObn
bctdfD98zOxPgycl/3BQ9oNZdYQGZlgs3omNAKZJ+aVDdwIDAQABo2MwYTAOBgNV
HQ8BAf8EBAMCAAYwHQYDVR0OBBYEFHznsrEs3rGna+l2DOGj/U5sx7n2MB8GA1Ud
IwQYMBaAFGB7ZhpFDZfKiVAvfQTNNKj//P1LMA8GA1UdEwEB/wQFMAMBAf8wDQYJ
KoZIhvcNAQEEBQADggEBAGPdWc6KeaqYnU7FiWQ3foqTZy8Q6m8nw413bfJcVpQZ
GmlgMEZdj/JtRTyONZd8L7hR4uiJvYjPJxwINFyIwWgk25GF5M/7+0ON6CUBG8QO
9wBCSIYfJAhYWoyN8mtHLGiRsWlC/Q2NySbmkoamZG6Sxc4+PH1x4yOkq8fVqKnf
gqc76IbVw08Y40TQ4NzzxWgu/qUvBYTIfkdCU2uHSv4y/14+cIy3qBXMF8L/RuzQ
7C20bhIoqflA6evUZpdTqWlVwKmqsi7N0Wn0vvi7fGnuVKbbnvtapj7+mu+UUUt1
7tjU4ZrxAlYTiQ6nQouWi4UMG4W+Jq6rppm8IvFz30I=
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-primary-class-3-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b8:d6:c3
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Jan 28 12:00:00 1999 GMT
            Not After : Jan 28 12:00:00 2009 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Primary Class 3 CA, CN=GlobalSign Primary Class 3 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:91:5e:56:65:d6:c0:c0:04:9c:bf:47:c4:5c:7b:
                    7a:31:01:f9:58:96:99:e3:1c:84:2f:dc:56:8f:ad:
                    f5:59:81:d5:43:66:5d:5a:93:8c:75:ca:a9:e7:11:
                    c1:51:10:14:60:c9:2c:d4:7b:af:c6:77:86:ab:7a:
                    27:ae:6f:95:b9:0b:ca:b6:46:fb:7e:1a:f4:0d:14:
                    6d:d2:c9:4e:b2:ae:f0:54:f6:5c:40:4c:36:48:74:
                    e8:54:8c:65:66:10:a7:bd:2b:b7:20:8d:05:49:ad:
                    78:7d:d2:24:23:50:e3:f0:b4:79:9b:01:39:ff:af:
                    3b:d3:2d:ee:e1:49:8d:8d:2f:3c:6a:41:45:2f:9b:
                    e3:3d:e1:12:e4:91:75:9e:cf:a0:3e:3c:92:81:6f:
                    8a:2e:18:dc:e0:f2:8c:8c:fd:87:d9:07:f4:40:94:
                    c9:4e:4f:43:df:67:56:6f:bd:03:50:7c:99:67:a4:
                    b9:3c:91:6c:02:6e:84:d6:fc:46:f7:cc:6f:18:3e:
                    17:f0:ef:0b:64:16:57:e6:ac:86:f1:48:aa:43:c1:
                    c9:27:78:73:44:45:e2:85:7d:ba:ff:b3:e1:fb:1b:
                    05:a4:4b:3b:99:12:25:01:50:14:6a:af:5d:ea:c8:
                    0c:ee:e4:da:ec:4b:8b:5c:68:13:95:dc:c3:b5:30:
                    3a:d7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                CC:36:CC:17:B4:45:91:2F:ED:CF:3B:30:48:77:FB:B5:14:99:BE:E3
            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        57:b2:54:cc:bd:95:17:64:60:89:b6:53:91:0c:45:92:c3:3d:
        a8:6c:c3:cc:b2:18:f5:78:41:74:d8:7d:a3:27:af:77:0d:59:
        3e:94:1d:69:fa:89:d3:0c:bd:1a:01:f4:3f:e8:e0:77:1a:82:
        28:5a:e6:62:d7:b7:e3:36:c9:0e:9f:7a:e3:c2:d3:cc:59:89:
        0c:ef:16:8b:f0:36:77:22:ca:a4:b6:b7:c1:42:67:01:40:63:
        cc:e7:38:64:87:5b:14:96:66:7b:2d:14:ee:bd:49:6d:ff:77:
        d0:e2:4e:5b:d3:80:c2:4d:0f:ca:b8:9d:81:97:a7:34:6e:c7:
        e3:9c:48:e5:b4:aa:45:f5:f6:65:4c:48:f2:12:c2:d2:93:8c:
        c2:15:24:f3:2b:52:ff:e3:08:ae:b8:6e:d6:2c:12:cf:39:cb:
        12:2a:e7:a9:7b:5f:98:3d:a3:e1:cc:a6:63:89:5c:7d:31:75:
        f9:d5:d6:5d:f2:d0:d4:3d:df:9e:71:a8:0e:dc:e4:20:97:78:
        e6:7f:53:a4:0d:51:4f:8e:3b:03:ae:a3:0d:5a:4d:c3:79:e7:
        35:58:70:42:c9:5e:a1:5e:b4:d9:22:a3:44:53:35:a4:d0:cf:
        73:80:c5:cf:9f:56:98:76:f9:14:4c:77:87:82:c9:dc:7e:5d:
        34:d5:36:75
-----BEGIN CERTIFICATE-----
MIIDrDCCApSgAwIBAgILAgAAAAAA1ni41sMwDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05OTAxMjgxMjAw
MDBaFw0wOTAxMjgxMjAwMDBaMG0xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRswGQYDVQQLExJQcmltYXJ5IENsYXNzIDMgQ0ExJjAkBgNV
BAMTHUdsb2JhbFNpZ24gUHJpbWFyeSBDbGFzcyAzIENBMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEAkV5WZdbAwAScv0fEXHt6MQH5WJaZ4xyEL9xWj631
WYHVQ2ZdWpOMdcqp5xHBURAUYMks1HuvxneGq3onrm+VuQvKtkb7fhr0DRRt0slO
sq7wVPZcQEw2SHToVIxlZhCnvSu3II0FSa14fdIkI1Dj8LR5mwE5/6870y3u4UmN
jS88akFFL5vjPeES5JF1ns+gPjySgW+KLhjc4PKMjP2H2Qf0QJTJTk9D32dWb70D
UHyZZ6S5PJFsAm6E1vxG98xvGD4X8O8LZBZX5qyG8UiqQ8HJJ3hzREXihX26/7Ph
+xsFpEs7mRIlAVAUaq9d6sgM7uTa7EuLXGgTldzDtTA61wIDAQABo2MwYTAOBgNV
HQ8BAf8EBAMCAAYwHQYDVR0OBBYEFMw2zBe0RZEv7c87MEh3+7UUmb7jMB8GA1Ud
IwQYMBaAFGB7ZhpFDZfKiVAvfQTNNKj//P1LMA8GA1UdEwEB/wQFMAMBAf8wDQYJ
KoZIhvcNAQEEBQADggEBAFeyVMy9lRdkYIm2U5EMRZLDPahsw8yyGPV4QXTYfaMn
r3cNWT6UHWn6idMMvRoB9D/o4Hcagiha5mLXt+M2yQ6feuPC08xZiQzvFovwNnci
yqS2t8FCZwFAY8znOGSHWxSWZnstFO69SW3/d9DiTlvTgMJND8q4nYGXpzRux+Oc
SOW0qkX19mVMSPISwtKTjMIVJPMrUv/jCK64btYsEs85yxIq56l7X5g9o+HMpmOJ
XH0xdfnV1l3y0NQ9355xqA7c5CCXeOZ/U6QNUU+OOwOuow1aTcN55zVYcELJXqFe
tNkio0RTNaTQz3OAxc+fVph2+RRMd4eCydx+XTTVNnU=
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-root-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b7:94:05
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Sep  1 12:00:00 1998 GMT
            Not After : Jan 28 12:00:00 2014 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:da:0e:e6:99:8d:ce:a3:e3:4f:8a:7e:fb:f1:8b:
                    83:25:6b:ea:48:1f:f1:2a:b0:b9:95:11:04:bd:f0:
                    63:d1:e2:67:66:cf:1c:dd:cf:1b:48:2b:ee:8d:89:
                    8e:9a:af:29:80:65:ab:e9:c7:2d:12:cb:ab:1c:4c:
                    70:07:a1:3d:0a:30:cd:15:8d:4f:f8:dd:d4:8c:50:
                    15:1c:ef:50:ee:c4:2e:f7:fc:e9:52:f2:91:7d:e0:
                    6d:d5:35:30:8e:5e:43:73:f2:41:e9:d5:6a:e3:b2:
                    89:3a:56:39:38:6f:06:3c:88:69:5b:2a:4d:c5:a7:
                    54:b8:6c:89:cc:9b:f9:3c:ca:e5:fd:89:f5:12:3c:
                    92:78:96:d6:dc:74:6e:93:44:61:d1:8d:c7:46:b2:
                    75:0e:86:e8:19:8a:d5:6d:6c:d5:78:16:95:a2:e9:
                    c8:0a:38:eb:f2:24:13:4f:73:54:93:13:85:3a:1b:
                    bc:1e:34:b5:8b:05:8c:b9:77:8b:b1:db:1f:20:91:
                    ab:09:53:6e:90:ce:7b:37:74:b9:70:47:91:22:51:
                    63:16:79:ae:b1:ae:41:26:08:c8:19:2b:d1:46:aa:
                    48:d6:64:2a:d7:83:34:ff:2c:2a:c1:6c:19:43:4a:
                    07:85:e7:d3:7c:f6:21:68:ef:ea:f2:52:9f:7f:93:
                    90:cf
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        ae:aa:9f:fc:b7:d2:cb:1f:5f:39:29:28:18:9e:34:c9:6c:4f:
        6f:1a:f0:64:a2:70:4a:4f:13:86:9b:60:28:9e:e8:81:49:98:
        7d:0a:bb:e5:b0:9d:3d:36:db:8f:05:51:ff:09:31:2a:1f:dd:
        89:77:9e:0f:2e:6c:95:04:ed:86:cb:b4:00:3f:84:02:4d:80:
        6a:2a:2d:78:0b:ae:6f:2b:a2:83:44:83:1f:cd:50:82:4c:24:
        af:bd:f7:a5:b4:c8:5a:0f:f4:e7:47:5e:49:8e:37:96:fe:9a:
        88:05:3a:d9:c0:db:29:87:e6:19:96:47:a7:3a:a6:8c:8b:3c:
        77:fe:46:63:a7:53:da:21:d1:ac:7e:49:a2:4b:e6:c3:67:59:
        2f:b3:8a:0e:bb:2c:bd:a9:aa:42:7c:35:c1:d8:7f:d5:a7:31:
        3a:4e:63:43:39:af:08:b0:61:34:8c:d3:98:a9:43:34:f6:0f:
        87:29:3b:9d:c2:56:58:98:77:c3:f7:1b:ac:f6:9d:f8:3e:aa:
        a7:54:45:f0:f5:f9:d5:31:65:fe:6b:58:9c:71:b3:1e:d7:52:
        ea:32:17:fc:40:60:1d:c9:79:24:b2:f6:6c:fd:a8:66:0e:82:
        dd:98:cb:da:c2:44:4f:2e:a0:7b:f2:f7:6b:2c:76:11:84:46:
        8a:78:a3:e3
-----BEGIN CERTIFICATE-----
MIIDdTCCAl2gAwIBAgILAgAAAAAA1ni3lAUwDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAw
MDBaFw0xNDAxMjgxMjAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYDVQQDExJHbG9iYWxT
aWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaDuaZ
jc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavp
xy0Sy6scTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp
1Wrjsok6Vjk4bwY8iGlbKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdG
snUOhugZitVtbNV4FpWi6cgKOOvyJBNPc1STE4U6G7weNLWLBYy5d4ux2x8gkasJ
U26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrXgzT/LCrBbBlDSgeF59N8
9iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIABjAdBgNVHQ4EFgQU
YHtmGkUNl8qJUC99BM00qP/8/UswDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0B
AQQFAAOCAQEArqqf/LfSyx9fOSkoGJ40yWxPbxrwZKJwSk8ThptgKJ7ogUmYfQq7
5bCdPTbbjwVR/wkxKh/diXeeDy5slQTthsu0AD+EAk2AaioteAuubyuig0SDH81Q
gkwkr733pbTIWg/050deSY43lv6aiAU62cDbKYfmGZZHpzqmjIs8d/5GY6dT2iHR
rH5Jokvmw2dZL7OKDrssvamqQnw1wdh/1acxOk5jQzmvCLBhNIzTmKlDNPYPhyk7
ncJWWJh3w/cbrPad+D6qp1RF8PX51TFl/mtYnHGzHtdS6jIX/EBgHcl5JLL2bP2o
Zg6C3ZjL2sJETy6ge/L3ayx2EYRGinij4w==
-----END CERTIFICATE-----
...EOF...
cat >certs/http-www-valicert-com-00.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 1 Policy Validation Authority, CN=http://www.valicert.com//Email=info@valicert.com
        Validity
            Not Before: Jun 25 22:23:48 1999 GMT
            Not After : Jun 25 22:23:48 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 1 Policy Validation Authority, CN=http://www.valicert.com//Email=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d8:59:82:7a:89:b8:96:ba:a6:2f:68:6f:58:2e:
                    a7:54:1c:06:6e:f4:ea:8d:48:bc:31:94:17:f0:f3:
                    4e:bc:b2:b8:35:92:76:b0:d0:a5:a5:01:d7:00:03:
                    12:22:19:08:f8:ff:11:23:9b:ce:07:f5:bf:69:1a:
                    26:fe:4e:e9:d1:7f:9d:2c:40:1d:59:68:6e:a6:f8:
                    58:b0:9d:1a:8f:d3:3f:f1:dc:19:06:81:a8:0e:e0:
                    3a:dd:c8:53:45:09:06:e6:0f:70:c3:fa:40:a6:0e:
                    e2:56:05:0f:18:4d:fc:20:82:d1:73:55:74:8d:76:
                    72:a0:1d:9d:1d:c0:dd:3f:71
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        50:68:3d:49:f4:2c:1c:06:94:df:95:60:7f:96:7b:17:fe:4f:
        71:ad:64:c8:dd:77:d2:ef:59:55:e8:3f:e8:8e:05:2a:21:f2:
        07:d2:b5:a7:52:fe:9c:b1:b6:e2:5b:77:17:40:ea:72:d6:23:
        cb:28:81:32:c3:00:79:18:ec:59:17:89:c9:c6:6a:1e:71:c9:
        fd:b7:74:a5:25:45:69:c5:48:ab:19:e1:45:8a:25:6b:19:ee:
        e5:bb:12:f5:7f:f7:a6:8d:51:c3:f0:9d:74:b7:a9:3e:a0:a5:
        ff:b6:49:03:13:da:22:cc:ed:71:82:2b:99:cf:3a:b7:f5:2d:
        72:c8
-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDEgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNTIyMjM0OFoXDTE5MDYy
NTIyMjM0OFowgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDEgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYWYJ6ibiWuqYvaG9Y
LqdUHAZu9OqNSLwxlBfw8068srg1knaw0KWlAdcAAxIiGQj4/xEjm84H9b9pGib+
TunRf50sQB1ZaG6m+FiwnRqP0z/x3BkGgagO4DrdyFNFCQbmD3DD+kCmDuJWBQ8Y
TfwggtFzVXSNdnKgHZ0dwN0/cQIDAQABMA0GCSqGSIb3DQEBBQUAA4GBAFBoPUn0
LBwGlN+VYH+Wexf+T3GtZMjdd9LvWVXoP+iOBSoh8gfStadS/pyxtuJbdxdA6nLW
I8sogTLDAHkY7FkXicnGah5xyf23dKUlRWnFSKsZ4UWKJWsZ7uW7EvV/96aNUcPw
nXS3qT6gpf+2SQMT2iLM7XGCK5nPOrf1LXLI
-----END CERTIFICATE-----
...EOF...
cat >certs/http-www-valicert-com-01.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 2 Policy Validation Authority, CN=http://www.valicert.com//Email=info@valicert.com
        Validity
            Not Before: Jun 26 00:19:54 1999 GMT
            Not After : Jun 26 00:19:54 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 2 Policy Validation Authority, CN=http://www.valicert.com//Email=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ce:3a:71:ca:e5:ab:c8:59:92:55:d7:ab:d8:74:
                    0e:f9:ee:d9:f6:55:47:59:65:47:0e:05:55:dc:eb:
                    98:36:3c:5c:53:5d:d3:30:cf:38:ec:bd:41:89:ed:
                    25:42:09:24:6b:0a:5e:b3:7c:dd:52:2d:4c:e6:d4:
                    d6:7d:5a:59:a9:65:d4:49:13:2d:24:4d:1c:50:6f:
                    b5:c1:85:54:3b:fe:71:e4:d3:5c:42:f9:80:e0:91:
                    1a:0a:5b:39:36:67:f3:3f:55:7c:1b:3f:b4:5f:64:
                    73:34:e3:b4:12:bf:87:64:f8:da:12:ff:37:27:c1:
                    b3:43:bb:ef:7b:6e:2e:69:f7
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        3b:7f:50:6f:6f:50:94:99:49:62:38:38:1f:4b:f8:a5:c8:3e:
        a7:82:81:f6:2b:c7:e8:c5:ce:e8:3a:10:82:cb:18:00:8e:4d:
        bd:a8:58:7f:a1:79:00:b5:bb:e9:8d:af:41:d9:0f:34:ee:21:
        81:19:a0:32:49:28:f4:c4:8e:56:d5:52:33:fd:50:d5:7e:99:
        6c:03:e4:c9:4c:fc:cb:6c:ab:66:b3:4a:21:8c:e5:b5:0c:32:
        3e:10:b2:cc:6c:a1:dc:9a:98:4c:02:5b:f3:ce:b9:9e:a5:72:
        0e:4a:b7:3f:3c:e6:16:68:f8:be:ed:74:4c:bc:5b:d5:62:1f:
        43:dd
-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDIgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNjAwMTk1NFoXDTE5MDYy
NjAwMTk1NFowgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDIgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDOOnHK5avIWZJV16vY
dA757tn2VUdZZUcOBVXc65g2PFxTXdMwzzjsvUGJ7SVCCSRrCl6zfN1SLUzm1NZ9
WlmpZdRJEy0kTRxQb7XBhVQ7/nHk01xC+YDgkRoKWzk2Z/M/VXwbP7RfZHM047QS
v4dk+NoS/zcnwbNDu+97bi5p9wIDAQABMA0GCSqGSIb3DQEBBQUAA4GBADt/UG9v
UJSZSWI4OB9L+KXIPqeCgfYrx+jFzug6EILLGACOTb2oWH+heQC1u+mNr0HZDzTu
IYEZoDJJKPTEjlbVUjP9UNV+mWwD5MlM/Mtsq2azSiGM5bUMMj4QssxsodyamEwC
W/POuZ6lcg5Ktz885hZo+L7tdEy8W9ViH0Pd
-----END CERTIFICATE-----
...EOF...
cat >certs/http-www-valicert-com-02.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 3 Policy Validation Authority, CN=http://www.valicert.com//Email=info@valicert.com
        Validity
            Not Before: Jun 26 00:22:33 1999 GMT
            Not After : Jun 26 00:22:33 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 3 Policy Validation Authority, CN=http://www.valicert.com//Email=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e3:98:51:96:1c:e8:d5:b1:06:81:6a:57:c3:72:
                    75:93:ab:cf:9e:a6:fc:f3:16:52:d6:2d:4d:9f:35:
                    44:a8:2e:04:4d:07:49:8a:38:29:f5:77:37:e7:b7:
                    ab:5d:df:36:71:14:99:8f:dc:c2:92:f1:e7:60:92:
                    97:ec:d8:48:dc:bf:c1:02:20:c6:24:a4:28:4c:30:
                    5a:76:6d:b1:5c:f3:dd:de:9e:10:71:a1:88:c7:5b:
                    9b:41:6d:ca:b0:b8:8e:15:ee:ad:33:2b:cf:47:04:
                    5c:75:71:0a:98:24:98:29:a7:49:59:a5:dd:f8:b7:
                    43:62:61:f3:d3:e2:d0:55:3f
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        56:bb:02:58:84:67:08:2c:df:1f:db:7b:49:33:f5:d3:67:9d:
        f4:b4:0a:10:b3:c9:c5:2c:e2:92:6a:71:78:27:f2:70:83:42:
        d3:3e:cf:a9:54:f4:f1:d8:92:16:8c:d1:04:cb:4b:ab:c9:9f:
        45:ae:3c:8a:a9:b0:71:33:5d:c8:c5:57:df:af:a8:35:b3:7f:
        89:87:e9:e8:25:92:b8:7f:85:7a:ae:d6:bc:1e:37:58:2a:67:
        c9:91:cf:2a:81:3e:ed:c6:39:df:c0:3e:19:9c:19:cc:13:4d:
        82:41:b5:8c:de:e0:3d:60:08:20:0f:45:7e:6b:a2:7f:a3:8c:
        15:ee
-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDMgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNjAwMjIzM1oXDTE5MDYy
NjAwMjIzM1owgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDMgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDjmFGWHOjVsQaBalfD
cnWTq8+epvzzFlLWLU2fNUSoLgRNB0mKOCn1dzfnt6td3zZxFJmP3MKS8edgkpfs
2Ejcv8ECIMYkpChMMFp2bbFc893enhBxoYjHW5tBbcqwuI4V7q0zK89HBFx1cQqY
JJgpp0lZpd34t0NiYfPT4tBVPwIDAQABMA0GCSqGSIb3DQEBBQUAA4GBAFa7AliE
Zwgs3x/be0kz9dNnnfS0ChCzycUs4pJqcXgn8nCDQtM+z6lU9PHYkhaM0QTLS6vJ
n0WuPIqpsHEzXcjFV9+vqDWzf4mH6eglkrh/hXqu1rweN1gqZ8mRzyqBPu3GOd/A
PhmcGcwTTYJBtYze4D1gCCAPRX5ron+jjBXu
-----END CERTIFICATE-----
...EOF...
cat >certs/http-www-valicert-net.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=Class 1 Validation Authority - OCSP, CN=http://www.valicert.net//Email=info@valicert.com
        Validity
            Not Before: Feb 12 11:50:05 2000 GMT
            Not After : Feb 10 11:50:05 2005 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=Class 1 Validation Authority - OCSP, CN=http://www.valicert.net//Email=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c7:8c:2f:a7:c3:40:87:3b:3d:d7:c4:9a:58:14:
                    64:0a:c3:08:39:62:1a:cf:d2:eb:a9:f1:69:74:8a:
                    ca:0e:5a:76:cc:a2:52:4e:d0:f3:c4:7a:b5:f8:a6:
                    1c:bb:a3:a7:a4:53:87:5b:8d:c0:00:bb:d5:66:24:
                    e7:74:c6:16:c8:af:c8:03:62:d5:32:87:a2:52:91:
                    44:94:95:a8:47:43:6d:a5:48:9c:f6:4c:75:d5:4f:
                    62:e7:c9:ff:7b:f4:24:8c:a7:bc:28:76:b5:32:a0:
                    25:73:b7:47:2f:78:f8:46:f9:87:14:f0:77:fc:0a:
                    77:e8:4f:fd:8c:1f:fa:62:d9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            1.3.6.1.5.5.7.48.1.5: 
                ..
            X509v3 Extended Key Usage: 
                OCSP Signing
            X509v3 Key Usage: 
                Digital Signature, Certificate Sign, CRL Sign
            Authority Information Access: 
                OCSP - URI:http://ocsp2.valicert.net

    Signature Algorithm: sha1WithRSAEncryption
        15:c5:e0:b8:34:72:12:06:20:a8:62:95:93:d1:bc:93:ba:90:
        ab:dc:4e:8d:8e:8d:98:4c:e3:32:f5:2b:3f:b3:97:fb:aa:a2:
        ad:40:97:ad:68:bd:5c:ad:53:0e:d0:a6:b3:0d:ac:1a:99:8d:
        aa:30:1e:cf:0e:70:ff:02:b0:77:65:83:cd:da:07:5c:52:cd:
        59:bb:a2:c8:e2:b4:16:83:8f:d4:95:79:93:2d:e8:bf:44:93:
        31:92:30:d3:34:34:f1:10:fb:21:ac:2e:f4:c3:5d:64:63:7a:
        99:e1:9a:ab:42:1d:48:66:a6:77:37:b8:55:3c:ad:fe:65:b0:
        62:e9
-----BEGIN CERTIFICATE-----
MIIDSDCCArGgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBsjEkMCIGA1UEBxMbVmFs
aUNlcnQgVmFsaWRhdGlvbiBOZXR3b3JrMRcwFQYDVQQKEw5WYWxpQ2VydCwgSW5j
LjEsMCoGA1UECxMjQ2xhc3MgMSBWYWxpZGF0aW9uIEF1dGhvcml0eSAtIE9DU1Ax
ITAfBgNVBAMTGGh0dHA6Ly93d3cudmFsaWNlcnQubmV0LzEgMB4GCSqGSIb3DQEJ
ARYRaW5mb0B2YWxpY2VydC5jb20wHhcNMDAwMjEyMTE1MDA1WhcNMDUwMjEwMTE1
MDA1WjCBsjEkMCIGA1UEBxMbVmFsaUNlcnQgVmFsaWRhdGlvbiBOZXR3b3JrMRcw
FQYDVQQKEw5WYWxpQ2VydCwgSW5jLjEsMCoGA1UECxMjQ2xhc3MgMSBWYWxpZGF0
aW9uIEF1dGhvcml0eSAtIE9DU1AxITAfBgNVBAMTGGh0dHA6Ly93d3cudmFsaWNl
cnQubmV0LzEgMB4GCSqGSIb3DQEJARYRaW5mb0B2YWxpY2VydC5jb20wgZ8wDQYJ
KoZIhvcNAQEBBQADgY0AMIGJAoGBAMeML6fDQIc7PdfEmlgUZArDCDliGs/S66nx
aXSKyg5adsyiUk7Q88R6tfimHLujp6RTh1uNwAC71WYk53TGFsivyANi1TKHolKR
RJSVqEdDbaVInPZMddVPYufJ/3v0JIynvCh2tTKgJXO3Ry94+Eb5hxTwd/wKd+hP
/Ywf+mLZAgMBAAGjbDBqMA8GCSsGAQUFBzABBQQCBQAwEwYDVR0lBAwwCgYIKwYB
BQUHAwkwCwYDVR0PBAQDAgGGMDUGCCsGAQUFBwEBBCkwJzAlBggrBgEFBQcwAYYZ
aHR0cDovL29jc3AyLnZhbGljZXJ0Lm5ldDANBgkqhkiG9w0BAQUFAAOBgQAVxeC4
NHISBiCoYpWT0byTupCr3E6Njo2YTOMy9Ss/s5f7qqKtQJetaL1crVMO0KazDawa
mY2qMB7PDnD/ArB3ZYPN2gdcUs1Zu6LI4rQWg4/UlXmTLei/RJMxkjDTNDTxEPsh
rC70w11kY3qZ4ZqrQh1IZqZ3N7hVPK3+ZbBi6Q==
-----END CERTIFICATE-----
...EOF...
cat >certs/rsa-data-security-inc-secure-server.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            02:ad:66:7e:4e:45:fe:5e:57:6f:3c:98:19:5e:dd:c0
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=RSA Data Security, Inc., OU=Secure Server Certification Authority
        Validity
            Not Before: Nov  9 00:00:00 1994 GMT
            Not After : Jan  7 23:59:59 2010 GMT
        Subject: C=US, O=RSA Data Security, Inc., OU=Secure Server Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1000 bit)
                Modulus (1000 bit):
                    00:92:ce:7a:c1:ae:83:3e:5a:aa:89:83:57:ac:25:
                    01:76:0c:ad:ae:8e:2c:37:ce:eb:35:78:64:54:03:
                    e5:84:40:51:c9:bf:8f:08:e2:8a:82:08:d2:16:86:
                    37:55:e9:b1:21:02:ad:76:68:81:9a:05:a2:4b:c9:
                    4b:25:66:22:56:6c:88:07:8f:f7:81:59:6d:84:07:
                    65:70:13:71:76:3e:9b:77:4c:e3:50:89:56:98:48:
                    b9:1d:a7:29:1a:13:2e:4a:11:59:9c:1e:15:d5:49:
                    54:2c:73:3a:69:82:b1:97:39:9c:6d:70:67:48:e5:
                    dd:2d:d6:c8:1e:7b
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        65:dd:7e:e1:b2:ec:b0:e2:3a:e0:ec:71:46:9a:19:11:b8:d3:
        c7:a0:b4:03:40:26:02:3e:09:9c:e1:12:b3:d1:5a:f6:37:a5:
        b7:61:03:b6:5b:16:69:3b:c6:44:08:0c:88:53:0c:6b:97:49:
        c7:3e:35:dc:6c:b9:bb:aa:df:5c:bb:3a:2f:93:60:b6:a9:4b:
        4d:f2:20:f7:cd:5f:7f:64:7b:8e:dc:00:5c:d7:fa:77:ca:39:
        16:59:6f:0e:ea:d3:b5:83:7f:4d:4d:42:56:76:b4:c9:5f:04:
        f8:38:f8:eb:d2:5f:75:5f:cd:7b:fc:e5:8e:80:7c:fc:50
-----BEGIN CERTIFICATE-----
MIICNDCCAaECEAKtZn5ORf5eV288mBle3cAwDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYD
VQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk0
MTEwOTAwMDAwMFoXDTEwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxIDAeBgNV
BAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2Vy
dmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGbMA0GCSqGSIb3DQEBAQUAA4GJ
ADCBhQJ+AJLOesGugz5aqomDV6wlAXYMra6OLDfO6zV4ZFQD5YRAUcm/jwjiioII
0haGN1XpsSECrXZogZoFokvJSyVmIlZsiAeP94FZbYQHZXATcXY+m3dM41CJVphI
uR2nKRoTLkoRWZweFdVJVCxzOmmCsZc5nG1wZ0jl3S3WyB57AgMBAAEwDQYJKoZI
hvcNAQECBQADfgBl3X7hsuyw4jrg7HFGmhkRuNPHoLQDQCYCPgmc4RKz0Vr2N6W3
YQO2WxZpO8ZECAyIUwxrl0nHPjXcbLm7qt9cuzovk2C2qUtN8iD3zV9/ZHuO3ABc
1/p3yjkWWW8O6tO1g39NTUJWdrTJXwT4OPjr0l91X817/OWOgHz8UA==
-----END CERTIFICATE-----
...EOF...
cat >certs/secure-server-ocsp-responder.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            ff:45:d5:27:5d:24:fb:b3:c2:39:24:53:57:e1:4f:de
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=RSA Data Security, Inc., OU=Secure Server Certification Authority
        Validity
            Not Before: Aug  4 00:00:00 2000 GMT
            Not After : Aug  3 23:59:59 2004 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/RPA (c)00, CN=Secure Server OCSP Responder
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b8:51:99:64:85:0e:ee:b3:0a:68:f0:bf:63:76:
                    1d:53:f5:fc:a1:78:8c:33:ee:9f:f4:be:39:da:9b:
                    0f:4d:47:a9:8f:20:e8:4b:44:bd:ce:cd:7b:90:d1:
                    30:e8:90:c4:25:7b:89:28:de:bd:f6:93:1d:ff:b9:
                    ff:92:b5:a9:8d:e4:ae:cc:e2:c3:07:83:6a:a3:72:
                    10:01:27:62:22:a6:35:26:39:2d:9e:cf:60:0c:fc:
                    47:a4:d7:d0:42:78:a7:1d:6c:d0:cb:4f:15:a7:29:
                    0a:b4:95:45:c4:b1:e7:5a:09:d7:39:95:d8:1d:35:
                    9e:c2:bd:b3:5d:c1:0c:4b:1f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
                DirName:/CN=OCSP 1-4
            X509v3 CRL Distribution Points: 
                URI:http://crl.verisign.com/RSASecureServer-p.crl

            X509v3 Extended Key Usage: 
                OCSP Signing
            Authority Information Access: 
                OCSP - URI:$http://ocsp.verisign.com/ocsp/status

            X509v3 Certificate Policies: 
                Policy: 2.16.840.1.113733.1.7.1.1
                  CPS: https://www.verisign.com/RPA

            X509v3 Basic Constraints: 
                CA:FALSE
            X509v3 Key Usage: 
                Digital Signature
    Signature Algorithm: sha1WithRSAEncryption
        00:b3:10:53:66:9c:49:93:2e:31:a0:02:42:d2:58:57:7e:66:
        a1:fe:1b:8a:61:18:50:40:2c:1e:2b:41:a5:d6:db:ff:ac:08:
        1c:5a:05:6d:02:5c:2a:b6:96:4f:47:db:be:4e:db:ce:cc:ba:
        86:b8:18:ce:b1:12:91:5f:63:f7:f3:48:3e:cc:f1:4d:13:e4:
        6d:09:94:78:00:92:cb:a3:20:9d:06:0b:6a:a0:43:07:ce:d1:
        19:6c:8f:18:75:9a:9f:17:33:fd:a9:26:b8:e3:e2:de:c2:a8:
        c4:5a:8a:7f:98:d6:07:06:6b:cc:56:9e:86:70:ce:d4:ef
-----BEGIN CERTIFICATE-----
MIIDnzCCAwygAwIBAgIRAP9F1SddJPuzwjkkU1fhT94wDQYJKoZIhvcNAQEFBQAw
XzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMu
MS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5
MB4XDTAwMDgwNDAwMDAwMFoXDTA0MDgwMzIzNTk1OVowgZ4xFzAVBgNVBAoTDlZl
cmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTsw
OQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
L1JQQSAoYykwMDElMCMGA1UEAxMcU2VjdXJlIFNlcnZlciBPQ1NQIFJlc3BvbmRl
cjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAuFGZZIUO7rMKaPC/Y3YdU/X8
oXiMM+6f9L452psPTUepjyDoS0S9zs17kNEw6JDEJXuJKN699pMd/7n/krWpjeSu
zOLDB4Nqo3IQASdiIqY1Jjktns9gDPxHpNfQQninHWzQy08VpykKtJVFxLHnWgnX
OZXYHTWewr2zXcEMSx8CAwEAAaOCAR0wggEZMCAGA1UdEQQZMBekFTATMREwDwYD
VQQDEwhPQ1NQIDEtNDA+BgNVHR8ENzA1MDOgMaAvhi1odHRwOi8vY3JsLnZlcmlz
aWduLmNvbS9SU0FTZWN1cmVTZXJ2ZXItcC5jcmwwEwYDVR0lBAwwCgYIKwYBBQUH
AwkwQgYIKwYBBQUHAQEENjA0MDIGCCsGAQUFBzABpiYWJGh0dHA6Ly9vY3NwLnZl
cmlzaWduLmNvbS9vY3NwL3N0YXR1czBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBwEB
MCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlzaWduLmNvbS9SUEEwCQYD
VR0TBAIwADALBgNVHQ8EBAMCB4AwDQYJKoZIhvcNAQEFBQADfgAAsxBTZpxJky4x
oAJC0lhXfmah/huKYRhQQCweK0Gl1tv/rAgcWgVtAlwqtpZPR9u+TtvOzLqGuBjO
sRKRX2P380g+zPFNE+RtCZR4AJLLoyCdBgtqoEMHztEZbI8YdZqfFzP9qSa44+Le
wqjEWop/mNYHBmvMVp6GcM7U7w==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-00.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 0 CA/Email=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 13:54:48 1998 GMT
            Not After : Dec 31 13:54:48 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 0 CA/Email=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:df:7d:e6:be:bf:d5:f0:2f:6d:4e:0e:d1:e0:8d:
                    0b:7f:3b:54:e8:8a:e2:b0:9f:28:c5:8a:c6:b9:b3:
                    33:27:f5:27:ca:1a:4c:54:12:6b:b4:b2:46:b3:1d:
                    4b:b3:f4:21:0b:4b:02:2e:a1:c2:34:9c:85:a0:c4:
                    78:11:db:db:6b:27:2b:09:2a:18:4e:40:cc:9f:71:
                    19:67:99:74:a2:7c:3f:c1:d8:8b:23:c8:63:3b:8a:
                    21:ab:5c:de:1e:f4:8d:dc:b4:18:c3:05:73:f4:6a:
                    b4:a1:fa:01:08:2b:01:0f:6d:37:5b:aa:38:86:67:
                    39:d7:e5:5f:fa:e4:7e:cc:a3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
                https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
                http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
                TC TrustCenter Class 0 CA
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        4d:07:7f:5f:09:30:19:92:aa:05:47:7a:94:75:54:2a:ae:cf:
        fc:d8:0c:42:e1:45:38:2b:24:95:b2:ca:87:ca:79:c4:c3:97:
        90:5e:62:18:c6:c9:38:61:4c:68:35:d3:4c:14:11:eb:c4:cd:
        a1:a9:d8:c5:9e:68:27:32:07:35:45:04:f8:5f:21:a0:60:1e:
        1c:00:48:04:58:d2:c5:cb:ae:6d:32:6e:3d:77:95:8c:85:c7:
        e5:ae:50:9d:75:4a:7b:ff:0b:27:79:ea:4d:a4:59:ff:ec:5a:
        ea:26:a5:39:83:a4:d1:78:ce:a7:a9:7e:bc:dd:2b:ca:12:93:
        03:4a
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDAgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTEzNTQ0OFoX
DTA1MTIzMTEzNTQ0OFowgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyAwIENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA333mvr/V
8C9tTg7R4I0LfztU6IrisJ8oxYrGubMzJ/UnyhpMVBJrtLJGsx1Ls/QhC0sCLqHC
NJyFoMR4EdvbaycrCSoYTkDMn3EZZ5l0onw/wdiLI8hjO4ohq1zeHvSN3LQYwwVz
9Gq0ofoBCCsBD203W6o4hmc51+Vf+uR+zKMCAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyAw
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQBNB39fCTAZ
kqoFR3qUdVQqrs/82AxC4UU4KySVssqHynnEw5eQXmIYxsk4YUxoNdNMFBHrxM2h
qdjFnmgnMgc1RQT4XyGgYB4cAEgEWNLFy65tMm49d5WMhcflrlCddUp7/wsneepN
pFn/7FrqJqU5g6TReM6nqX683SvKEpMDSg==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-01.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 2 (0x2)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 1 CA/Email=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 13:56:33 1998 GMT
            Not After : Dec 31 13:56:33 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 1 CA/Email=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b0:29:eb:b4:76:b3:ae:d7:b6:5b:b4:5e:e7:bd:
                    e3:b1:9c:49:04:57:5b:a1:ab:d9:7f:13:1b:fd:ba:
                    61:ab:d8:e7:71:df:2d:00:94:5d:51:48:7d:23:ef:
                    75:62:84:90:3c:0a:1f:59:11:74:2f:8e:80:a5:fd:
                    30:02:3d:29:52:cd:72:1a:49:21:9c:bc:cb:52:8e:
                    48:a1:63:96:c8:10:85:30:69:57:74:45:c0:5a:86:
                    c6:d5:3d:e0:68:57:7d:31:6a:24:8d:45:97:3e:31:
                    7e:68:66:32:6e:24:6d:ec:32:36:c9:41:ca:f0:31:
                    44:c8:a3:61:ca:1b:a0:36:1f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
                https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
                http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
                TC TrustCenter Class 1 CA
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        05:42:52:26:a4:0c:27:01:44:ac:5c:25:28:c2:44:42:54:08:
        b9:1d:c5:3e:6c:59:66:c4:b3:4e:50:a7:f8:f8:96:75:a1:96:
        75:e8:16:38:a0:cd:5d:6e:fa:79:a7:1b:7b:1d:1e:c3:00:b9:
        66:be:5a:d6:62:0f:e7:f2:7b:b8:ef:4c:e0:c0:3f:59:ae:39:
        b7:84:09:9e:ab:f1:a9:2e:6b:69:e2:ad:cc:f2:ea:78:09:05:
        20:38:42:71:18:7e:c7:b2:97:e6:d5:02:05:06:56:a3:5f:f1:
        aa:c2:c4:4f:fe:f7:ef:16:0f:9d:ec:aa:85:cf:3d:29:24:f1:
        04:cd
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBAjANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDEgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTEzNTYzM1oX
DTA1MTIzMTEzNTYzM1owgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyAxIENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAsCnrtHaz
rte2W7Re573jsZxJBFdboavZfxMb/bphq9jncd8tAJRdUUh9I+91YoSQPAofWRF0
L46Apf0wAj0pUs1yGkkhnLzLUo5IoWOWyBCFMGlXdEXAWobG1T3gaFd9MWokjUWX
PjF+aGYybiRt7DI2yUHK8DFEyKNhyhugNh8CAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyAx
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQAFQlImpAwn
AUSsXCUowkRCVAi5HcU+bFlmxLNOUKf4+JZ1oZZ16BY4oM1dbvp5pxt7HR7DALlm
vlrWYg/n8nu470zgwD9Zrjm3hAmeq/GpLmtp4q3M8up4CQUgOEJxGH7Hspfm1QIF
BlajX/GqwsRP/vfvFg+d7KqFzz0pJPEEzQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-02.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 3 (0x3)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 2 CA/Email=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 13:57:44 1998 GMT
            Not After : Dec 31 13:57:44 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 2 CA/Email=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:da:38:e8:ed:32:00:29:71:83:01:0d:bf:8c:01:
                    dc:da:c6:ad:39:a4:a9:8a:2f:d5:8b:5c:68:5f:50:
                    c6:62:f5:66:bd:ca:91:22:ec:aa:1d:51:d7:3d:b3:
                    51:b2:83:4e:5d:cb:49:b0:f0:4c:55:e5:6b:2d:c7:
                    85:0b:30:1c:92:4e:82:d4:ca:02:ed:f7:6f:be:dc:
                    e0:e3:14:b8:05:53:f2:9a:f4:56:8b:5a:9e:85:93:
                    d1:b4:82:56:ae:4d:bb:a8:4b:57:16:bc:fe:f8:58:
                    9e:f8:29:8d:b0:7b:cd:78:c9:4f:ac:8b:67:0c:f1:
                    9c:fb:fc:57:9b:57:5c:4f:0d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
                https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
                http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
                TC TrustCenter Class 2 CA
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        89:1b:f4:ef:e9:38:e2:6c:0c:f6:cd:6f:49:ce:29:cc:fb:a6:
        0f:f9:8d:3e:95:46:d6:fc:47:32:89:b2:c8:06:61:7a:d2:e7:
        0d:13:02:94:0b:d9:8b:56:47:f4:bb:e7:c5:5f:7b:f4:63:4c:
        ae:7c:34:ea:0d:a2:a9:b3:2c:85:f3:e3:fe:27:54:10:92:b0:
        8f:92:c1:98:42:18:70:48:db:4e:2c:eb:0d:24:68:e4:d1:f7:
        be:09:a9:29:87:bb:e8:da:dc:3e:a3:88:42:31:f5:d1:e3:7f:
        ae:d8:8e:00:5a:74:98:b0:4f:c6:ff:23:7b:5c:73:00:78:c9:
        db:4e
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBAzANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDIgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTEzNTc0NFoX
DTA1MTIzMTEzNTc0NFowgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyAyIENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA2jjo7TIA
KXGDAQ2/jAHc2satOaSpii/Vi1xoX1DGYvVmvcqRIuyqHVHXPbNRsoNOXctJsPBM
VeVrLceFCzAckk6C1MoC7fdvvtzg4xS4BVPymvRWi1qehZPRtIJWrk27qEtXFrz+
+Fie+CmNsHvNeMlPrItnDPGc+/xXm1dcTw0CAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyAy
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQCJG/Tv6Tji
bAz2zW9JzinM+6YP+Y0+lUbW/EcyibLIBmF60ucNEwKUC9mLVkf0u+fFX3v0Y0yu
fDTqDaKpsyyF8+P+J1QQkrCPksGYQhhwSNtOLOsNJGjk0fe+Cakph7vo2tw+o4hC
MfXR43+u2I4AWnSYsE/G/yN7XHMAeMnbTg==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-03.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 4 (0x4)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 3 CA/Email=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 13:58:49 1998 GMT
            Not After : Dec 31 13:58:49 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 3 CA/Email=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b6:b4:c1:35:05:2e:0d:8d:ec:a0:40:6a:1c:0e:
                    27:a6:50:92:6b:50:1b:07:de:2e:e7:76:cc:e0:da:
                    fc:84:a8:5e:8c:63:6a:2b:4d:d9:4e:02:76:11:c1:
                    0b:f2:8d:79:ca:00:b6:f1:b0:0e:d7:fb:a4:17:3d:
                    af:ab:69:7a:96:27:bf:af:33:a1:9a:2a:59:aa:c4:
                    b5:37:08:f2:12:a5:31:b6:43:f5:32:96:71:28:28:
                    ab:8d:28:86:df:bb:ee:e3:0c:7d:30:d6:c3:52:ab:
                    8f:5d:27:9c:6b:c0:a3:e7:05:6b:57:49:44:b3:6e:
                    ea:64:cf:d2:8e:7a:50:77:77
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
                https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
                http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
                TC TrustCenter Class 3 CA
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        84:86:50:62:79:a0:27:e1:25:ba:09:b1:34:0f:13:09:ed:2d:
        ca:a3:e6:95:f9:30:ac:cd:17:a5:ce:3d:97:9d:ec:7c:8f:26:
        7f:c0:61:ca:22:f7:91:dd:3c:36:59:9a:9b:75:f7:bc:e4:c8:
        ed:ec:02:b6:22:a7:f3:2c:f1:c8:92:78:6d:b6:ee:c5:28:ec:
        80:20:4f:b9:6b:08:e7:2f:a7:86:1e:7d:b1:08:9f:54:b9:00:
        37:3c:a0:d8:1a:c8:96:1c:f4:32:14:9c:39:95:b7:ee:f0:43:
        49:c2:5e:e8:cb:79:6f:53:bf:fb:49:8a:2c:d8:4b:d9:55:f2:
        12:70
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBBDANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDMgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTEzNTg0OVoX
DTA1MTIzMTEzNTg0OVowgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyAzIENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtrTBNQUu
DY3soEBqHA4nplCSa1AbB94u53bM4Nr8hKhejGNqK03ZTgJ2EcEL8o15ygC28bAO
1/ukFz2vq2l6lie/rzOhmipZqsS1NwjyEqUxtkP1MpZxKCirjSiG37vu4wx9MNbD
UquPXSeca8Cj5wVrV0lEs27qZM/SjnpQd3cCAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyAz
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQCEhlBieaAn
4SW6CbE0DxMJ7S3Ko+aV+TCszRelzj2Xnex8jyZ/wGHKIveR3Tw2WZqbdfe85Mjt
7AK2IqfzLPHIknhttu7FKOyAIE+5awjnL6eGHn2xCJ9UuQA3PKDYGsiWHPQyFJw5
lbfu8ENJwl7oy3lvU7/7SYos2EvZVfIScA==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-04.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 5 (0x5)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 4 CA/Email=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 14:00:20 1998 GMT
            Not After : Dec 31 14:00:20 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 4 CA/Email=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:bf:2f:63:d6:36:7b:b2:0d:d3:55:f5:64:6c:e6:
                    25:5d:c6:b4:c8:14:ba:25:38:83:eb:56:62:a5:55:
                    a9:65:a3:f4:23:99:c2:4b:b9:d0:cd:54:67:a6:a3:
                    a0:a3:a9:33:2b:76:e4:bd:ad:77:b2:ed:5c:12:74:
                    c3:c5:b6:0f:52:9a:72:93:43:90:62:66:15:0f:45:
                    a5:dd:e0:dd:b8:6f:40:6e:57:c1:79:72:a3:60:aa:
                    ba:76:1d:12:89:53:5a:fc:02:be:e1:09:13:c5:4a:
                    2f:dc:3d:8b:19:ad:d7:8b:24:45:fb:4c:f4:cd:5c:
                    35:1d:29:4c:51:f3:f2:6c:55
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
                https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
                https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
                http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
                TC TrustCenter Class 4 CA
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        94:68:14:1b:25:9e:29:99:b1:b2:23:d2:44:b3:95:9f:d1:9e:
        55:04:dd:e3:2f:82:33:55:96:77:19:9d:2b:9e:65:1c:fa:8a:
        e3:c7:8f:25:fc:b1:1e:55:46:0f:8f:ff:4f:37:2f:a4:76:59:
        a6:64:eb:d5:16:70:bd:dd:95:33:0c:a4:0d:24:eb:64:50:b4:
        43:11:f2:43:be:0d:71:98:22:ec:01:af:ec:f7:c7:5c:71:c3:
        75:91:58:19:e8:dd:a0:f4:b4:f1:bc:10:4a:f3:93:b4:06:49:
        bb:1f:66:d2:bd:74:47:e1:9a:f9:eb:d7:ab:6d:1f:ba:e1:1d:
        2c:da
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBBTANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDQgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTE0MDAyMFoX
DTA1MTIzMTE0MDAyMFowgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyA0IENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAvy9j1jZ7
sg3TVfVkbOYlXca0yBS6JTiD61ZipVWpZaP0I5nCS7nQzVRnpqOgo6kzK3bkva13
su1cEnTDxbYPUppyk0OQYmYVD0Wl3eDduG9AblfBeXKjYKq6dh0SiVNa/AK+4QkT
xUov3D2LGa3XiyRF+0z0zVw1HSlMUfPybFUCAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyA0
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQCUaBQbJZ4p
mbGyI9JEs5Wf0Z5VBN3jL4IzVZZ3GZ0rnmUc+orjx48l/LEeVUYPj/9PNy+kdlmm
ZOvVFnC93ZUzDKQNJOtkULRDEfJDvg1xmCLsAa/s98dcccN1kVgZ6N2g9LTxvBBK
85O0Bkm7H2bSvXRH4Zr569erbR+64R0s2g==
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-personal-basic-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Basic CA/Email=personal-basic@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Basic CA/Email=personal-basic@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:bc:bc:93:53:6d:c0:50:4f:82:15:e6:48:94:35:
                    a6:5a:be:6f:42:fa:0f:47:ee:77:75:72:dd:8d:49:
                    9b:96:57:a0:78:d4:ca:3f:51:b3:69:0b:91:76:17:
                    22:07:97:6a:c4:51:93:4b:e0:8d:ef:37:95:a1:0c:
                    4d:da:34:90:1d:17:89:97:e0:35:38:57:4a:c0:f4:
                    08:70:e9:3c:44:7b:50:7e:61:9a:90:e3:23:d3:88:
                    11:46:27:f5:0b:07:0e:bb:dd:d1:7f:20:0a:88:b9:
                    56:0b:2e:1c:80:da:f1:e3:9e:29:ef:14:bd:0a:44:
                    fb:1b:5b:18:d1:bf:23:93:21
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        2d:e2:99:6b:b0:3d:7a:89:d7:59:a2:94:01:1f:2b:dd:12:4b:
        53:c2:ad:7f:aa:a7:00:5c:91:40:57:25:4a:38:aa:84:70:b9:
        d9:80:0f:a5:7b:5c:fb:73:c6:bd:d7:8a:61:5c:03:e3:2d:27:
        a8:17:e0:84:85:42:dc:5e:9b:c6:b7:b2:6d:bb:74:af:e4:3f:
        cb:a7:b7:b0:e0:5d:be:78:83:25:94:d2:db:81:0f:79:07:6d:
        4f:f4:39:15:5a:52:01:7b:de:32:d6:4d:38:f6:12:5c:06:50:
        df:05:5b:bd:14:4b:a1:df:29:ba:3b:41:8d:f7:63:56:a1:df:
        22:b1
-----BEGIN CERTIFICATE-----
MIIDITCCAoqgAwIBAgIBADANBgkqhkiG9w0BAQQFADCByzELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhhd3RlIFBlcnNvbmFsIEJhc2lj
IENBMSgwJgYJKoZIhvcNAQkBFhlwZXJzb25hbC1iYXNpY0B0aGF3dGUuY29tMB4X
DTk2MDEwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgcsxCzAJBgNVBAYTAlpBMRUw
EwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEaMBgGA1UE
ChMRVGhhd3RlIENvbnN1bHRpbmcxKDAmBgNVBAsTH0NlcnRpZmljYXRpb24gU2Vy
dmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRoYXd0ZSBQZXJzb25hbCBCYXNpYyBD
QTEoMCYGCSqGSIb3DQEJARYZcGVyc29uYWwtYmFzaWNAdGhhd3RlLmNvbTCBnzAN
BgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAvLyTU23AUE+CFeZIlDWmWr5vQvoPR+53
dXLdjUmbllegeNTKP1GzaQuRdhciB5dqxFGTS+CN7zeVoQxN2jSQHReJl+A1OFdK
wPQIcOk8RHtQfmGakOMj04gRRif1CwcOu93RfyAKiLlWCy4cgNrx454p7xS9CkT7
G1sY0b8jkyECAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQQF
AAOBgQAt4plrsD16iddZopQBHyvdEktTwq1/qqcAXJFAVyVKOKqEcLnZgA+le1z7
c8a914phXAPjLSeoF+CEhULcXpvGt7Jtu3Sv5D/Lp7ew4F2+eIMllNLbgQ95B21P
9DkVWlIBe94y1k049hJcBlDfBVu9FEuh3ym6O0GN92NWod8isQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-personal-freemail-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Freemail CA/Email=personal-freemail@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Freemail CA/Email=personal-freemail@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d4:69:d7:d4:b0:94:64:5b:71:e9:47:d8:0c:51:
                    b6:ea:72:91:b0:84:5e:7d:2d:0d:8f:7b:12:df:85:
                    25:75:28:74:3a:42:2c:63:27:9f:95:7b:4b:ef:7e:
                    19:87:1d:86:ea:a3:dd:b9:ce:96:64:1a:c2:14:6e:
                    44:ac:7c:e6:8f:e8:4d:0f:71:1f:40:38:a6:00:a3:
                    87:78:f6:f9:94:86:5e:ad:ea:c0:5e:76:eb:d9:14:
                    a3:5d:6e:7a:7c:0c:a5:4b:55:7f:06:19:29:7f:9e:
                    9a:26:d5:6a:bb:38:24:08:6a:98:c7:b1:da:a3:98:
                    91:fd:79:db:e5:5a:c4:1c:b9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        c7:ec:92:7e:4e:f8:f5:96:a5:67:62:2a:a4:f0:4d:11:60:d0:
        6f:8d:60:58:61:ac:26:bb:52:35:5c:08:cf:30:fb:a8:4a:96:
        8a:1f:62:42:23:8c:17:0f:f4:ba:64:9c:17:ac:47:29:df:9d:
        98:5e:d2:6c:60:71:5c:a2:ac:dc:79:e3:e7:6e:00:47:1f:b5:
        0d:28:e8:02:9d:e4:9a:fd:13:f4:a6:d9:7c:b1:f8:dc:5f:23:
        26:09:91:80:73:d0:14:1b:de:43:a9:83:25:f2:e6:9c:2f:15:
        ca:fe:a6:ab:8a:07:75:8b:0c:dd:51:84:6b:e4:f8:d1:ce:77:
        a2:81
-----BEGIN CERTIFICATE-----
MIIDLTCCApagAwIBAgIBADANBgkqhkiG9w0BAQQFADCB0TELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEkMCIGA1UEAxMbVGhhd3RlIFBlcnNvbmFsIEZyZWVt
YWlsIENBMSswKQYJKoZIhvcNAQkBFhxwZXJzb25hbC1mcmVlbWFpbEB0aGF3dGUu
Y29tMB4XDTk2MDEwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgdExCzAJBgNVBAYT
AlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEa
MBgGA1UEChMRVGhhd3RlIENvbnN1bHRpbmcxKDAmBgNVBAsTH0NlcnRpZmljYXRp
b24gU2VydmljZXMgRGl2aXNpb24xJDAiBgNVBAMTG1RoYXd0ZSBQZXJzb25hbCBG
cmVlbWFpbCBDQTErMCkGCSqGSIb3DQEJARYccGVyc29uYWwtZnJlZW1haWxAdGhh
d3RlLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA1GnX1LCUZFtx6UfY
DFG26nKRsIRefS0Nj3sS34UldSh0OkIsYyeflXtL734Zhx2G6qPduc6WZBrCFG5E
rHzmj+hND3EfQDimAKOHePb5lIZererAXnbr2RSjXW56fAylS1V/Bhkpf56aJtVq
uzgkCGqYx7Hao5iR/Xnb5VrEHLkCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zAN
BgkqhkiG9w0BAQQFAAOBgQDH7JJ+Tvj1lqVnYiqk8E0RYNBvjWBYYawmu1I1XAjP
MPuoSpaKH2JCI4wXD/S6ZJwXrEcp352YXtJsYHFcoqzceePnbgBHH7UNKOgCneSa
/RP0ptl8sfjcXyMmCZGAc9AUG95DqYMl8uacLxXK/qarigd1iwzdUYRr5PjRznei
gQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-personal-premium-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Premium CA/Email=personal-premium@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Premium CA/Email=personal-premium@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c9:66:d9:f8:07:44:cf:b9:8c:2e:f0:a1:ef:13:
                    45:6c:05:df:de:27:16:51:36:41:11:6c:6c:3b:ed:
                    fe:10:7d:12:9e:e5:9b:42:9a:fe:60:31:c3:66:b7:
                    73:3a:48:ae:4e:d0:32:37:94:88:b5:0d:b6:d9:f3:
                    f2:44:d9:d5:88:12:dd:76:4d:f2:1a:fc:6f:23:1e:
                    7a:f1:d8:98:45:4e:07:10:ef:16:42:d0:43:75:6d:
                    4a:de:e2:aa:c9:31:ff:1f:00:70:7c:66:cf:10:25:
                    08:ba:fa:ee:00:e9:46:03:66:27:11:15:3b:aa:5b:
                    f2:98:dd:36:42:b2:da:88:75
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        69:36:89:f7:34:2a:33:72:2f:6d:3b:d4:22:b2:b8:6f:9a:c5:
        36:66:0e:1b:3c:a1:b1:75:5a:e6:fd:35:d3:f8:a8:f2:07:6f:
        85:67:8e:de:2b:b9:e2:17:b0:3a:a0:f0:0e:a2:00:9a:df:f3:
        14:15:6e:bb:c8:85:5a:98:80:f9:ff:be:74:1d:3d:f3:fe:30:
        25:d1:37:34:67:fa:a5:71:79:30:61:29:72:c0:e0:2c:4c:fb:
        56:e4:3a:a8:6f:e5:32:59:52:db:75:28:50:59:0c:f8:0b:19:
        e4:ac:d9:af:96:8d:2f:50:db:07:c3:ea:1f:ab:33:e0:f5:2b:
        31:89
-----BEGIN CERTIFICATE-----
MIIDKTCCApKgAwIBAgIBADANBgkqhkiG9w0BAQQFADCBzzELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEjMCEGA1UEAxMaVGhhd3RlIFBlcnNvbmFsIFByZW1p
dW0gQ0ExKjAoBgkqhkiG9w0BCQEWG3BlcnNvbmFsLXByZW1pdW1AdGhhd3RlLmNv
bTAeFw05NjAxMDEwMDAwMDBaFw0yMDEyMzEyMzU5NTlaMIHPMQswCQYDVQQGEwJa
QTEVMBMGA1UECBMMV2VzdGVybiBDYXBlMRIwEAYDVQQHEwlDYXBlIFRvd24xGjAY
BgNVBAoTEVRoYXd0ZSBDb25zdWx0aW5nMSgwJgYDVQQLEx9DZXJ0aWZpY2F0aW9u
IFNlcnZpY2VzIERpdmlzaW9uMSMwIQYDVQQDExpUaGF3dGUgUGVyc29uYWwgUHJl
bWl1bSBDQTEqMCgGCSqGSIb3DQEJARYbcGVyc29uYWwtcHJlbWl1bUB0aGF3dGUu
Y29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJZtn4B0TPuYwu8KHvE0Vs
Bd/eJxZRNkERbGw77f4QfRKe5ZtCmv5gMcNmt3M6SK5O0DI3lIi1DbbZ8/JE2dWI
Et12TfIa/G8jHnrx2JhFTgcQ7xZC0EN1bUre4qrJMf8fAHB8Zs8QJQi6+u4A6UYD
ZicRFTuqW/KY3TZCstqIdQIDAQABoxMwETAPBgNVHRMBAf8EBTADAQH/MA0GCSqG
SIb3DQEBBAUAA4GBAGk2ifc0KjNyL2071CKyuG+axTZmDhs8obF1Wub9NdP4qPIH
b4Vnjt4rueIXsDqg8A6iAJrf8xQVbrvIhVqYgPn/vnQdPfP+MCXRNzRn+qVxeTBh
KXLA4CxM+1bkOqhv5TJZUtt1KFBZDPgLGeSs2a+WjS9Q2wfD6h+rM+D1KzGJ
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-premium-server-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/Email=premium-server@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/Email=premium-server@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d2:36:36:6a:8b:d7:c2:5b:9e:da:81:41:62:8f:
                    38:ee:49:04:55:d6:d0:ef:1c:1b:95:16:47:ef:18:
                    48:35:3a:52:f4:2b:6a:06:8f:3b:2f:ea:56:e3:af:
                    86:8d:9e:17:f7:9e:b4:65:75:02:4d:ef:cb:09:a2:
                    21:51:d8:9b:d0:67:d0:ba:0d:92:06:14:73:d4:93:
                    cb:97:2a:00:9c:5c:4e:0c:bc:fa:15:52:fc:f2:44:
                    6e:da:11:4a:6e:08:9f:2f:2d:e3:f9:aa:3a:86:73:
                    b6:46:53:58:c8:89:05:bd:83:11:b8:73:3f:aa:07:
                    8d:f4:42:4d:e7:40:9d:1c:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        26:48:2c:16:c2:58:fa:e8:16:74:0c:aa:aa:5f:54:3f:f2:d7:
        c9:78:60:5e:5e:6e:37:63:22:77:36:7e:b2:17:c4:34:b9:f5:
        08:85:fc:c9:01:38:ff:4d:be:f2:16:42:43:e7:bb:5a:46:fb:
        c1:c6:11:1f:f1:4a:b0:28:46:c9:c3:c4:42:7d:bc:fa:ab:59:
        6e:d5:b7:51:88:11:e3:a4:85:19:6b:82:4c:a4:0c:12:ad:e9:
        a4:ae:3f:f1:c3:49:65:9a:8c:c5:c8:3e:25:b7:94:99:bb:92:
        32:71:07:f0:86:5e:ed:50:27:a6:0d:a6:23:f9:bb:cb:a6:07:
        14:42
-----BEGIN CERTIFICATE-----
MIIDJzCCApCgAwIBAgIBATANBgkqhkiG9w0BAQQFADCBzjELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYD
VQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlv
biBTZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhhd3RlIFByZW1pdW0gU2Vy
dmVyIENBMSgwJgYJKoZIhvcNAQkBFhlwcmVtaXVtLXNlcnZlckB0aGF3dGUuY29t
MB4XDTk2MDgwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgc4xCzAJBgNVBAYTAlpB
MRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEdMBsG
A1UEChMUVGhhd3RlIENvbnN1bHRpbmcgY2MxKDAmBgNVBAsTH0NlcnRpZmljYXRp
b24gU2VydmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRoYXd0ZSBQcmVtaXVtIFNl
cnZlciBDQTEoMCYGCSqGSIb3DQEJARYZcHJlbWl1bS1zZXJ2ZXJAdGhhd3RlLmNv
bTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0jY2aovXwlue2oFBYo847kkE
VdbQ7xwblRZH7xhINTpS9CtqBo87L+pW46+GjZ4X9560ZXUCTe/LCaIhUdib0GfQ
ug2SBhRz1JPLlyoAnFxODLz6FVL88kRu2hFKbgifLy3j+ao6hnO2RlNYyIkFvYMR
uHM/qgeN9EJN50CdHDcCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG
9w0BAQQFAAOBgQAmSCwWwlj66BZ0DKqqX1Q/8tfJeGBeXm43YyJ3Nn6yF8Q0ufUI
hfzJATj/Tb7yFkJD57taRvvBxhEf8UqwKEbJw8RCfbz6q1lu1bdRiBHjpIUZa4JM
pAwSremkrj/xw0llmozFyD4lt5SZu5IycQfwhl7tUCemDaYj+bvLpgcUQg==
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-server-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA/Email=server-certs@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA/Email=server-certs@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d3:a4:50:6e:c8:ff:56:6b:e6:cf:5d:b6:ea:0c:
                    68:75:47:a2:aa:c2:da:84:25:fc:a8:f4:47:51:da:
                    85:b5:20:74:94:86:1e:0f:75:c9:e9:08:61:f5:06:
                    6d:30:6e:15:19:02:e9:52:c0:62:db:4d:99:9e:e2:
                    6a:0c:44:38:cd:fe:be:e3:64:09:70:c5:fe:b1:6b:
                    29:b6:2f:49:c8:3b:d4:27:04:25:10:97:2f:e7:90:
                    6d:c0:28:42:99:d7:4c:43:de:c3:f5:21:6d:54:9f:
                    5d:c3:58:e1:c0:e4:d9:5b:b0:b8:dc:b4:7b:df:36:
                    3a:c2:b5:66:22:12:d6:87:0d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        07:fa:4c:69:5c:fb:95:cc:46:ee:85:83:4d:21:30:8e:ca:d9:
        a8:6f:49:1a:e6:da:51:e3:60:70:6c:84:61:11:a1:1a:c8:48:
        3e:59:43:7d:4f:95:3d:a1:8b:b7:0b:62:98:7a:75:8a:dd:88:
        4e:4e:9e:40:db:a8:cc:32:74:b9:6f:0d:c6:e3:b3:44:0b:d9:
        8a:6f:9a:29:9b:99:18:28:3b:d1:e3:40:28:9a:5a:3c:d5:b5:
        e7:20:1b:8b:ca:a4:ab:8d:e9:51:d9:e2:4c:2c:59:a9:da:b9:
        b2:75:1b:f6:42:f2:ef:c7:f2:18:f9:89:bc:a3:ff:8a:23:2e:
        70:47
-----BEGIN CERTIFICATE-----
MIIDEzCCAnygAwIBAgIBATANBgkqhkiG9w0BAQQFADCBxDELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYD
VQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlv
biBTZXJ2aWNlcyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZlciBDQTEm
MCQGCSqGSIb3DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wHhcNOTYwODAx
MDAwMDAwWhcNMjAxMjMxMjM1OTU5WjCBxDELMAkGA1UEBhMCWkExFTATBgNVBAgT
DFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYDVQQKExRUaGF3
dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNl
cyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZlciBDQTEmMCQGCSqGSIb3
DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQAD
gY0AMIGJAoGBANOkUG7I/1Zr5s9dtuoMaHVHoqrC2oQl/Kj0R1HahbUgdJSGHg91
yekIYfUGbTBuFRkC6VLAYttNmZ7iagxEOM3+vuNkCXDF/rFrKbYvScg71CcEJRCX
L+eQbcAoQpnXTEPew/UhbVSfXcNY4cDk2VuwuNy0e982OsK1ZiIS1ocNAgMBAAGj
EzARMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEEBQADgYEAB/pMaVz7lcxG
7oWDTSEwjsrZqG9JGubaUeNgcGyEYRGhGshIPllDfU+VPaGLtwtimHp1it2ITk6e
QNuozDJ0uW8NxuOzRAvZim+aKZuZGCg70eNAKJpaPNW15yAbi8qkq43pUdniTCxZ
qdq5snUb9kLy78fyGPmJvKP/iiMucEc=
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-universal-ca-root.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Thawte, OU=Thawte Universal CA Root, CN=Thawte Universal CA Root
        Validity
            Not Before: Dec  5 13:56:05 1999 GMT
            Not After : Apr  3 13:56:05 2037 GMT
        Subject: O=Thawte, OU=Thawte Universal CA Root, CN=Thawte Universal CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (16384 bit)
                Modulus (16384 bit):
                    00:e2:89:05:6d:c3:7f:ad:a6:89:3a:ff:bb:c7:cd:
                    9d:37:b1:e1:d2:21:1e:9b:61:2a:15:e7:7b:57:4f:
                    55:3c:d0:bb:f9:d9:3d:3e:a6:bc:ec:b4:ad:53:9a:
                    16:02:eb:0b:72:fd:8a:f2:8f:44:05:c5:eb:d3:e5:
                    bd:b6:44:39:e6:fb:47:bf:6a:9e:0a:95:18:e2:68:
                    e2:d6:96:d6:21:ad:88:fd:f5:17:f5:d3:da:42:a5:
                    90:ed:29:95:96:75:3a:da:87:a1:d4:f5:d3:87:de:
                    05:62:a6:e3:66:74:92:cf:a5:bc:bb:df:68:ff:71:
                    75:56:41:59:35:eb:33:5a:66:51:f2:d2:a3:0a:c1:
                    8c:ce:73:5c:11:6f:2d:8c:95:8c:91:b1:fd:cf:e5:
                    ad:56:95:cc:85:92:83:90:55:41:c9:c2:77:ed:f9:
                    a3:74:42:0a:68:08:f3:d0:d1:65:fd:67:2c:34:ff:
                    24:7f:e7:79:c8:07:3b:25:57:dd:a4:0c:98:3d:be:
                    e0:cc:19:65:db:f2:54:a2:af:42:d4:9d:e2:ae:84:
                    23:25:09:33:12:b5:6a:1e:76:c4:8b:d9:49:00:6c:
                    5e:ba:1f:f2:1b:da:67:ca:27:aa:a3:44:23:1b:83:
                    82:ce:f2:ab:33:ed:54:a4:dc:c9:ab:59:65:d1:38:
                    0e:c1:3e:1b:67:8f:d6:75:01:e0:55:22:dd:76:77:
                    ec:8e:dd:f4:cf:79:22:6d:b9:57:03:f5:99:08:a7:
                    3c:3e:34:fb:c4:17:ae:23:58:cd:24:f3:23:ca:6a:
                    02:28:94:01:81:34:b4:6c:6b:ae:8b:1a:c3:a3:d2:
                    09:3c:16:54:f5:36:5f:24:e3:9f:4a:a1:e2:64:c6:
                    16:c3:a6:81:7a:24:36:47:8e:c1:5e:0e:fb:f9:15:
                    78:04:d6:0e:59:d9:9d:58:66:62:d2:94:29:32:32:
                    c8:78:b9:66:f6:b5:56:e1:6c:c6:14:4b:96:52:59:
                    91:02:24:6a:55:47:d7:3f:b6:23:1a:60:77:97:2e:
                    e2:40:af:9e:04:57:9e:ad:11:c5:c9:43:70:ef:48:
                    b4:5e:ac:1c:69:2e:2e:82:d5:5b:8b:be:82:be:19:
                    14:5e:e7:0d:22:c7:51:1b:ff:1e:9b:f1:30:8f:71:
                    31:06:b3:34:27:8f:5f:7a:66:82:4f:8a:2d:13:ab:
                    42:cf:21:56:9e:97:8e:66:36:0f:96:9b:e5:2b:f4:
                    02:a9:2a:6a:8c:2c:c4:c3:b8:70:2c:2d:29:1e:3f:
                    50:77:1e:6d:2a:54:e4:55:0a:91:38:a1:c5:b5:66:
                    a2:76:5a:ee:0f:bf:b4:67:e1:28:6e:0f:e1:36:a1:
                    82:d1:bf:d4:77:e1:c4:67:32:93:78:c8:e7:54:53:
                    fe:23:79:e6:68:cc:26:90:f6:10:63:5d:2a:6f:91:
                    2d:a4:73:32:51:21:f2:bb:15:df:aa:24:08:48:06:
                    de:a1:9e:26:bf:ba:83:bf:7c:a4:c8:a0:8c:bd:d2:
                    ff:bc:84:69:27:13:24:18:c4:45:18:23:26:5e:18:
                    14:ca:2e:88:87:62:a3:53:e6:21:b7:b8:85:7b:9a:
                    85:bb:15:26:72:f8:b9:f7:6a:74:0f:49:3f:92:be:
                    a9:05:b7:99:27:bf:bf:09:17:4b:99:4c:ad:11:10:
                    7c:df:74:31:f6:8f:26:5f:aa:88:ae:38:57:c8:55:
                    2d:d3:fb:d8:1b:51:99:be:25:1b:3a:ba:c0:7d:1b:
                    ed:ce:d2:49:b9:cf:f3:c5:7d:89:90:81:d8:69:48:
                    20:10:a3:f8:ef:92:51:18:32:8b:11:18:c0:3f:1b:
                    85:56:ce:57:c9:f2:82:64:c6:df:02:09:2e:4a:11:
                    2f:b1:27:6d:37:52:f0:f0:16:61:f1:67:8d:df:87:
                    72:af:87:da:cf:fb:50:94:6e:d4:94:85:eb:8a:2c:
                    ea:21:f5:96:4a:44:d5:e0:ce:6a:74:44:4d:d0:05:
                    d3:87:15:ed:36:d0:a4:8b:66:55:70:93:ee:47:06:
                    c1:7e:2e:a5:18:79:67:f3:28:85:f1:70:f7:0e:83:
                    a4:7e:54:9e:5a:76:32:cb:65:1b:b8:cd:fb:c8:28:
                    03:d2:54:91:d1:a7:c5:85:43:08:17:76:a5:e6:2f:
                    67:08:d8:a1:a2:82:2d:0c:f8:c1:af:63:d4:50:77:
                    6d:6b:46:4a:41:85:d5:90:5f:79:2d:c4:ec:d7:11:
                    87:40:8a:e1:68:e2:64:f8:55:32:fb:6f:93:2c:da:
                    77:d9:21:c1:17:e5:36:2c:4e:7e:90:7f:ac:94:2b:
                    32:67:be:38:50:76:b8:ae:41:b9:d7:21:c5:09:4c:
                    60:c8:a3:51:c4:34:9b:57:37:df:cb:c9:33:57:8b:
                    eb:fb:76:9f:19:4d:c5:6a:1f:2a:45:ae:2b:ed:2f:
                    8d:a7:a5:00:cb:04:fa:25:62:2e:74:48:1b:ca:2a:
                    8c:ba:db:b6:7e:f6:bb:02:7c:a9:c3:db:58:78:a1:
                    bf:f0:fe:1a:10:55:11:ce:e8:69:4e:96:65:c6:17:
                    03:d6:07:68:8c:54:82:ae:1c:22:55:3f:f1:f4:09:
                    97:28:c0:46:f7:4e:0b:25:1d:f7:07:d7:09:1d:3a:
                    18:57:38:3b:e8:33:06:e7:8f:78:46:1e:5b:f5:06:
                    b6:ec:b8:a6:0d:f1:ba:13:4b:d6:18:20:dd:69:33:
                    4a:33:15:ae:b8:c8:98:8a:27:2c:93:bc:2d:fb:ee:
                    33:bf:66:e6:4d:ba:b6:9b:06:55:60:97:4b:bc:44:
                    cd:7e:f4:a1:d8:aa:2f:c0:02:28:21:16:62:78:db:
                    08:54:f2:fc:f4:34:e3:c6:8f:1c:43:57:ce:90:1a:
                    4b:dc:2e:3b:28:91:89:3f:7a:da:35:1d:8e:2c:ee:
                    49:ec:f4:33:ad:c9:53:a8:8c:9f:04:53:3e:24:1c:
                    52:c9:12:f9:62:57:a3:bc:ee:2c:eb:40:7c:20:23:
                    70:2b:95:f9:73:17:8a:d1:c1:1c:69:a6:b7:38:9a:
                    67:f7:70:1d:7a:5a:0c:40:cf:62:0f:85:3c:c2:02:
                    4e:7e:b5:f6:c5:2a:29:84:b3:1f:37:2a:e1:aa:72:
                    42:c4:ed:6b:1a:8f:92:1c:5d:be:d1:f2:5b:f2:ab:
                    aa:a9:d2:f5:b8:a4:41:2b:2b:91:6e:12:48:ca:98:
                    d8:37:8d:c8:ed:00:30:b5:b6:04:4e:7e:9c:da:84:
                    ec:c0:fa:7b:e5:1d:88:a4:53:46:b0:94:e4:5c:1b:
                    a1:25:2c:0f:48:52:77:97:09:6c:ec:5b:18:33:83:
                    02:e5:82:7e:cd:85:21:30:11:fd:27:4f:cf:e4:1e:
                    ec:3f:a5:57:6c:e9:2a:30:19:2a:88:e5:c3:69:38:
                    ab:6f:39:71:7f:84:e1:41:c3:e1:cc:2a:89:20:52:
                    2e:83:0f:6c:39:3f:4b:2d:16:ac:2d:f0:24:ac:00:
                    73:f4:9b:b3:06:3f:05:b8:14:85:1f:ab:9e:5c:3c:
                    9e:62:9d:0e:6d:3b:80:09:fc:02:ea:a2:97:74:ca:
                    c7:f9:e3:56:e1:c3:ca:a5:a6:9a:c0:90:e0:24:12:
                    53:d2:c2:8b:da:be:ed:02:43:5e:67:e1:89:98:79:
                    ee:cb:aa:ca:c3:1b:dc:e7:a5:46:a5:7c:6b:16:87:
                    b6:5a:28:d7:db:27:3c:5e:a5:bd:b6:51:dd:1f:43:
                    cf:3b:26:c8:3a:8d:25:61:c1:49:f4:3c:1b:c9:44:
                    ea:af:1c:c2:2b:94:01:2a:0e:30:d1:5b:8b:2b:47:
                    e5:c3:d1:04:03:9b:0e:39:2c:d6:27:d4:e6:70:5a:
                    d9:75:cf:2a:d8:c9:00:05:e4:13:88:ec:c3:39:fb:
                    87:61:30:36:43:03:c8:9e:9c:a2:06:c2:2f:c5:fc:
                    f0:80:63:b1:54:04:a0:4c:a9:2e:c6:f5:76:7a:d8:
                    d0:e4:d4:94:11:e5:15:b5:78:06:dc:b8:80:8f:99:
                    a9:20:33:3d:10:85:4c:65:09:ca:3e:58:5e:60:93:
                    9a:aa:62:5d:c0:51:06:1c:5d:60:a0:0d:9c:4b:43:
                    f6:a7:16:21:a4:87:aa:f2:c1:2e:ee:92:30:b8:9e:
                    df:df:10:01:8b:86:09:70:d8:6c:a8:b7:50:1e:16:
                    96:b4:f7:67:fd:35:3a:21:90:2a:32:c7:00:7b:4d:
                    07:10:09:b9:2f:73:d8:18:7e:67:99:04:4f:06:fc:
                    50:c7:85:9b:9d:40:9d:b3:96:37:fa:a5:dc:b2:72:
                    4e:ef:4e:09:2c:fd:91:fd:4d:f7:bb:a6:a1:3e:ab:
                    7b:a2:03:40:a6:a9:55:27:e2:fa:f9:19:ce:87:75:
                    aa:f1:75:36:f3:f3:b8:91:f8:91:c3:8b:75:13:8e:
                    4c:65:9a:16:39:6a:e5:34:e8:7a:96:59:7f:35:b0:
                    00:fd:5b:69:fc:43:26:fa:f5:28:6e:fe:87:d9:7e:
                    24:fb:b4:a0:82:6e:54:a2:ff:ae:bf:62:b4:f4:72:
                    01:c2:cb:98:47:98:e1:4c:b5:17:80:80:ce:8f:a6:
                    28:ee:1e:45:6a:fb:df:f1:1d:fc:5a:3b:d6:ea:f4:
                    6c:1d:62:49:57:3b:8a:8f:86:ea:f0:53:04:ce:9c:
                    16:68:ff:ba:b9:fc:88:0f:47:f7:02:44:72:40:b8:
                    ca:3b:2d:53:9d:dc:3c:56:8c:59:7b:68:1a:2c:8d:
                    71:bb:6c:00:c7:1a:ce:6f:40:92:b1:a3:2f:0f:d9:
                    44:f2:a3:70:2e:9e:ee:0e:ae:32:d0:3b:3e:8b:07:
                    ea:e6:79:b3:5c:29:e2:7d:6b:a8:5e:f9:5a:31:e8:
                    08:96:a2:8c:03:98:46:f1:b8:7d:90:54:26:ed:76:
                    62:fe:9e:e9:9a:6e:5e:c9:49:c7:5c:34:53:29:54:
                    d9:ec:e4:46:e1:80:3b:75:d9:df:fb:79:d5:87:f1:
                    ba:9e:eb:19:ce:4c:52:73:e6:5b:87:ae:25:4f:39:
                    79:cc:c6:b8:f9:10:7b:ec:f0:9b:71:a4:05:a0:d3:
                    29:d3:4e:7f:1f:f4:2d:28:78:cc:55:95:7b:1e:91:
                    2f:cc:56:18:73:8b:b2:db:bc:69:07:e6:d0:d8:4f:
                    ed:a2:ff:58:85:a3:6d:e0:4a:53:b7:67:7d:8d:0c:
                    5c:5b:7b:77:28:02:35:44:7a:04:d3:28:43:c8:6b:
                    30:17:5d:32:b8:29:35:ba:76:da:3b:14:4a:76:18:
                    58:a4:f8:92:3c:9e:4d:33:6f:46:6b:08:d9:31:48:
                    68:dd:f4:fb:24:56:34:b2:cf:69:66:be:48:d2:8a:
                    66:22:cd:f2:69:cd:c2:53:13:45:29:41:22:d6:5d:
                    98:1f:b6:a4:b2:a3:c2:ee:02:2f:51:1b:dc:83:a4:
                    ec:70:25:a8:d4:08:61:32:6f:e4:a1:81:2e:7c:63:
                    72:fa:29:65:bc:70:44:cf:5d
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        55:9a:34:6a:22:06:69:09:45:33:c7:ae:a9:5c:c7:09:4e:9b:
        86:bc:41:90:d4:94:52:f6:cd:23:29:94:4b:22:cd:e8:bd:fe:
        9d:cd:52:f2:bd:ed:ab:87:c9:ab:ab:46:04:b4:bd:a2:3f:22:
        30:47:50:c0:4b:8c:76:0f:03:f5:92:d2:b1:2d:c4:7a:35:9c:
        c9:73:87:eb:a6:9f:de:0f:73:8d:d3:7f:99:d8:ba:8f:6f:c4:
        f3:be:1a:ae:8b:a2:94:36:90:e2:e5:eb:8d:05:f4:fc:65:df:
        95:f1:c4:94:4d:17:56:d7:9f:3c:8f:50:3c:e7:77:bf:95:86:
        26:64:fb:6a:ff:c6:da:e9:8c:ae:42:bb:69:e5:33:c6:d8:e9:
        0d:c6:55:21:49:c1:0c:b4:a3:f9:9b:4b:5c:de:83:4f:41:03:
        ce:2a:79:68:38:7d:f0:54:49:20:f5:b6:10:ff:08:dc:33:66:
        96:9b:ff:06:de:00:9e:d7:ce:56:43:9a:51:fc:70:cd:f6:f0:
        51:a3:b7:cd:b4:5c:85:62:cd:71:b7:c6:2b:23:2b:dd:c3:6e:
        40:42:fa:37:ff:37:1c:f6:7a:57:94:87:85:23:d7:d4:c9:c7:
        5f:c1:4d:2f:c9:0d:d7:5c:ec:9c:25:ee:9e:30:82:91:96:72:
        b8:75:1d:f8:09:68:57:97:b2:2d:4b:ee:25:ec:7a:24:29:ee:
        72:d4:9c:13:db:ab:dc:03:0a:d8:4a:14:c9:08:57:44:5d:a1:
        b5:53:80:34:f2:14:97:cf:52:de:a2:0e:8a:10:e9:14:ef:d0:
        60:be:61:a1:f1:25:5d:d5:18:73:3f:93:10:ca:96:ee:b3:40:
        d2:db:a3:55:cf:57:5a:a5:0e:4f:75:47:df:ea:f7:90:9a:6d:
        f5:70:2e:1d:14:1c:37:64:04:59:50:b0:dc:72:86:6f:9c:37:
        3d:5d:28:af:73:55:ef:d2:ee:24:74:74:13:ef:dc:db:31:49:
        fb:3f:63:f5:d3:08:3e:33:a5:e7:9d:0a:de:53:2c:51:8e:67:
        db:9b:41:65:41:50:bd:d4:a4:96:6c:87:bc:12:e0:94:c7:d3:
        c0:e4:cb:73:58:00:83:e1:ac:27:85:d6:9d:53:9d:5c:bd:0a:
        3e:03:43:9c:0c:91:f5:6d:7b:f8:40:72:75:ab:11:76:91:2b:
        e1:c6:aa:1f:70:69:76:70:15:09:fe:93:d0:d6:2d:b7:15:6a:
        9b:67:5c:b4:69:9f:25:a6:7d:8a:fb:7d:22:a9:71:f2:ce:4e:
        8c:b8:21:2d:de:fe:41:71:0d:ff:9d:ec:73:a6:bb:07:4f:88:
        0e:58:47:2e:7e:a9:c2:c7:78:dd:ba:7a:9e:4e:e0:30:4e:63:
        6f:85:d4:20:41:e9:fa:fe:43:45:e7:fb:af:7a:b2:ce:a4:05:
        1d:22:9a:58:86:df:e4:ce:4c:a9:fe:d8:16:a5:6f:fb:d8:ce:
        56:7b:f5:d6:20:ef:e4:47:cd:63:24:ff:b9:be:f1:48:a3:c1:
        01:72:e6:bd:c0:ad:ed:26:0d:ca:34:9f:fc:02:2d:20:4f:05:
        20:ae:21:3d:0c:c2:20:3c:3f:f0:04:84:dc:cf:89:fd:b9:25:
        91:8e:d0:43:e6:b3:20:ab:5c:2d:d5:40:9e:a0:4b:d8:f4:b2:
        cc:7d:f1:58:0a:8e:87:ed:88:ac:36:96:e4:56:a0:11:8a:f2:
        9a:d0:b3:57:a3:34:bb:19:ab:38:e1:74:6b:22:c4:31:ce:01:
        d5:1b:36:e3:1e:38:4c:33:93:df:40:e3:59:57:4e:ac:6e:7b:
        1e:5a:3d:c5:1d:5b:ac:c8:10:82:35:02:22:b2:fc:75:e8:10:
        91:8d:c4:7d:78:93:47:9e:1c:9d:ac:6b:62:02:58:8c:d6:1c:
        23:d6:af:78:c2:80:9c:a4:aa:24:54:14:b5:14:98:c6:f8:2b:
        1a:24:cb:71:32:0a:e2:9b:0e:69:6b:dd:7e:8c:64:d1:2e:63:
        ef:0e:7f:b1:3e:88:4c:9d:55:e5:c9:6e:17:04:b7:41:ff:bd:
        8a:41:cb:25:31:6f:44:77:3f:47:b1:fc:81:88:07:8e:05:49:
        20:b7:11:d9:69:03:2a:03:9d:b9:33:84:9a:df:df:7a:e3:46:
        73:a3:d8:a2:8c:53:19:88:55:4c:74:b8:f6:44:84:2b:d1:14:
        2d:4e:39:2e:92:68:ff:69:fc:85:62:1b:eb:55:4f:ef:25:84:
        62:45:99:d6:d8:4e:6f:3f:53:08:7d:1d:06:95:81:80:7f:4f:
        4e:74:36:98:b5:e2:87:70:98:dc:d7:f5:dc:52:15:e6:c6:d6:
        79:96:39:7f:8f:95:cf:ab:80:53:ad:1b:0b:45:40:0e:d4:18:
        bd:2c:de:8a:77:76:fd:f2:44:47:c6:21:d0:e4:74:f0:d8:18:
        05:c8:7c:30:72:c7:df:f1:bb:fc:02:30:a9:f4:42:26:59:0d:
        93:05:82:a1:73:ed:34:e5:38:5d:cd:50:90:fe:94:fc:13:bc:
        bd:fc:a8:a2:88:a7:73:c4:b2:a8:d1:5d:88:c4:02:a2:7a:f1:
        04:c9:fe:8c:74:c9:ef:1d:64:41:9f:ac:1e:96:67:64:ac:ab:
        28:41:c7:9d:f7:c0:98:1b:6e:07:c2:64:7d:5a:83:66:56:28:
        36:9c:e7:fb:1c:77:0e:28:a0:c4:f7:6b:79:39:04:20:84:c7:
        57:93:bc:1b:a0:ea:bc:eb:42:e5:a8:11:fe:fc:ac:65:cc:fd:
        f8:28:88:f4:a5:9a:e5:73:51:e0:a8:9b:0d:03:77:4e:e5:e0:
        98:b3:88:da:7d:e6:c6:9e:7c:14:66:c1:2e:53:4a:92:07:37:
        a0:7e:e9:3d:09:e4:15:7c:cf:fd:b8:41:a5:ef:9e:66:9d:c4:
        5e:07:1d:87:f8:41:ad:ea:e7:2f:d2:41:63:18:37:f9:14:e3:
        4d:d0:e5:f7:43:fd:15:e3:f9:36:73:06:26:df:01:4f:a9:c3:
        4e:de:20:46:77:98:b4:7a:24:2b:3b:75:2b:4e:58:8d:9b:5d:
        a4:c7:16:a0:bc:32:88:3f:a1:83:f3:00:c8:f8:d8:58:e9:63:
        5d:4c:2b:b5:f0:72:41:d8:ab:77:37:d6:72:74:ae:b6:36:9c:
        c8:a6:83:49:4b:e0:c9:56:0b:29:be:00:30:cb:dd:d6:c8:42:
        8a:00:d9:ec:15:d1:34:71:f2:5b:64:87:f6:27:d2:b7:eb:86:
        b0:90:bf:29:db:21:9e:36:8c:e3:20:2f:95:23:51:6c:1b:c2:
        a4:d5:e6:d8:02:43:67:a0:fe:9b:50:03:44:7f:bb:e4:72:d5:
        d1:e4:da:8f:92:14:64:fb:5d:14:10:12:4a:95:06:c9:65:08:
        29:ca:21:a3:26:38:11:c9:27:df:70:67:04:fd:ca:48:32:7f:
        63:b2:45:74:31:50:4f:87:d9:20:70:d2:21:70:b1:d6:10:9d:
        33:5d:78:83:91:6d:55:82:ec:da:e4:62:63:c7:81:46:d7:19:
        65:72:2a:43:19:90:b8:d7:23:4d:4c:1c:e0:44:a9:66:67:ac:
        ee:71:79:27:26:78:6d:72:0e:f5:5d:4b:23:b5:7c:7c:65:e9:
        17:c6:3a:0b:0d:dd:5e:1e:51:c3:86:b8:ec:7f:c7:27:4a:a5:
        46:e8:6a:2d:19:c1:87:a3:cb:99:93:87:64:a2:55:14:4c:b7:
        43:a5:93:d7:e7:d2:4e:79:40:ca:65:99:46:3d:3f:7a:80:7a:
        88:6a:cc:1e:e5:6b:33:46:f4:50:c0:d5:1f:09:b8:cd:8a:2e:
        a1:27:eb:5d:73:a7:e8:6b:0a:e5:57:82:2a:b0:fc:e2:54:52:
        56:f0:ab:a9:12:c6:23:96:07:24:9c:e0:bc:46:a5:b4:20:04:
        da:09:93:63:e5:d4:2e:c2:7e:c5:31:ed:b5:15:74:86:17:b9:
        b3:f3:26:8a:1d:02:6a:da:1a:3f:e8:ba:f1:04:6d:94:51:54:
        e2:5a:b4:59:83:1d:60:d0:2d:73:cc:07:b5:26:8c:f9:d7:c6:
        88:91:ef:80:cf:5d:0f:a1:60:cb:45:d4:42:22:d1:b1:70:1d:
        fd:d0:b7:30:90:3a:c6:48:6d:67:e5:32:da:8f:db:e3:a8:e3:
        1d:20:25:a2:1c:e1:4c:b9:a4:f6:c6:3f:5c:58:0d:bb:c6:b2:
        77:01:16:91:9f:17:06:0d:b7:40:3e:cc:8f:8e:9c:4b:e0:9d:
        7e:9b:1e:05:ab:88:22:fa:d3:28:1b:57:14:64:4a:3e:24:2c:
        38:4d:21:69:00:73:2e:d0:55:2d:74:f2:15:e8:94:43:3e:40:
        2a:c6:c6:b9:6a:5b:de:a2:cc:18:50:54:5d:4e:2a:85:6c:f6:
        92:8b:29:19:7e:e7:ea:4a:e0:22:2b:25:bc:f7:66:cf:77:9a:
        41:74:f2:3c:14:0d:74:69:f5:50:83:cd:cd:2f:21:db:22:46:
        8a:d0:f7:51:1a:95:57:f2:05:8b:1a:19:ed:3b:45:e8:36:c2:
        6e:7e:fb:57:22:00:1f:06:53:a9:ae:93:c6:8f:71:2a:31:45:
        92:e7:8e:6d:e6:99:22:c0:83:fc:ef:dc:57:66:77:4f:a2:36:
        31:fb:a1:13:8d:e5:ca:a3:95:7d:01:0c:64:70:3b:53:42:68:
        80:c7:bb:9d:a8:00:35:69:98:0c:a8:67:d8:43:e5:aa:cf:95:
        e0:51:95:a4:17:3f:42:9d:b8:04:ce:d3:79:79:c8:d3:8a:16:
        32:92:e0:d7:a2:ee:d7:37:4c:2f:ac:b8:7b:be:45:f6:f1:18:
        33:9c:7b:37:a6:24:d9:bc:40:ab:00:e9:c3:37:8b:ab:d8:b6:
        f3:5e:81:4e:b0:14:6b:07:3e:1f:ec:c2:f6:44:22:95:bb:b3:
        e6:6f:d6:f9:70:65:ba:0a:83:65:aa:0e:13:2f:83:13:23:53:
        8b:40:16:fa:ce:2f:fc:4d:04:f8:eb:d8:ac:c5:36:c2:15:57:
        48:38:ec:55:b3:b4:1e:ba:ad:d2:42:06:17:0d:73:c8:57:a6:
        be:96:4d:a9:f2:c0:fb:7a:21:1c:f5:c9:70:a9:82:90:b5:f1:
        0c:d4:79:10:be:81:a6:e9:5c:61:9c:77:79:9a:a4:c3:37:26:
        57:37:c9:52:2c:fa:08:ff:d0:5f:c6:61:c0:f4:76:be:fc:de:
        4e:cf:ab:51:99:71:c7:df:7e:f4:d6:cf:06:56:19:13:53:0b:
        6d:74:59:48:19:9b:53:05:2d:9d:32:54:d3:e5:2c:53:8b:64:
        3e:d4:64:7b:e3:80:09:14:cc:fe:16:46:63:6b:71:69:f8:f9:
        cb:27:f6:88:54:bc:45:b3:ce:02:c8:94:ee:40:5b:f9:42:02:
        c2:ff:b0:d8:2c:eb:28:7f:5e:c9:26:01:99:a7
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-class-1-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            8b:5b:75:56:84:54:85:0b:00:cf:af:38:48:ce:b1:a4
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 1 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 1 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:dd:84:d4:b9:b4:f9:a7:d8:f3:04:78:9c:de:3d:
                    dc:6c:13:16:d9:7a:dd:24:51:66:c0:c7:26:59:0d:
                    ac:06:08:c2:94:d1:33:1f:f0:83:35:1f:6e:1b:c8:
                    de:aa:6e:15:4e:54:27:ef:c4:6d:1a:ec:0b:e3:0e:
                    f0:44:a5:57:c7:40:58:1e:a3:47:1f:71:ec:60:f6:
                    6d:94:c8:18:39:ed:fe:42:18:56:df:e4:4c:49:10:
                    78:4e:01:76:35:63:12:36:dd:66:bc:01:04:36:a3:
                    55:68:d5:a2:36:09:ac:ab:21:26:54:06:ad:3f:ca:
                    14:e0:ac:ca:ad:06:1d:95:e2:f8:9d:f1:e0:60:ff:
                    c2:7f:75:2b:4c:cc:da:fe:87:99:21:ea:ba:fe:3e:
                    54:d7:d2:59:78:db:3c:6e:cf:a0:13:00:1a:b8:27:
                    a1:e4:be:67:96:ca:a0:c5:b3:9c:dd:c9:75:9e:eb:
                    30:9a:5f:a3:cd:d9:ae:78:19:3f:23:e9:5c:db:29:
                    bd:ad:55:c8:1b:54:8c:63:f6:e8:a6:ea:c7:37:12:
                    5c:a3:29:1e:02:d9:db:1f:3b:b4:d7:0f:56:47:81:
                    15:04:4a:af:83:27:d1:c5:58:88:c1:dd:f6:aa:a7:
                    a3:18:da:68:aa:6d:11:51:e1:bf:65:6b:9f:96:76:
                    d1:3d
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        ab:66:8d:d7:b3:ba:c7:9a:b6:e6:55:d0:05:f1:9f:31:8d:5a:
        aa:d9:aa:46:26:0f:71:ed:a5:ad:53:56:62:01:47:2a:44:e9:
        fe:3f:74:0b:13:9b:b9:f4:4d:1b:b2:d1:5f:b2:b6:d2:88:5c:
        b3:9f:cd:cb:d4:a7:d9:60:95:84:3a:f8:c1:37:1d:61:ca:e7:
        b0:c5:e5:91:da:54:a6:ac:31:81:ae:97:de:cd:08:ac:b8:c0:
        97:80:7f:6e:72:a4:e7:69:13:95:65:1f:c4:93:3c:fd:79:8f:
        04:d4:3e:4f:ea:f7:9e:ce:cd:67:7c:4f:65:02:ff:91:85:54:
        73:c7:ff:36:f7:86:2d:ec:d0:5e:4f:ff:11:9f:72:06:d6:b8:
        1a:f1:4c:0d:26:65:e2:44:80:1e:c7:9f:e3:dd:e8:0a:da:ec:
        a5:20:80:69:68:a1:4f:7e:e1:6b:cf:07:41:fa:83:8e:bc:38:
        dd:b0:2e:11:b1:6b:b2:42:cc:9a:bc:f9:48:22:79:4a:19:0f:
        b2:1c:3e:20:74:d9:6a:c3:be:f2:28:78:13:56:79:4f:6d:50:
        ea:1b:b0:b5:57:b1:37:66:58:23:f3:dc:0f:df:0a:87:c4:ef:
        86:05:d5:38:14:60:99:a3:4b:de:06:96:71:2c:f2:db:b6:1f:
        a4:ef:3f:ee
-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCLW3VWhFSFCwDPrzhIzrGkMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN2E1Lm0+afY8wR4
nN493GwTFtl63SRRZsDHJlkNrAYIwpTRMx/wgzUfbhvI3qpuFU5UJ+/EbRrsC+MO
8ESlV8dAWB6jRx9x7GD2bZTIGDnt/kIYVt/kTEkQeE4BdjVjEjbdZrwBBDajVWjV
ojYJrKshJlQGrT/KFOCsyq0GHZXi+J3x4GD/wn91K0zM2v6HmSHquv4+VNfSWXjb
PG7PoBMAGrgnoeS+Z5bKoMWznN3JdZ7rMJpfo83ZrngZPyPpXNspva1VyBtUjGP2
6KbqxzcSXKMpHgLZ2x87tNcPVkeBFQRKr4Mn0cVYiMHd9qqnoxjaaKptEVHhv2Vr
n5Z20T0CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAq2aN17O6x5q25lXQBfGfMY1a
qtmqRiYPce2lrVNWYgFHKkTp/j90CxObufRNG7LRX7K20ohcs5/Ny9Sn2WCVhDr4
wTcdYcrnsMXlkdpUpqwxga6X3s0IrLjAl4B/bnKk52kTlWUfxJM8/XmPBNQ+T+r3
ns7NZ3xPZQL/kYVUc8f/NveGLezQXk//EZ9yBta4GvFMDSZl4kSAHsef493oCtrs
pSCAaWihT37ha88HQfqDjrw43bAuEbFrskLMmrz5SCJ5ShkPshw+IHTZasO+8ih4
E1Z5T21Q6huwtVexN2ZYI/PcD98Kh8TvhgXVOBRgmaNL3gaWcSzy27YfpO8/7g==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-class-2-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            61:70:cb:49:8c:5f:98:45:29:e7:b0:a6:d9:50:5b:7a
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 2 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 2 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:af:0a:0d:c2:d5:2c:db:67:b9:2d:e5:94:27:dd:
                    a5:be:e0:b0:4d:8f:b3:61:56:3c:d6:7c:c3:f4:cd:
                    3e:86:cb:a2:88:e2:e1:d8:a4:69:c5:b5:e2:bf:c1:
                    a6:47:50:5e:46:39:8b:d5:96:ba:b5:6f:14:bf:10:
                    ce:27:13:9e:05:47:9b:31:7a:13:d8:1f:d9:d3:02:
                    37:8b:ad:2c:47:f0:8e:81:06:a7:0d:30:0c:eb:f7:
                    3c:0f:20:1d:dc:72:46:ee:a5:02:c8:5b:c3:c9:56:
                    69:4c:c5:18:c1:91:7b:0b:d5:13:00:9b:bc:ef:c3:
                    48:3e:46:60:20:85:2a:d5:90:b6:cd:8b:a0:cc:32:
                    dd:b7:fd:40:55:b2:50:1c:56:ae:cc:8d:77:4d:c7:
                    20:4d:a7:31:76:ef:68:92:8a:90:1e:08:81:56:b2:
                    ad:69:a3:52:d0:cb:1c:c4:23:3d:1f:99:fe:4c:e8:
                    16:63:8e:c6:08:8e:f6:31:f6:d2:fa:e5:76:dd:b5:
                    1c:92:a3:49:cd:cd:01:cd:68:cd:a9:69:ba:a3:eb:
                    1d:0d:9c:a4:20:a6:c1:a0:c5:d1:46:4c:17:6d:d2:
                    ac:66:3f:96:8c:e0:84:d4:36:ff:22:59:c5:f9:11:
                    60:a8:5f:04:7d:f2:1a:f6:25:42:61:0f:c4:4a:b8:
                    3e:89
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        34:26:15:3c:c0:8d:4d:43:49:1d:bd:e9:21:92:d7:66:9c:b7:
        de:c5:b8:d0:e4:5d:5f:76:22:c0:26:f9:84:3a:3a:f9:8c:b5:
        fb:ec:60:f1:e8:ce:04:b0:c8:dd:a7:03:8f:30:f3:98:df:a4:
        e6:a4:31:df:d3:1c:0b:46:dc:72:20:3f:ae:ee:05:3c:a4:33:
        3f:0b:39:ac:70:78:73:4b:99:2b:df:30:c2:54:b0:a8:3b:55:
        a1:fe:16:28:cd:42:bd:74:6e:80:db:27:44:a7:ce:44:5d:d4:
        1b:90:98:0d:1e:42:94:b1:00:2c:04:d0:74:a3:02:05:22:63:
        63:cd:83:b5:fb:c1:6d:62:6b:69:75:fd:5d:70:41:b9:f5:bf:
        7c:df:be:c1:32:73:22:21:8b:58:81:7b:15:91:7a:ba:e3:64:
        48:b0:7f:fb:36:25:da:95:d0:f1:24:14:17:dd:18:80:6b:46:
        23:39:54:f5:8e:62:09:04:1d:94:90:a6:9b:e6:25:e2:42:45:
        aa:b8:90:ad:be:08:8f:a9:0b:42:18:94:cf:72:39:e1:b1:43:
        e0:28:cf:b7:e7:5a:6c:13:6b:49:b3:ff:e3:18:7c:89:8b:33:
        5d:ac:33:d7:a7:f9:da:3a:55:c9:58:10:f9:aa:ef:5a:b6:cf:
        4b:4b:df:2a
-----BEGIN CERTIFICATE-----
MIIEGTCCAwECEGFwy0mMX5hFKeewptlQW3owDQYJKoZIhvcNAQEFBQAwgcoxCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVy
aVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDE5OTkgVmVyaVNpZ24s
IEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVyaVNp
Z24gQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0
eSAtIEczMB4XDTk5MTAwMTAwMDAwMFoXDTM2MDcxNjIzNTk1OVowgcoxCzAJBgNV
BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
Z24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDE5OTkgVmVyaVNpZ24sIElu
Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVyaVNpZ24g
Q2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAt
IEczMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArwoNwtUs22e5LeWU
J92lvuCwTY+zYVY81nzD9M0+hsuiiOLh2KRpxbXiv8GmR1BeRjmL1Za6tW8UvxDO
JxOeBUebMXoT2B/Z0wI3i60sR/COgQanDTAM6/c8DyAd3HJG7qUCyFvDyVZpTMUY
wZF7C9UTAJu878NIPkZgIIUq1ZC2zYugzDLdt/1AVbJQHFauzI13TccgTacxdu9o
koqQHgiBVrKtaaNS0MscxCM9H5n+TOgWY47GCI72MfbS+uV23bUckqNJzc0BzWjN
qWm6o+sdDZykIKbBoMXRRkwXbdKsZj+WjOCE1Db/IlnF+RFgqF8EffIa9iVCYQ/E
Srg+iQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQA0JhU8wI1NQ0kdvekhktdmnLfe
xbjQ5F1fdiLAJvmEOjr5jLX77GDx6M4EsMjdpwOPMPOY36TmpDHf0xwLRtxyID+u
7gU8pDM/CzmscHhzS5kr3zDCVLCoO1Wh/hYozUK9dG6A2ydEp85EXdQbkJgNHkKU
sQAsBNB0owIFImNjzYO1+8FtYmtpdf1dcEG59b98377BMnMiIYtYgXsVkXq642RI
sH/7NiXaldDxJBQX3RiAa0YjOVT1jmIJBB2UkKab5iXiQkWquJCtvgiPqQtCGJTP
cjnhsUPgKM+351psE2tJs//jGHyJizNdrDPXp/naOlXJWBD5qu9ats9LS98q
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-class-3-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            9b:7e:06:49:a3:3e:62:b9:d5:ee:90:48:71:29:ef:57
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:cb:ba:9c:52:fc:78:1f:1a:1e:6f:1b:37:73:bd:
                    f8:c9:6b:94:12:30:4f:f0:36:47:f5:d0:91:0a:f5:
                    17:c8:a5:61:c1:16:40:4d:fb:8a:61:90:e5:76:20:
                    c1:11:06:7d:ab:2c:6e:a6:f5:11:41:8e:fa:2d:ad:
                    2a:61:59:a4:67:26:4c:d0:e8:bc:52:5b:70:20:04:
                    58:d1:7a:c9:a4:69:bc:83:17:64:ad:05:8b:bc:d0:
                    58:ce:8d:8c:f5:eb:f0:42:49:0b:9d:97:27:67:32:
                    6e:e1:ae:93:15:1c:70:bc:20:4d:2f:18:de:92:88:
                    e8:6c:85:57:11:1a:e9:7e:e3:26:11:54:a2:45:96:
                    55:83:ca:30:89:e8:dc:d8:a3:ed:2a:80:3f:7f:79:
                    65:57:3e:15:20:66:08:2f:95:93:bf:aa:47:2f:a8:
                    46:97:f0:12:e2:fe:c2:0a:2b:51:e6:76:e6:b7:46:
                    b7:e2:0d:a6:cc:a8:c3:4c:59:55:89:e6:e8:53:5c:
                    1c:ea:9d:f0:62:16:0b:a7:c9:5f:0c:f0:de:c2:76:
                    ce:af:f7:6a:f2:fa:41:a6:a2:33:14:c9:e5:7a:63:
                    d3:9e:62:37:d5:85:65:9e:0e:e6:53:24:74:1b:5e:
                    1d:12:53:5b:c7:2c:e7:83:49:3b:15:ae:8a:68:b9:
                    57:97
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        11:14:96:c1:ab:92:08:f7:3f:2f:c9:b2:fe:e4:5a:9f:64:de:
        db:21:4f:86:99:34:76:36:57:dd:d0:15:2f:c5:ad:7f:15:1f:
        37:62:73:3e:d4:e7:5f:ce:17:03:db:35:fa:2b:db:ae:60:09:
        5f:1e:5f:8f:6e:bb:0b:3d:ea:5a:13:1e:0c:60:6f:b5:c0:b5:
        23:22:2e:07:0b:cb:a9:74:cb:47:bb:1d:c1:d7:a5:6b:cc:2f:
        d2:42:fd:49:dd:a7:89:cf:53:ba:da:00:5a:28:bf:82:df:f8:
        ba:13:1d:50:86:82:fd:8e:30:8f:29:46:b0:1e:3d:35:da:38:
        62:16:18:4a:ad:e6:b6:51:6c:de:af:62:eb:01:d0:1e:24:fe:
        7a:8f:12:1a:12:68:b8:fb:66:99:14:14:45:5c:ae:e7:ae:69:
        17:81:2b:5a:37:c9:5e:2a:f4:c6:e2:a1:5c:54:9b:a6:54:00:
        cf:f0:f1:c1:c7:98:30:1a:3b:36:16:db:a3:6e:ea:fd:ad:b2:
        c2:da:ef:02:47:13:8a:c0:f1:b3:31:ad:4f:1c:e1:4f:9c:af:
        0f:0c:9d:f7:78:0d:d8:f4:35:56:80:da:b7:6d:17:8f:9d:1e:
        81:64:e1:fe:c5:45:ba:ad:6b:b9:0a:7a:4e:4f:4b:84:ee:4b:
        f1:7d:dd:11
-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCbfgZJoz5iudXukEhxKe9XMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMu6nFL8eB8aHm8b
N3O9+MlrlBIwT/A2R/XQkQr1F8ilYcEWQE37imGQ5XYgwREGfassbqb1EUGO+i2t
KmFZpGcmTNDovFJbcCAEWNF6yaRpvIMXZK0Fi7zQWM6NjPXr8EJJC52XJ2cybuGu
kxUccLwgTS8Y3pKI6GyFVxEa6X7jJhFUokWWVYPKMIno3Nij7SqAP395ZVc+FSBm
CC+Vk7+qRy+oRpfwEuL+wgorUeZ25rdGt+INpsyow0xZVYnm6FNcHOqd8GIWC6fJ
Xwzw3sJ2zq/3avL6QaaiMxTJ5Xpj055iN9WFZZ4O5lMkdBteHRJTW8cs54NJOxWu
imi5V5cCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAERSWwauSCPc/L8my/uRan2Te
2yFPhpk0djZX3dAVL8WtfxUfN2JzPtTnX84XA9s1+ivbrmAJXx5fj267Cz3qWhMe
DGBvtcC1IyIuBwvLqXTLR7sdwdela8wv0kL9Sd2nic9TutoAWii/gt/4uhMdUIaC
/Y4wjylGsB49Ndo4YhYYSq3mtlFs3q9i6wHQHiT+eo8SGhJouPtmmRQURVyu565p
F4ErWjfJXir0xuKhXFSbplQAz/DxwceYMBo7Nhbbo27q/a2ywtrvAkcTisDxszGt
TxzhT5yvDwyd93gN2PQ1VoDat20Xj50egWTh/sVFuq1ruQp6Tk9LhO5L8X3dEQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-class-4-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            ec:a0:a7:8b:6e:75:6a:01:cf:c4:7c:cc:2f:94:5e:d7
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 4 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 4 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ad:cb:a5:11:69:c6:59:ab:f1:8f:b5:19:0f:56:
                    ce:cc:b5:1f:20:e4:9e:26:25:4b:e0:73:65:89:59:
                    de:d0:83:e4:f5:0f:b5:bb:ad:f1:7c:e8:21:fc:e4:
                    e8:0c:ee:7c:45:22:19:76:92:b4:13:b7:20:5b:09:
                    fa:61:ae:a8:f2:a5:8d:85:c2:2a:d6:de:66:36:d2:
                    9b:02:f4:a8:92:60:7c:9c:69:b4:8f:24:1e:d0:86:
                    52:f6:32:9c:41:58:1e:22:bd:cd:45:62:95:08:6e:
                    d0:66:dd:53:a2:cc:f0:10:dc:54:73:8b:04:a1:46:
                    33:33:5c:17:40:b9:9e:4d:d3:f3:be:55:83:e8:b1:
                    89:8e:5a:7c:9a:96:22:90:3b:88:25:f2:d2:53:88:
                    02:0c:0b:78:f2:e6:37:17:4b:30:46:07:e4:80:6d:
                    a6:d8:96:2e:e8:2c:f8:11:b3:38:0d:66:a6:9b:ea:
                    c9:23:5b:db:8e:e2:f3:13:8e:1a:59:2d:aa:02:f0:
                    ec:a4:87:66:dc:c1:3f:f5:d8:b9:f4:ec:82:c6:d2:
                    3d:95:1d:e5:c0:4f:84:c9:d9:a3:44:28:06:6a:d7:
                    45:ac:f0:6b:6a:ef:4e:5f:f8:11:82:1e:38:63:34:
                    66:50:d4:3e:93:73:fa:30:c3:66:ad:ff:93:2d:97:
                    ef:03
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        8f:fa:25:6b:4f:5b:e4:a4:4e:27:55:ab:22:15:59:3c:ca:b5:
        0a:d4:4a:db:ab:dd:a1:5f:53:c5:a0:57:39:c2:ce:47:2b:be:
        3a:c8:56:bf:c2:d9:27:10:3a:b1:05:3c:c0:77:31:bb:3a:d3:
        05:7b:6d:9a:1c:30:8c:80:cb:93:93:2a:83:ab:05:51:82:02:
        00:11:67:6b:f3:88:61:47:5f:03:93:d5:5b:0d:e0:f1:d4:a1:
        32:35:85:b2:3a:db:b0:82:ab:d1:cb:0a:bc:4f:8c:5b:c5:4b:
        00:3b:1f:2a:82:a6:7e:36:85:dc:7e:3c:67:00:b5:e4:3b:52:
        e0:a8:eb:5d:15:f9:c6:6d:f0:ad:1d:0e:85:b7:a9:9a:73:14:
        5a:5b:8f:41:28:c0:d5:e8:2d:4d:a4:5e:cd:aa:d9:ed:ce:dc:
        d8:d5:3c:42:1d:17:c1:12:5d:45:38:c3:38:f3:fc:85:2e:83:
        46:48:b2:d7:20:5f:92:36:8f:e7:79:0f:98:5e:99:e8:f0:d0:
        a4:bb:f5:53:bd:2a:ce:59:b0:af:6e:7f:6c:bb:d2:1e:00:b0:
        21:ed:f8:41:62:82:b9:d8:b2:c4:bb:46:50:f3:31:c5:8f:01:
        a8:74:eb:f5:78:27:da:e7:f7:66:43:f3:9e:83:3e:20:aa:c3:
        35:60:91:ce
-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQDsoKeLbnVqAc/EfMwvlF7XMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDQgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDQgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK3LpRFpxlmr8Y+1
GQ9Wzsy1HyDkniYlS+BzZYlZ3tCD5PUPtbut8XzoIfzk6AzufEUiGXaStBO3IFsJ
+mGuqPKljYXCKtbeZjbSmwL0qJJgfJxptI8kHtCGUvYynEFYHiK9zUVilQhu0Gbd
U6LM8BDcVHOLBKFGMzNcF0C5nk3T875Vg+ixiY5afJqWIpA7iCXy0lOIAgwLePLm
NxdLMEYH5IBtptiWLugs+BGzOA1mppvqySNb247i8xOOGlktqgLw7KSHZtzBP/XY
ufTsgsbSPZUd5cBPhMnZo0QoBmrXRazwa2rvTl/4EYIeOGM0ZlDUPpNz+jDDZq3/
ky2X7wMCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAj/ola09b5KROJ1WrIhVZPMq1
CtRK26vdoV9TxaBXOcLORyu+OshWv8LZJxA6sQU8wHcxuzrTBXttmhwwjIDLk5Mq
g6sFUYICABFna/OIYUdfA5PVWw3g8dShMjWFsjrbsIKr0csKvE+MW8VLADsfKoKm
fjaF3H48ZwC15DtS4KjrXRX5xm3wrR0OhbepmnMUWluPQSjA1egtTaRezarZ7c7c
2NU8Qh0XwRJdRTjDOPP8hS6DRkiy1yBfkjaP53kPmF6Z6PDQpLv1U70qzlmwr25/
bLvSHgCwIe34QWKCudiyxLtGUPMxxY8BqHTr9Xgn2uf3ZkPznoM+IKrDNWCRzg==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-class-1-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            cd:ba:7f:56:f0:df:e4:bc:54:fe:22:ac:b3:72:aa:55
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e5:19:bf:6d:a3:56:61:2d:99:48:71:f6:67:de:
                    b9:8d:eb:b7:9e:86:80:0a:91:0e:fa:38:25:af:46:
                    88:82:e5:73:a8:a0:9b:24:5d:0d:1f:cc:65:6e:0c:
                    b0:d0:56:84:18:87:9a:06:9b:10:a1:73:df:b4:58:
                    39:6b:6e:c1:f6:15:d5:a8:a8:3f:aa:12:06:8d:31:
                    ac:7f:b0:34:d7:8f:34:67:88:09:cd:14:11:e2:4e:
                    45:56:69:1f:78:02:80:da:dc:47:91:29:bb:36:c9:
                    63:5c:c5:e0:d7:2d:87:7b:a1:b7:32:b0:7b:30:ba:
                    2a:2f:31:aa:ee:a3:67:da:db
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        4c:3f:b8:8b:c6:68:df:ee:43:33:0e:5d:e9:a6:cb:07:84:4d:
        7a:33:ff:92:1b:f4:36:ad:d8:95:22:36:68:11:6c:7c:42:cc:
        f3:9c:2e:c4:07:3f:14:b0:0f:4f:ff:90:92:76:f9:e2:bc:4a:
        e9:8f:cd:a0:80:0a:f7:c5:29:f1:82:22:5d:b8:b1:dd:81:23:
        a3:7b:25:15:46:30:79:16:f8:ea:05:4b:94:7f:1d:c2:1c:c8:
        e3:b7:f4:10:40:3c:13:c3:5f:1f:53:e8:48:e4:86:b4:7b:a1:
        35:b0:7b:25:ba:b8:d3:8e:ab:3f:38:9d:00:34:00:98:f3:d1:
        71:94
-----BEGIN CERTIFICATE-----
MIICPTCCAaYCEQDNun9W8N/kvFT+IqyzcqpVMA0GCSqGSIb3DQEBAgUAMF8xCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xh
c3MgMSBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05
NjAxMjkwMDAwMDBaFw0yODA4MDEyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYD
VQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMSBQdWJsaWMgUHJp
bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOB
jQAwgYkCgYEA5Rm/baNWYS2ZSHH2Z965jeu3noaACpEO+jglr0aIguVzqKCbJF0N
H8xlbgyw0FaEGIeaBpsQoXPftFg5a27B9hXVqKg/qhIGjTGsf7A01480Z4gJzRQR
4k5FVmkfeAKA2txHkSm7NsljXMXg1y2He6G3MrB7MLoqLzGq7qNn2tsCAwEAATAN
BgkqhkiG9w0BAQIFAAOBgQBMP7iLxmjf7kMzDl3ppssHhE16M/+SG/Q2rdiVIjZo
EWx8QszznC7EBz8UsA9P/5CSdvnivErpj82ggAr3xSnxgiJduLHdgSOjeyUVRjB5
FvjqBUuUfx3CHMjjt/QQQDwTw18fU+hI5Ia0e6E1sHslurjTjqs/OJ0ANACY89Fx
lA==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-class-2-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            2d:1b:fc:4a:17:8d:a3:91:eb:e7:ff:f5:8b:45:be:0b
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b6:5a:8b:a3:0d:6a:23:83:80:6b:cf:39:87:f4:
                    21:13:33:06:4c:25:a2:ed:55:12:97:c5:a7:80:b9:
                    fa:83:c1:20:a0:fa:2f:15:0d:7c:a1:60:6b:7e:79:
                    2c:fa:06:0f:3a:ae:f6:1b:6f:b1:d2:ff:2f:28:52:
                    5f:83:7d:4b:c4:7a:b7:f8:66:1f:80:54:fc:b7:c2:
                    8e:59:4a:14:57:46:d1:9a:93:be:41:91:03:bb:15:
                    80:93:5c:eb:e7:cc:08:6c:3f:3e:b3:4a:fc:ff:4b:
                    6c:23:d5:50:82:26:44:19:8e:23:c3:71:ea:19:24:
                    47:04:9e:75:bf:c8:a6:00:1f
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        8a:1b:2b:fa:39:c1:74:d7:5e:d8:19:64:a2:58:4a:2d:37:e0:
        33:47:0f:ac:ed:f7:aa:db:1e:e4:8b:06:5c:60:27:ca:45:52:
        ce:16:ef:3f:06:64:e7:94:68:7c:60:33:15:11:69:af:9d:62:
        8d:a3:03:54:6b:a6:be:e5:ee:05:18:60:04:bf:42:80:fd:d0:
        a8:a8:1e:01:3b:f7:a3:5c:af:a3:dc:e6:26:80:23:3c:b8:44:
        74:f7:0a:ae:49:8b:61:78:cc:24:bf:88:8a:a7:0e:ea:73:19:
        41:fd:4d:03:f0:88:d1:e5:78:8d:a5:2a:4f:f6:97:0d:17:77:
        ca:d8
-----BEGIN CERTIFICATE-----
MIICPDCCAaUCEC0b/EoXjaOR6+f/9YtFvgswDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQC2WoujDWojg4BrzzmH9CETMwZMJaLtVRKXxaeAufqDwSCg+i8VDXyh
YGt+eSz6Bg86rvYbb7HS/y8oUl+DfUvEerf4Zh+AVPy3wo5ZShRXRtGak75BkQO7
FYCTXOvnzAhsPz6zSvz/S2wj1VCCJkQZjiPDceoZJEcEnnW/yKYAHwIDAQABMA0G
CSqGSIb3DQEBAgUAA4GBAIobK/o5wXTXXtgZZKJYSi034DNHD6zt96rbHuSLBlxg
J8pFUs4W7z8GZOeUaHxgMxURaa+dYo2jA1Rrpr7l7gUYYAS/QoD90KioHgE796Nc
r6Pc5iaAIzy4RHT3Cq5Ji2F4zCS/iIqnDupzGUH9TQPwiNHleI2lKk/2lw0Xd8rY
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-class-3-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            70:ba:e4:1d:10:d9:29:34:b6:38:ca:7b:03:cc:ba:bf
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c9:5c:59:9e:f2:1b:8a:01:14:b4:10:df:04:40:
                    db:e3:57:af:6a:45:40:8f:84:0c:0b:d1:33:d9:d9:
                    11:cf:ee:02:58:1f:25:f7:2a:a8:44:05:aa:ec:03:
                    1f:78:7f:9e:93:b9:9a:00:aa:23:7d:d6:ac:85:a2:
                    63:45:c7:72:27:cc:f4:4c:c6:75:71:d2:39:ef:4f:
                    42:f0:75:df:0a:90:c6:8e:20:6f:98:0f:f8:ac:23:
                    5f:70:29:36:a4:c9:86:e7:b1:9a:20:cb:53:a5:85:
                    e7:3d:be:7d:9a:fe:24:45:33:dc:76:15:ed:0f:a2:
                    71:64:4c:65:2e:81:68:45:a7
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        bb:4c:12:2b:cf:2c:26:00:4f:14:13:dd:a6:fb:fc:0a:11:84:
        8c:f3:28:1c:67:92:2f:7c:b6:c5:fa:df:f0:e8:95:bc:1d:8f:
        6c:2c:a8:51:cc:73:d8:a4:c0:53:f0:4e:d6:26:c0:76:01:57:
        81:92:5e:21:f1:d1:b1:ff:e7:d0:21:58:cd:69:17:e3:44:1c:
        9c:19:44:39:89:5c:dc:9c:00:0f:56:8d:02:99:ed:a2:90:45:
        4c:e4:bb:10:a4:3d:f0:32:03:0e:f1:ce:f8:e8:c9:51:8c:e6:
        62:9f:e6:9f:c0:7d:b7:72:9c:c9:36:3a:6b:9f:4e:a8:ff:64:
        0d:64
-----BEGIN CERTIFICATE-----
MIICPDCCAaUCEHC65B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhE
BarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/is
I19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0G
CSqGSIb3DQEBAgUAA4GBALtMEivPLCYATxQT3ab7/AoRhIzzKBxnki98tsX63/Do
lbwdj2wsqFHMc9ikwFPwTtYmwHYBV4GSXiHx0bH/59AhWM1pF+NEHJwZRDmJXNyc
AA9WjQKZ7aKQRUzkuxCkPfAyAw7xzvjoyVGM5mKf5p/AfbdynMk2OmufTqj/ZA1k
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-class-4-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            02:a6:00:00:01
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 4 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 1999 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 4 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d0:b2:75:f6:78:d0:ae:5a:50:f4:e9:50:a9:9f:
                    8c:d7:ef:91:94:70:e8:d2:24:90:76:89:85:d6:df:
                    ac:e6:01:17:32:80:f0:9d:93:47:bc:9a:65:9d:1f:
                    97:ae:bf:e9:86:75:63:20:89:bd:80:58:9d:04:0c:
                    9d:a8:c1:24:e9:0b:e5:31:78:bd:fc:2d:0c:37:6a:
                    9e:78:80:e9:46:75:f9:ed:a3:fb:13:7b:c8:c1:4c:
                    d2:a3:ef:f5:3c:b0:62:8f:4a:5d:3b:dd:95:67:8f:
                    13:b9:c1:3c:d6:a7:26:9b:ec:c3:3b:7a:d9:4d:bc:
                    6d:9b:e8:15:01:e3:f0:47:a9
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        53:dd:d3:f0:9c:24:7e:40:aa:e2:fc:00:1a:d7:da:0c:fc:32:
        61:b8:15:0d:96:f3:fa:57:1b:7f:33:7c:af:e9:98:9a:61:c8:
        7a:b3:b7:ff:b1:dc:99:83:dc:ac:12:fc:70:c9:1f:38:42:ed:
        44:f6:80:2e:5b:6b:33:69:ac:9c:d3:5c:e7:5f:5a:18:c7:b1:
        2d:79:04:96:41:91:99:41:b1:3c:0d:ba:84:39:c6:3b:97:f0:
        26:c9:8e:ee:bd:cc:42:95:ff:1e:c7:02:3f:54:0c:78:f5:bc:
        aa:60:7c:02:69:e8:dc:ac:e2:02:76:61:c4:3e:03:ea:d2:8a:
        24:d1
-----BEGIN CERTIFICATE-----
MIICMTCCAZoCBQKmAAABMA0GCSqGSIb3DQEBAgUAMF8xCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgNCBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05NjAxMjkwMDAwMDBa
Fw05OTEyMzEyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2ln
biwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgNCBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZp
Y2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0LJ1
9njQrlpQ9OlQqZ+M1++RlHDo0iSQdomF1t+s5gEXMoDwnZNHvJplnR+Xrr/phnVj
IIm9gFidBAydqMEk6QvlMXi9/C0MN2qeeIDpRnX57aP7E3vIwUzSo+/1PLBij0pd
O92VZ48TucE81qcmm+zDO3rZTbxtm+gVAePwR6kCAwEAATANBgkqhkiG9w0BAQIF
AAOBgQBT3dPwnCR+QKri/AAa19oM/DJhuBUNlvP6Vxt/M3yv6ZiaYch6s7f/sdyZ
g9ysEvxwyR84Qu1E9oAuW2szaayc01znX1oYx7EteQSWQZGZQbE8DbqEOcY7l/Am
yY7uvcxClf8exwI/VAx49byqYHwCaejcrOICdmHEPgPq0ook0Q==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-verisign-trust-network-00.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            4c:c7:ea:aa:98:3e:71:d3:93:10:f8:3d:3a:89:91:92
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:aa:d0:ba:be:16:2d:b8:83:d4:ca:d2:0f:bc:76:
                    31:ca:94:d8:1d:93:8c:56:02:bc:d9:6f:1a:6f:52:
                    36:6e:75:56:0a:55:d3:df:43:87:21:11:65:8a:7e:
                    8f:bd:21:de:6b:32:3f:1b:84:34:95:05:9d:41:35:
                    eb:92:eb:96:dd:aa:59:3f:01:53:6d:99:4f:ed:e5:
                    e2:2a:5a:90:c1:b9:c4:a6:15:cf:c8:45:eb:a6:5d:
                    8e:9c:3e:f0:64:24:76:a5:cd:ab:1a:6f:b6:d8:7b:
                    51:61:6e:a6:7f:87:c8:e2:b7:e5:34:dc:41:88:ea:
                    09:40:be:73:92:3d:6b:e7:75
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        a9:4f:c3:0d:c7:67:be:2c:cb:d9:a8:cd:2d:75:e7:7e:15:9e:
        3b:72:eb:7e:eb:5c:2d:09:87:d6:6b:6d:60:7c:e5:ae:c5:90:
        23:0c:5c:4a:d0:af:b1:5d:f3:c7:b6:0a:db:e0:15:93:0d:dd:
        03:bc:c7:76:8a:b5:dd:4f:c3:9b:13:75:b8:01:c0:e6:c9:5b:
        6b:a5:b8:89:dc:ac:a4:dd:72:ed:4e:a1:f7:4f:bc:06:d3:ea:
        c8:64:74:7b:c2:95:41:9c:65:73:58:f1:90:9a:3c:6a:b1:98:
        c9:c4:87:bc:cf:45:6d:45:e2:6e:22:3f:fe:bc:0f:31:5c:e8:
        f2:d9
-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEEzH6qqYPnHTkxD4PTqJkZIwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgMSBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgMSBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQCq0Lq+Fi24g9TK0g+8djHKlNgdk4xWArzZbxpvUjZudVYK
VdPfQ4chEWWKfo+9Id5rMj8bhDSVBZ1BNeuS65bdqlk/AVNtmU/t5eIqWpDBucSm
Fc/IReumXY6cPvBkJHalzasab7bYe1FhbqZ/h8jit+U03EGI6glAvnOSPWvndQID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAKlPww3HZ74sy9mozS11534Vnjty637rXC0J
h9ZrbWB85a7FkCMMXErQr7Fd88e2CtvgFZMN3QO8x3aKtd1Pw5sTdbgBwObJW2ul
uIncrKTdcu1OofdPvAbT6shkdHvClUGcZXNY8ZCaPGqxmMnEh7zPRW1F4m4iP/68
DzFc6PLZ
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-verisign-trust-network-01.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            b9:2f:60:cc:88:9f:a1:7a:46:09:b8:5b:70:6c:8a:af
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:a7:88:01:21:74:2c:e7:1a:03:f0:98:e1:97:3c:
                    0f:21:08:f1:9c:db:97:e9:9a:fc:c2:04:06:13:be:
                    5f:52:c8:cc:1e:2c:12:56:2c:b8:01:69:2c:cc:99:
                    1f:ad:b0:96:ae:79:04:f2:13:39:c1:7b:98:ba:08:
                    2c:e8:c2:84:13:2c:aa:69:e9:09:f4:c7:a9:02:a4:
                    42:c2:23:4f:4a:d8:f0:0e:a2:fb:31:6c:c9:e6:6f:
                    99:27:07:f5:e6:f4:4c:78:9e:6d:eb:46:86:fa:b9:
                    86:c9:54:f2:b2:c4:af:d4:46:1c:5a:c9:15:30:ff:
                    0d:6c:f5:2d:0e:6d:ce:7f:77
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        72:2e:f9:7f:d1:f1:71:fb:c4:9e:f6:c5:5e:51:8a:40:98:b8:
        68:f8:9b:1c:83:d8:e2:9d:bd:ff:ed:a1:e6:66:ea:2f:09:f4:
        ca:d7:ea:a5:2b:95:f6:24:60:86:4d:44:2e:83:a5:c4:2d:a0:
        d3:ae:78:69:6f:72:da:6c:ae:08:f0:63:92:37:e6:bb:c4:30:
        17:ad:77:cc:49:35:aa:cf:d8:8f:d1:be:b7:18:96:47:73:6a:
        54:22:34:64:2d:b6:16:9b:59:5b:b4:51:59:3a:b3:0b:14:f4:
        12:df:67:a0:f4:ad:32:64:5e:b1:46:72:27:8c:12:7b:c5:44:
        b4:ae
-----BEGIN CERTIFICATE-----
MIIDAzCCAmwCEQC5L2DMiJ+hekYJuFtwbIqvMA0GCSqGSIb3DQEBBQUAMIHBMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xPDA6BgNVBAsTM0Ns
YXNzIDIgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBH
MjE6MDgGA1UECxMxKGMpIDE5OTggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9y
aXplZCB1c2Ugb25seTEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazAe
Fw05ODA1MTgwMDAwMDBaFw0yODA4MDEyMzU5NTlaMIHBMQswCQYDVQQGEwJVUzEX
MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xPDA6BgNVBAsTM0NsYXNzIDIgUHVibGlj
IFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjE6MDgGA1UECxMx
KGMpIDE5OTggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25s
eTEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazCBnzANBgkqhkiG9w0B
AQEFAAOBjQAwgYkCgYEAp4gBIXQs5xoD8JjhlzwPIQjxnNuX6Zr8wgQGE75fUsjM
HiwSViy4AWkszJkfrbCWrnkE8hM5wXuYuggs6MKEEyyqaekJ9MepAqRCwiNPStjw
DqL7MWzJ5m+ZJwf15vRMeJ5t60aG+rmGyVTyssSv1EYcWskVMP8NbPUtDm3Of3cC
AwEAATANBgkqhkiG9w0BAQUFAAOBgQByLvl/0fFx+8Se9sVeUYpAmLho+Jscg9ji
nb3/7aHmZuovCfTK1+qlK5X2JGCGTUQug6XELaDTrnhpb3LabK4I8GOSN+a7xDAX
rXfMSTWqz9iP0b63GJZHc2pUIjRkLbYWm1lbtFFZOrMLFPQS32eg9K0yZF6xRnIn
jBJ7xUS0rg==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-verisign-trust-network-02.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            7d:d9:fe:07:cf:a8:1e:b7:10:79:67:fb:a7:89:34:c6
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:cc:5e:d1:11:5d:5c:69:d0:ab:d3:b9:6a:4c:99:
                    1f:59:98:30:8e:16:85:20:46:6d:47:3f:d4:85:20:
                    84:e1:6d:b3:f8:a4:ed:0c:f1:17:0f:3b:f9:a7:f9:
                    25:d7:c1:cf:84:63:f2:7c:63:cf:a2:47:f2:c6:5b:
                    33:8e:64:40:04:68:c1:80:b9:64:1c:45:77:c7:d8:
                    6e:f5:95:29:3c:50:e8:34:d7:78:1f:a8:ba:6d:43:
                    91:95:8f:45:57:5e:7e:c5:fb:ca:a4:04:eb:ea:97:
                    37:54:30:6f:bb:01:47:32:33:cd:dc:57:9b:64:69:
                    61:f8:9b:1d:1c:89:4f:5c:67
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        51:4d:cd:be:5c:cb:98:19:9c:15:b2:01:39:78:2e:4d:0f:67:
        70:70:99:c6:10:5a:94:a4:53:4d:54:6d:2b:af:0d:5d:40:8b:
        64:d3:d7:ee:de:56:61:92:5f:a6:c4:1d:10:61:36:d3:2c:27:
        3c:e8:29:09:b9:11:64:74:cc:b5:73:9f:1c:48:a9:bc:61:01:
        ee:e2:17:a6:0c:e3:40:08:3b:0e:e7:eb:44:73:2a:9a:f1:69:
        92:ef:71:14:c3:39:ac:71:a7:91:09:6f:e4:71:06:b3:ba:59:
        57:26:79:00:f6:f8:0d:a2:33:30:28:d4:aa:58:a0:9d:9d:69:
        91:fd
-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEH3Z/gfPqB63EHln+6eJNMYwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgMyBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQDMXtERXVxp0KvTuWpMmR9ZmDCOFoUgRm1HP9SFIIThbbP4
pO0M8RcPO/mn+SXXwc+EY/J8Y8+iR/LGWzOOZEAEaMGAuWQcRXfH2G71lSk8UOg0
13gfqLptQ5GVj0VXXn7F+8qkBOvqlzdUMG+7AUcyM83cV5tkaWH4mx0ciU9cZwID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAFFNzb5cy5gZnBWyATl4Lk0PZ3BwmcYQWpSk
U01UbSuvDV1Ai2TT1+7eVmGSX6bEHRBhNtMsJzzoKQm5EWR0zLVznxxIqbxhAe7i
F6YM40AIOw7n60RzKprxaZLvcRTDOaxxp5EJb+RxBrO6WVcmeQD2+A2iMzAo1KpY
oJ2daZH9
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-verisign-trust-network-03.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            32:88:8e:9a:d2:f5:eb:13:47:f8:7f:c4:20:37:25:f8
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 4 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 4 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ba:f0:e4:cf:f9:c4:ae:85:54:b9:07:57:f9:8f:
                    c5:7f:68:11:f8:c4:17:b0:44:dc:e3:30:73:d5:2a:
                    62:2a:b8:d0:cc:1c:ed:28:5b:7e:bd:6a:dc:b3:91:
                    24:ca:41:62:3c:fc:02:01:bf:1c:16:31:94:05:97:
                    76:6e:a2:ad:bd:61:17:6c:4e:30:86:f0:51:37:2a:
                    50:c7:a8:62:81:dc:5b:4a:aa:c1:a0:b4:6e:eb:2f:
                    e5:57:c5:b1:2b:40:70:db:5a:4d:a1:8e:1f:bd:03:
                    1f:d8:03:d4:8f:4c:99:71:bc:e2:82:cc:58:e8:98:
                    3a:86:d3:86:38:f3:00:29:1f
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        85:8c:12:c1:a7:b9:50:15:7a:cb:3e:ac:b8:43:8a:dc:aa:dd:
        14:ba:89:81:7e:01:3c:23:71:21:88:2f:82:dc:63:fa:02:45:
        ac:45:59:d7:2a:58:44:5b:b7:9f:81:3b:92:68:3d:e2:37:24:
        f5:7b:6c:8f:76:35:96:09:a8:59:9d:b9:ce:23:ab:74:d6:83:
        fd:32:73:27:d8:69:3e:43:74:f6:ae:c5:89:9a:e7:53:7c:e9:
        7b:f6:4b:f3:c1:65:83:de:8d:8a:9c:3c:88:8d:39:59:fc:aa:
        3f:22:8d:a1:c1:66:50:81:72:4c:ed:22:64:4f:4f:ca:80:91:
        b6:29
-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEDKIjprS9esTR/h/xCA3JfgwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgNCBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgNCBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQC68OTP+cSuhVS5B1f5j8V/aBH4xBewRNzjMHPVKmIquNDM
HO0oW369atyzkSTKQWI8/AIBvxwWMZQFl3Zuoq29YRdsTjCG8FE3KlDHqGKB3FtK
qsGgtG7rL+VXxbErQHDbWk2hjh+9Ax/YA9SPTJlxvOKCzFjomDqG04Y48wApHwID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAIWMEsGnuVAVess+rLhDityq3RS6iYF+ATwj
cSGIL4LcY/oCRaxFWdcqWERbt5+BO5JoPeI3JPV7bI92NZYJqFmduc4jq3TWg/0y
cyfYaT5DdPauxYma51N86Xv2S/PBZYPejYqcPIiNOVn8qj8ijaHBZlCBckztImRP
T8qAkbYp
-----END CERTIFICATE-----
...EOF...
