/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      ModemView : NSObject <PrefsViewProtocol>
 *
 *  Description:  Modem preferences (device, speed, flow control etc.)
 *  
 *  pppd options:
 *  
 *  (lock) --------------- Use UUCP style lock file
 *  (modem)--------------- Use modem control lines
 *  local ---------------- Don't use the modem control lines
 *  <tty_name> ----------- Communicate over the named device
 *  <speed> -------------- Set the baud rate to <speed> (a decimal number)
 *  crtscts--------------- 
 *  nocrtscts            | Flow control
 *  cdtrcts              |
 *  nocdtrcts            |
 *  xonxoff --------------
 *  escape ---------------
 *  asyncmap ------------\ Async charmap
 *  default-asyncmap ----/
 *  default-mru ---------- Disable MTU/MRU negotiation and use 1500
 *  mru ------------------ Maximum Receive Unit (default 1500)
 *  mtu ------------------ Maximum Transmit Unit (default 1500)
 */

#import <Foundation/NSObject.h>

#import "PrefsViewProtocol.h"

@class NSView;
@class NSBox;
@class NSTextField;
@class NSPopUpButton;

@interface ModemView : NSObject <PrefsViewProtocol>
{
  NSView              *view;
                      
  NSBox               *hardwareFrame;
  NSTextField         *deviceLabel;
  NSPopUpButton       *devicePop;
  NSTextField         *speedLabel;
  NSPopUpButton       *speedPop;
  NSTextField         *flowLabel;
  NSPopUpButton       *flowPop;
                      
  NSBox               *dataFrame;
  NSButton            *defaultMRU;
  NSTextField         *mruLabel;
  NSTextField         *mruTF;
  NSTextField         *mtuLabel;
  NSTextField         *mtuTF;
                      
  NSBox               *advancedFrame;
  NSTextField         *escapeLabel;
  NSTextField         *escapeTF;
  NSTextField         *asyncmapLabel;
  NSTextField         *asyncmapTF;

  NSMutableDictionary *prefs;
}

- (void) defaultMRUAction: (id)sender;

@end
