package org.apache.commons.javaflow.bytecode.transformation.data;

import org.apache.commons.javaflow.Continuation;

import java.io.Serializable;


/**
 * Test for making sure that rstack works correctly. For this test we need to
 * have a stack frame that goes through multiple objects of different types.
 * 
 * @author Kohsuke Kawaguchi
 */
public final class BlackRed implements Runnable, Serializable {

  public void run() {
    // new Black( new Red( new Black( new Suspend()))).run();
    new Black( new Suspend()).run();
  }

  
  class Black implements Runnable {
    final Runnable r;

    public Black( Runnable r) {
      this.r = r;
    }

    public void run() {
      String s = "foo"; // have some random variable
      r.run();
    }
  }

  
  class Red implements Runnable {
    final Runnable r;

    public Red( Runnable r) {
      this.r = r;
    }

    public void run() {
      int i = 5; // have some random variable
      r.run();
    }
  }

  
  class Suspend implements Runnable {
    public void run() {
      Continuation.suspend();
    }
  }

}

