{Collatinus - Extraction du lexique d'un texte latin.

Copyright (C) 1998 Y. Ouvrard.

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec l'auteur : yves.ouvrard@collatinus.org }


unit UHtml;

interface

uses Classes, UMorpho, Utiles;

{ Pour la version Lazarus : formate le texte dj lemmatis. }
function formate_html(texte, analyses : Tstrings) : TStringlist;

{ Pour la version console : lemmatise, puis formate.}
Function SortieHtml (source : string; f : boolean) : TStringList;


implementation

{ Pour la version Lazarus : formate le texte dj lemmatis. }
function formate_html(texte, analyses : Tstrings) : TStringlist;
var
   moitie : integer;
   iLin : integer;
begin
   Result := TStringList.Create;
   with Result do
      begin
         add ('<html><head>');
         add ('<style type="text/css">');
         add ('<!--');
         // add ('td { font-size: 8; text-indent: -20px; padding-left: 20px}');
         add ('.texte { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12pt;');
         add ('         text-align: justify; text-indent: 1cm}');
         add ('-->');
         add ('</style></head>');
         add ('<body>');
         add ('<p class="texte">');
         addStrings (texte);
         add ('</p>');
         
         moitie := analyses.count div 2;
         if analyses.count mod 2 > 0
            then inc (moitie);
            
         add ('<table border="0"><tr>');
         Add ('<td width="50%" valign="top" class="voc"><ul>');
         for iLin := 0 to moitie
            do Add ('<li>' + analyses[iLin] + '</li>');
         Add('</ul></td><td width="50%" valign="top" class="voc"><ul>');
         for iLin := succ(moitie) to analyses.count - 1
            do Add ('<li>' + analyses[iLin] + '</li>');

         add ('</ul></td></tr></table></body></html>');
      end;
end;

{ Pour la version console : lemmatise, puis formate.
  le boolen f indique si source est un fichier }
Function SortieHtml (source : string; f : boolean) : TStringList;
  var l : TStringList;
      t : AnsiString;
      mot : string;
      i : integer;
      analyseMot : TStringList;
      inventum : boolean;
      LeVoc : TStringList;
      Tiers : integer;
      iLin : integer;
begin
  Result := TStringList.Create;
  with Result do
    begin
      Add ('<html><head>');
      add ('<style type="text/css">');
      add ('<!--');
      // add ('td { font-size: 8; text-indent: -20px; padding-left: 20px}');
      add ('.texte { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12pt;');
      add ('         text-align: justify; text-indent: 1cm}');
      add ('-->');
      add ('</style></head>');
      add ('<body>');
      if f then
        begin
          // charger le fichier dans la chane t
          l := TStringList.Create;
          l.LoadFromFile (source);
          t := l.text;
          l.free;
        end
        else t := source;
      // afficher le texte
      add ('<p class="texte">' + t + '</p>');
      // liste de mots
      mot := '';
      LeVoc := TStringList.Create;
      LeVoc.Sorted := True;
      LeVoc.Duplicates := DupIgnore;
      for i := 1 to length (t) do
         if t[i] in lettres
            then mot := mot + t[i]
         else
           begin
              if mot > '' then
                begin
                  analyseMot := AnalysesDe (mot, inventum, maVocSeul);
                  LeVoc.add( analyseMot.text + '<br>');
                  analyseMot.free;
                end;
              mot := '';
           end;
      // calculer les colonnes;
      add ('<table border="0"><tr>');
      Tiers := LeVoc.count div 3;
      Add ('<td width="33%" valign="top" class="voc"><ul>');
      for iLin := 0 to Tiers
         do Add ('<li>' + LeVoc[iLin] + '</li>');
      Add('</ul></td><td width="33%" valign="top" class="voc"><ul>');
      for iLin := succ(Tiers) to Tiers * 2
         do Add ('<li>' + LeVoc[iLin] + '</li>');
      Add('</ul></td><td valign="top" class="voc"><ul>');
      for iLin := succ(Tiers * 2) to LeVoc.Count - 1
         do Add ('<li>' + LeVoc[iLin] + '</li>');
      add ('</ul></td></tr></table></body></html>');
      LeVoc.Free;
  end;
end;

end.
