var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import Collapse from 'react-collapse';
import { default as cx } from 'classnames';

var LoginFormError = function LoginFormError(_ref) {
  var children = _ref.children,
      show = _ref.show,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ['children', 'show', 'className']);

  return children && React.createElement(
    Collapse,
    _extends({}, props, { isOpened: show, className: cx('login-form-error', className) }),
    children
  );
};

LoginFormError.propTypes = {
  /** Additional css classes */
  className: PropTypes.string,
  /** children nodes or text */
  children: PropTypes.oneOfType([PropTypes.string, PropTypes.node]),
  /** Controlls the collapse to open/close */
  show: PropTypes.bool
};

LoginFormError.defaultProps = {
  className: null,
  children: null,
  show: false
};

export default LoginFormError;