/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *
 * License: GPL-2+
 *
 * Initial version: 2009-06-28
 *
 */

#ifndef STILTON_LOG_FACILITY_H
#define STILTON_LOG_FACILITY_H

#include <cstdarg>
#include <fstream>

//#include <boost/interprocess/sync/interprocess_mutex.hpp>
//#include <boost/interprocess/sync/interprocess_condition.hpp>


namespace Stilton {

using namespace std;
using namespace Stilton;


// bitwise OR this with CLogFacility::status to prevent locking even if supported
#define STILTON_LOG_NOLOCK	1

class CLogFacility {

    public:
	CLogFacility( const char *log_fname,
		      int log_threshold = 4,
		      int stdout_tee_threshold = 2,
		      unsigned short sec_dec_places = 2,
		      int bits = 0,
		      size_t buf_size = 2048);

	int	status;

	int	log_threshold,
		stdout_tee_threshold;
	unsigned short
		sec_dec_places;
      // full-featured; always terminating lines with a \n
	void msg( int vrb, const char *client_name, const char* fmt, ...);
	void msgv( int vrb, const char *client_name, const char* fmt, va_list);
      // raw output: no parsing, not timestamping each line
	void msg_( int vrb, const char *client_name, const char* fmt, ...);
	void msgv_( int vrb, const char *client_name, const char* fmt, va_list);

	const char *log_fname() const
		{ return _log_fname.c_str(); }
	size_t buf_size() const
		{ return _buf_size; }

       ~CLogFacility();

    private:
	string	_log_fname;
	size_t	_buf_size;
	ofstream
		_log_strm;
	char
		*_line_buf;
//	boost::interprocess::interprocess_mutex
//		_log_lock;
};


}

#endif

// EOF
