#include <stdio.h>

void mini_printf(char *, int *);
void putint(int);
int power(int, int);
int goal(int, int);

#define MAXDIGITS 31

void mini_printf(char *fmt, int *values)
{
  int i, j;
  /* Parse the format string */
  for (i = j = 0; fmt[i] != '\0'; i++) {
    if (fmt[i] != '%')
      putchar(fmt[i]);
    else {
      i++;
      switch (fmt[i]) {
      case 'd':
	/* %d: output the next int */
	putint(values[j]);
	j++;
	break;
      case '%':
	putchar('%');
	break;
      default:
	putchar(fmt[i]);
	break;
      }
    }
  }
}

/* output integer i as string to stdout */
void putint(int i) {
  int j;
  char buf[MAXDIGITS];
  if (i == 0) { putchar('0'); return; };
  if (i <  0) { putchar('-'); i = -i; };
  if (0) j = i; /* force j dynamic, if i is */
  j = 0;
  while (i > 0) {
    buf[j++] = i % 10 + '0';
    i /= 10;
  }
  while (j > 0) putchar(buf[--j]);
  }
  

/* Return the nth power of x */
int power(int x, int n)
{
  int pow;

  pow = 1;
  while (n > 0) {
    pow = pow * x;
    n--;
  }
  return pow;
}

int goal(int x, int n)
{
  int v[2];

  v[0] = power(x, n);
  mini_printf("Power = %d\n", v);
  return 0;
}
