;;;
;;;  cmail-resource.el
;;;

;; $B%a%C%;!<%8$rDI2C$9$k$K$O(B:
;; 
;; (message "foobar") $B$N$h$&$KD>@\=q$$$F$O$$$1$^$;$s!#(B
;; $B$^$:!"(Bcmail-res.el $B$K(B
;;     (cmail-resource-alist$BFb$G(Bunique$B$J%7%s%\%k(B . "$B1Q8l$N%a%C%;!<%8(B")
;; $B$r2C$($^$9!#(Bcmail-res-Japanese.el $B$K(B
;;     ($B@hDx$HF1$8%7%s%\%k(B . "$BF|K\8l$N%a%C%;!<%8(B")
;; $B$r2C$($^$9!#(B
;;
;; (cmail-get-resource '$B%7%s%\%k(B) $B$G$=$NJ8;zNs$r<hF@$9$k$N$,4pK\$G$9$,!"(B
;;   cmail-message-resource
;;   cmail-message-resource1
;;   cmail-error-resource
;;   cmail-error-resource1
;;   cmail-format-resource1
;; $B$J$I$N4X?t$,MQ0U$7$F$"$j$^$9!#(B
;;
;; format $B4X?t$G$N%Q%i%a!<%?$N=gHV$,8@8l$K$h$C$F0[$J$k>l9g!"(B
;; cmail-format-resource $B$rMQ$$$^$9!#(Bformat $B4X?t$N@)8fJ8;zNs$N(B
;; % $B$N=q<0$r3HD%$7$F!"!V2?HVL\$N%Q%i%a!<%?$+!W$r=q$1$k$h$&$K(B
;; $B$7$F$"$j$^$9!#(B
;;   '%' $BHV9f(B ';' $B%?%$%W(B(s$B$H$+(Bd$B$H$+(B)
;;   $BNc(B: %1;s
;; $BHV9f$O(B0$B$+$i;O$^$j$^$9!#(B
;;   $BNc(B:
;;       (cmail-format-resource 'foo-1 (cmail-get-resource 'foo-2) 11)
;;     $B$G!"(Bfoo-1 $B$,(B "%0;s %1;d mails."$B!"(Bfoo-2 $B$,(B "Moved" $B$N>l9g!"7k2L$O(B
;;       "Moved 11 mails."
;;     foo-1 $B$,(B "%1;d$BDL$N<j;f$r(B%0;s$B$7$^$7$?(B."$B!"(Bfoo-2 $B$,(B "$B0\F0(B" $B$N>l9g!"7k2L$O(B
;;       "11$BDL$N<j;f$r0\F0$7$^$7$?!#(B"
;;     $B$H$J$j$^$9!#(B

(provide 'cmail-resource)

(defconst cmail-resource-basename "cmail-res")
(or (and cmail-i18n-message
	 (boundp 'current-language-environment)
	 (or (featurep 'xemacs)
	     (and (boundp 'emacs-major-version)
		  (boundp 'emacs-minor-version)
		  (or (>= emacs-major-version 21)
		      (and (eq emacs-major-version 20) (>= emacs-minor-version 3)))))
	 (load (concat cmail-resource-basename "-" current-language-environment) t))
    (load cmail-resource-basename))

(defun cmail-get-resource (key)
  "$B%7%s%\%k(B kEY $B$K4XO"IU$1$i$l$?%*%V%8%'%/%H$rJV$7$^$9!#(B"
  (cdr (assoc key cmail-resource-alist)))

(defun cmail-message-resource (key)
  "$B%7%s%\%k(B kEY $B$K4XO"IU$1$i$l$?%*%V%8%'%/%H$r%Q%i%a!<%?$K$7$F(B (message) $B$r8F$S$^$9!#(B"
  (message (cdr (assoc key cmail-resource-alist))))

(defun cmail-message-resource1 (key p1)
  "$B%7%s%\%k(B kEY $B$K4XO"IU$1$i$l$?%*%V%8%'%/%H$r%Q%i%a!<%?$K$7$F(B (message) $B$r8F$S$^$9!#(B"
  (message (cdr (assoc key cmail-resource-alist)) p1))

(defun cmail-error-resource (key)
  "$B%7%s%\%k(B kEY $B$K4XO"IU$1$i$l$?%*%V%8%'%/%H$r%Q%i%a!<%?$K$7$F(B (error) $B$r8F$S$^$9!#(B"
  (error (cdr (assoc key cmail-resource-alist))))

(defun cmail-error-resource1 (key p1)
  "$B%7%s%\%k(B kEY $B$K4XO"IU$1$i$l$?%*%V%8%'%/%H$r%Q%i%a!<%?$K$7$F(B (error) $B$r8F$S$^$9!#(B"
  (error (cdr (assoc key cmail-resource-alist)) p1))

(defun cmail-format-resource1 (key p1)
  "$B%7%s%\%k(B kEY $B$K4XO"IU$1$i$l$?%*%V%8%'%/%H$r%Q%i%a!<%?$K$7$F(B (message) $B$r8F$S$^$9!#(B"
  (format (cdr (assoc key cmail-resource-alist)) p1))

(defun cmail-format-resource (key &rest args)
  (let ((form "")			;format$B$KEO$9(Bformat$BJ8;zNs(B
	fargs				;format$B$KEO$9%Q%i%a!<%?(B
	(start 0)			;$B8!:w3+;O%]%$%s%H(B
	mstart				;$B%^%C%A0LCV(B
	(templ (cdr (assoc key cmail-resource-alist))))
    (while (setq mstart (string-match "%" templ start))
					;% $B$N<!$NJ8;z$,(B % $B$+(B?
      (setq mstart (1+ mstart))
      (cond ((string= "%" (substring templ mstart (1+ mstart)))
	     (setq form (concat form (substring templ start (1+ mstart)))
		   start (1+ mstart)))
					;% $B$N<!$,(B "$B?tCM(B;" $B$+(B?
	    ((eq mstart (string-match "\\([0-9]+\\);" templ mstart))
	     (setq form (concat form (substring templ start mstart))
		   start (match-end 0)
		   fargs (append fargs
				 (list (nth (string-to-int (match-string 1 templ))
					    args)))))
	    (t
	     (setq form (concat form (substring templ start mstart))
		   start mstart))))
    (setq form (concat form (substring templ start)))
    (eval (cons 'format (cons form fargs)))))

(require 'alist)
(defun cmail-add-resource (resource-alist)
  "`current-language-environment' $B$K=>$C$FBP1~$9$k8@8l$N%a%C%;!<%8$rDI2C(B
$B$7$^$9!#DI2C$9$k%a%C%;!<%8$O(B ($B<1JL;R(B (\"$B8@8l(B\" . \"$B%a%C%;!<%8(B\") () ... )
$B$N%j%9%H$G;XDj$7$^$9!#8@8l$,(B t $B$,%G%U%)%k%H$N%a%C%;!<%8$H$J$j$^$9!#(B"
  (let ((lang (or (and cmail-i18n-message
		       (boundp 'current-language-environment)
		       (or (featurep 'xemacs)
			   (and (boundp 'emacs-major-version)
				(boundp 'emacs-minor-version)
				(or (>= emacs-major-version 21)
				    (and (eq emacs-major-version 20)
					 (>= emacs-minor-version 3)))))
		       (car (assoc current-language-environment
				   (cdr resource-alist))))
		  t)))
    (set-alist 'cmail-resource-alist
	       (car resource-alist)
	       (cdr (assoc lang (cdr resource-alist))))))
