use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@@@@@@@@K
@@@@@@@@K
@@@@@@K@L`@{
@@@@@@l@K@L`@{
@@@@@@@@K
@@@@@@K@L`@{
@@@@@@l@K@L`@{
@@@@@@@@K
@@@@@@K@L`@{
@@@@@@lK@K@L`@{
@@@@@@@@K
@@@@@@@@K
M]@@@K@L`@K@@K@@{
@@@@@@@
';

print "1..30\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;
my $tot;
my $vals;

compile Language::INTERCAL 'prog', $prog;
@foo= (0, 0, 0);
$tot = 0;
$vals = 1001;
eval { prog(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print $tot == 3000 ? "" : "not ", "ok 2\n";
print $foo[0] >= 200 && $foo[0] <= 300 ? "" : "not ", "ok 3\n";
print $foo[1] >= 700 && $foo[0] <= 800 ? "" : "not ", "ok 4\n";
print $foo[2] >= 260 && $foo[0] <= 380 ? "" : "not ", "ok 5\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= (0, 0, 0);
$tot = 0;
$vals = 1001;
eval { prog_o(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 6\n";
print $tot == 3000 ? "" : "not ", "ok 7\n";
print $foo[0] >= 200 && $foo[0] <= 300 ? "" : "not ", "ok 8\n";
print $foo[1] >= 700 && $foo[0] <= 800 ? "" : "not ", "ok 9\n";
print $foo[2] >= 260 && $foo[0] <= 380 ? "" : "not ", "ok 10\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= (0, 0, 0);
$tot = 0;
$vals = 1001;
eval { prog_q(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 11\n";
print $tot == 3000 ? "" : "not ", "ok 12\n";
print $foo[0] >= 200 && $foo[0] <= 300 ? "" : "not ", "ok 13\n";
print $foo[1] >= 700 && $foo[0] <= 800 ? "" : "not ", "ok 14\n";
print $foo[2] >= 260 && $foo[0] <= 380 ? "" : "not ", "ok 15\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= (0, 0, 0);
$tot = 0;
$vals = 1001;
eval { prog_p(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 16\n";
print $tot == 3000 ? "" : "not ", "ok 17\n";
print $foo[0] >= 200 && $foo[0] <= 300 ? "" : "not ", "ok 18\n";
print $foo[1] >= 700 && $foo[0] <= 800 ? "" : "not ", "ok 19\n";
print $foo[2] >= 260 && $foo[0] <= 380 ? "" : "not ", "ok 20\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= (0, 0, 0);
$tot = 0;
$vals = 1001;
eval { prog_qp(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 21\n";
print $tot == 3000 ? "" : "not ", "ok 22\n";
print $foo[0] >= 200 && $foo[0] <= 300 ? "" : "not ", "ok 23\n";
print $foo[1] >= 700 && $foo[0] <= 800 ? "" : "not ", "ok 24\n";
print $foo[2] >= 260 && $foo[0] <= 380 ? "" : "not ", "ok 25\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= (0, 0, 0);
$tot = 0;
$vals = 1001;
_run_db(prog_d(\&faa, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 26\n";
print $tot == 3000 ? "" : "not ", "ok 27\n";
print $foo[0] >= 200 && $foo[0] <= 300 ? "" : "not ", "ok 28\n";
print $foo[1] >= 700 && $foo[0] <= 800 ? "" : "not ", "ok 29\n";
print $foo[2] >= 260 && $foo[0] <= 380 ? "" : "not ", "ok 30\n";

sub faa {
    --$vals;
    $vals >= 1000 ? '@' : $vals > 0 ? '' : '';
}

sub foo {
    my $n = join('', @_);
    $n =~ s/\n$//;
    $foo[$tot++ % 3] += $n eq 'I' ? 1 : 0;
}

