use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my $prog = '
@@@
';

print "1..6\n";

compile Language::INTERCAL 'prog', $prog;
eval { prog() };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
eval { prog_o() };
print STDERR $@;
print $@ ? "not " : "", "ok 2\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
eval { prog_q() };
print STDERR $@;
print $@ ? "not " : "", "ok 3\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
eval { prog_p() };
print STDERR $@;
print $@ ? "not " : "", "ok 4\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
eval { prog_qp() };
print STDERR $@;
print $@ ? "not " : "", "ok 5\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
_run_db(prog_d());
print STDERR $@;
print $@ ? "not " : "", "ok 6\n";

