use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

print "1..15\n";

my $prog = '
@@@@@@@@@K@L`@{
@@@@@@@@@K@L`@{
M]@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@K
@@@@@@@@@K@L`@{
@@@@@@@@@@
@@@@@@@@@@@K
M]@@@@@@@@K
@@@@@@@@@K@L`@{
@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@
@@@@@@@@@M]@
M]@@@@@@K@
@@@@@@@@@@@K
@@@@@@@@@@
M]@@@@@@@@K
@@@@@@@@@K@L`@{
@@@@@@@@@@
';

fiddle Language::INTERCAL 'bug=0', 'ubug=0', 'next';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo = ();
eval { prog(0, \@foo) };
print STDERR $@;
print $@ ? 'not ' : '', "ok 1\n";
print @foo == 3 ? "" : "not ", "ok 2\n";
print shift @foo eq "I\n" ? "" : "not ", "ok 3\n";
print shift @foo eq "IV\n" ? "" : "not ", "ok 4\n";
print shift @foo eq "I\n" ? "" : "not ", "ok 5\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo = ();
eval { prog(0, \@foo) };
print STDERR $@;
print $@ ? 'not ' : '', "ok 6\n";
print @foo == 3 ? "" : "not ", "ok 7\n";
print shift @foo eq "I\n" ? "" : "not ", "ok 8\n";
print shift @foo eq "IV\n" ? "" : "not ", "ok 9\n";
print shift @foo eq "I\n" ? "" : "not ", "ok 10\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \@foo));
print STDERR $@;
print $@ ? 'not ' : '', "ok 11\n";
print @foo == 3 ? "" : "not ", "ok 12\n";
print shift @foo eq "I\n" ? "" : "not ", "ok 13\n";
print shift @foo eq "IV\n" ? "" : "not ", "ok 14\n";
print shift @foo eq "I\n" ? "" : "not ", "ok 15\n";

