/* tolua: state manipulation.
** Support code for Lua bindings.
** Written by Waldemar Celes
** TeCGraf/PUC-Rio
** Jul 1998
** $Id: tolua_st.c,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $
*/

/* This code is free software; you can redistribute it and/or modify it. 
** The software provided hereunder is on an "as is" basis, and 
** the author has no obligation to provide maintenance, support, updates,
** enhancements, or modifications. 
*/

#include "tolua.h"
#include "tolua_st.h"
#include "tolua_eh.h"

/* Global table created in Lua:
    .tolua_state: indexed by variable addresses, stores the variable values.
                  it is used to restore the tolua context related to a lua
                  context.
*/


void toluaI_st_init (void)
{
 lua_Object lo = lua_createtable();
 lua_pushobject(lo); lua_setglobal(".tolua_state");
}

/* store info for context restoration */
void toluaI_st_store (int* value)
{
 lua_pushobject(lua_getglobal(".tolua_state"));
 lua_pushuserdata((void*)value);
 lua_pushnumber(*value);
 lua_settable();
}

static void restore (void)
{
 int* value = (int*)lua_getuserdata(lua_getparam(1));
 *value = (int)lua_getnumber(lua_getparam(2));
}

void toluaI_st_restore (void)
{
 lua_Object lo;
 toluaI_eh_resetstate();
 lo = lua_getglobal(".tolua_state");
 if (lua_istable(lo))
 {
  lua_pushobject(lo);
  lua_pushcfunction(restore);
  lua_call("foreach");
 }
}
