/*
	$Id: app_beos.h,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Header file to the BeOS initialization.

*/

#ifndef header_app_beos
#define header_app_beos

//#define USE_DBG

#ifdef USE_DBG
	#define DBG(x) cout << x << endl
#else
	#define DBG(x)
#endif

#include "API/Core/System/clanapp.h"
#include "API/Core/System/system.h"
#include "Core/Display/Be/clanwindowscreen.h"

#include <Application.h>

class LibApplication : public BApplication
{
public:
	LibApplication();
	bool is_quitting;
	ClanWindowScreen* clanscreen;
	
private:
	bool QuitRequested();
	void ReadyToRun();
	void ArgvReceived(int32 argc, char **argv);

	int32 largc;
	char** largv;
};


#include "Common/array.h"

class CL_System_KeepAlive;

class CL_System_Generic
{
public:
        static CL_Array<CL_System_KeepAlive> keep_alives;
};

class CL_System_KeepAlive
{
public:
        virtual bool keep_alive()=0;
};

#endif
