/*
	$Id: resourcetype_sample.h,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Sample resourcetype header file

*/

//! l2_component="Resources"

#ifndef header_resourcetype_sample
#define header_resourcetype_sample

#include "API/stl.h"
#include "API/Core/Resources/resource_manager.h"
#include "API/Core/System/clanstring.h"
#include "API/Core/Sound/soundbuffer.h"
#include "API/Core/Sound/static_soundprovider.h"

class CL_Res_Sample : public CL_ResourceType
//: The sound sample resource type.
// This class is used to load sample resources from a resource source
// (datafile or script file).
// <br>
// Use the CL_ResourceManager to get an instance to the resource source, and
// then call one of the static functions here to load the resource:
// <code>
// CL_ResourceManager res_manager("my_datafile.dat", true);
// CL_SoundBuffer *my_sample = CL_Res_Sample::load("my_sample", res_manager);
// </code>
//!res_type: sample
//!res_option: wav - Interpret this file as a PCM Wave file.
//!res_option: stream - This sample should be streamed.
//!res_option: loop - This sample should be looped (only used for streamed samples).
//!res_desc: A sound sample resource in ClanLib. Used by the static and streamed
//!res_desc: sound providers.
{
public:
	CL_Res_Sample();

private:
friend CL_ResourceManager;
	virtual CL_Resource *create_from_location(
		std::string name,
		std::string location,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent);

	virtual CL_Resource *create_from_serialization(
		std::string name,
		CL_ResourceManager *parent);
};

class CL_WritableSampleResource : public CL_Resource
{
protected:
	CL_SoundBuffer *loaded_sample;
	bool loaded;
	CL_String sample_location;
	CL_ResourceOptions *options;
	CL_ResourceManager *parent;
	int load_count;
public:
	CL_WritableSampleResource(std::string name);
	virtual ~CL_WritableSampleResource() { ; }

	virtual void serialize_save(CL_OutputSource *output);
	virtual void load();
	virtual void unload();
	virtual int get_load_count() { return load_count; }

	virtual CL_SoundBuffer *create_sample()=0;
};

class CL_SampleFileResource : public CL_WritableSampleResource
{
public:
	CL_SampleFileResource(
		std::string name,
		std::string location,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent);

	~CL_SampleFileResource();

	virtual CL_SoundBuffer *create_sample();
};

class CL_SampleDatafileResource : public CL_WritableSampleResource
{
public:
	CL_SampleDatafileResource(
		std::string name,
		CL_ResourceManager *parent);

	~CL_SampleDatafileResource();

	virtual CL_SoundBuffer *create_sample();
};


#endif
