#ifndef header_network_delivery_unix
#define header_network_delivery_unix

#include <list>

#include "Core/Network/Generic/network_delivery_impl.h"
#include "API/Core/System/mutex.h"

class CL_UniformSocket;
class CL_UniformUDPConnection;
class CL_UniformAcceptSocket;

class CL_UnixPipeConnection;
class CL_Connections_Unix : public CL_ConnectionProvider
{
protected:
	CL_UnixPipeConnection *client_connection;

	std::list<CL_UniformSocket *> connections;
	std::list<CL_UniformUDPConnection *> udp_connections;
	std::list<CL_UniformAcceptSocket *> accepting_connections;

public:
	CL_Connections_Unix(CL_UnixPipeConnection *client_connection);
	virtual ~CL_Connections_Unix();

	virtual CL_UDPConnection *create_udp_connection(unsigned int port);
	virtual CL_Connection *get_client();
	virtual CL_Connection *create_tcp_connection(
		int ip_addr,
		int port);
	virtual CL_Connection *accept();
	virtual void start_accept_on_port(int port);
	virtual void stop_accept_on_port(int port);
	virtual void wait_for_connection_data(CL_Mutex *mutex);
	virtual void remove_connection(CL_Connection *removed_connection);
};

#endif
