/*
	$Id: outputsource_memory_generic.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <stdio.h>
#include "API/Core/System/cl_assert.h"
#include <API/Core/IOData/outputsource.h>
#include "outputsource_memory_generic.h"

CL_OutputSource_MemoryGeneric::CL_OutputSource_MemoryGeneric(unsigned int blocksize)
{
	m_blocksize = blocksize;
	m_size = m_blocksize;
	m_data = new unsigned char[m_blocksize];
	m_pos = 0;
}

CL_OutputSource_MemoryGeneric::~CL_OutputSource_MemoryGeneric()
{
	delete[] m_data;
}

void *CL_OutputSource_MemoryGeneric::get_data() const
{
	return (void *) m_data;
}

void CL_OutputSource_MemoryGeneric::set_system_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_OutputSource_MemoryGeneric::set_big_endian_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_OutputSource_MemoryGeneric::set_little_endian_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_OutputSource_MemoryGeneric::write_int32(int data)
{
	write(&data, sizeof(int));
}

void CL_OutputSource_MemoryGeneric::write_uint32(unsigned int data)
{
	write(&data, sizeof(unsigned int));
}

void CL_OutputSource_MemoryGeneric::write_short16(short data)
{
	write(&data, sizeof(short));
}

void CL_OutputSource_MemoryGeneric::write_ushort16(unsigned short data)
{
	write(&data, sizeof(unsigned short));
}

void CL_OutputSource_MemoryGeneric::write_char8(char data)
{
	write(&data, sizeof(char));
}

void CL_OutputSource_MemoryGeneric::write_uchar8(unsigned char data)
{
	write(&data, sizeof(unsigned char));
}

void CL_OutputSource_MemoryGeneric::write_float32(float data)
{
	write(&data, sizeof(float));
}

void CL_OutputSource_MemoryGeneric::write_bool(bool data)
{
	write(&data, sizeof(bool));
}

int CL_OutputSource_MemoryGeneric::write(const void *data, int size)
{
	if (m_pos + size > m_size) // extend array with blocksize
	{
		int new_size = m_size + size + m_blocksize;

		unsigned char *old = m_data;
		m_data = new unsigned char[new_size];

		memcpy(m_data, old, m_pos);
		delete[] old;
		m_size = new_size;
	}
	
	memcpy(m_data + m_pos, data, size);
	m_pos += size;
	
	return size;
}

void CL_OutputSource_MemoryGeneric::open()
{
}

void CL_OutputSource_MemoryGeneric::close()
{
}

CL_OutputSource *CL_OutputSource_MemoryGeneric::clone()
{
	cl_assert(false); // not implemented yet.
	return NULL;
}

int CL_OutputSource_MemoryGeneric::tell()
{
	return m_pos;
}

int CL_OutputSource_MemoryGeneric::size()
{
	return m_pos;
}

void CL_OutputSource_MemoryGeneric::write_string(const char *string)
{
	int len = strlen(string)+1;
	write_int32(len);
	write((char*) string, len);
}
