/*
	$Id: cl_grootwindow.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GROOTWINDOW_H
#define CL_GROOTWINDOW_H

#include "cl_gwidget.h"
//#include "uscreensurface.h"

///
class CL_GRootWindow : public CL_GWidget
{
// UOBJECT

 public:
  ///
  CL_GRootWindow(int resX, int resY, int bpp, bool fullscreen);
  ///
  virtual ~CL_GRootWindow();
  /**screen content update.
     reimplements uwidgets update, display is not updated !
  */
  void update();
  ///
  virtual void create() {  dirtyRects_.push_back(globalCoord(window_));};
  ///screen update (not content)
  void updateScreen();
  ///immediate display content update
  void sync();
  ///
  void setTitle(const char*);
  ///
  virtual bool processEvent(const CL_GEvent*);
  ///
  CL_Surface* screen() { return surface_; };
  ///
  bool runDialog(CL_GWidget* );
  ///
  bool closeDialog();
  ///
  bool fullscreen() { return fullscreen_; };
  ///force this rect to get updated to the display on next displayupdate
  void refreshRect(const CL_GRect&);

 protected:
  ///
  std::list<CL_GWidget*> dialogs_;
  ///
  CL_Surface* screen_;
  ///
  bool fullscreen_;
};


#endif // !_CL_GROOTWINDOW_H



