/*
	$Id: mouse.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Input"

#ifndef header_mouse
#define header_mouse

#include "inputdevice.h"

class CL_Mouse : public CL_InputDevice
//: Mouse interface in ClanLib.
// CL_Mouse extends the CL_InputDevice with functionality only useful
// to mice.
//!also: CL_Settings - The class holding ClanLib state information like width/height of the currentdisplay

{
public:
	virtual ~CL_Mouse() { return; }

	static int get_x(); 
	//!retval: Returns the x position of the mouse in range from
	//!retval: [ 0 - CL_Display::get_height() [. 

	static int get_y();
	//!retval: Returns the y position of the mouse in range from
	//!retval: [ 0 - CL_Display::get_height() [. 

	static bool left_pressed();
	//!retval: Returns true if the left mouse button is pressed,
        //!retval: else false is returned.

	static bool middle_pressed();
	//!retval: Returns true if the middle mouse button is pressed,
        //!retval: else false is returned.

	static bool right_pressed();
	//!retval: Returns true if the right mouse button is pressed,
        //!retval: else false is returned.
};

#endif
