/*
	$Id: outputsource_provider.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="I/O Data"	

#ifndef header_outputsource_provider
#define header_outputsource_provider

class CL_OutputSourceProvider
//: Class that provides output targets.
// CL_OutputSourceProvider is used to open output sources. This can be from a
// datafile where the outputsource is an index - or it a directory where the
// files are the outputsources.
{
public:
	virtual ~CL_OutputSourceProvider() { return; }
/*
	Not implemented yet:

	static CL_OutputSourceProvider *create_file_provider(const char *path);
	//: Creates a file provider. Output sources opened are considered as files.
	//!param: path - Path where the files are located.
	//!retval: The file output source provider created.
*/
	virtual CL_OutputSource *open_source(const char *handle)=0;
	//: Opens an outputsource using the passed handle.
	//!param: handle - handle/index/filename/identier to the output source requested.
	//!retval: The output source opened.

	virtual CL_OutputSourceProvider *clone()=0;
	//: Returns a copy of the current provider.
	//!retval: The copy of the outputsource provider.
};

#endif
