/*
	Loads a single surface from a pcx file without using resource files.
*/

#include <ClanLib/core.h>

class SurfaceApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Surface application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupCore::init_display();
	}

	virtual void deinit_modules()
	{
		CL_SetupCore::deinit_display();
		CL_SetupCore::deinit();
	}

	virtual int main(int, char **)
	{
		try
		{
			// Set mode: 640x480 16 bpp
			CL_Display::set_videomode(640, 480, 16, false);

			// Load surface from pcx file:
			CL_Surface *surface = CL_PCXProvider::create("survivor.pcx", NULL);

			CL_Surface *surf_bg = CL_Surface::create(new CL_Canvas(400,400));

			surface->put_target(0,0,0,surf_bg->get_provider());

			surf_bg->get_provider()->draw_line(0,0,100,100,1,0,0,1);

			surf_bg->reload();

			

			// Loop until the user hits escape:
			while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
			{
				// Draw surface:
				
				surf_bg->put_screen(0,0,0);

				surface->put_screen(200, 200, 0.5f, 0.5f);

				
				// Flip front and backbuffer. This makes the changes visible:
				CL_Display::flip_display();
				
				// Update keyboard input and handle system events:
				// Exits the loop if ClanLib requests shutdown - for instance if
				// someone closes the window.
				CL_System::keep_alive();
			}

			delete surface;
		}
		catch (CL_Error err)
		{
			std::cout << "Error: " << err.message.c_str() << std::endl;
		}

		return 0;
	}
} app;
