/*
	Loads a single surface from a pcx file without using resource files.
*/

#include <ClanLib/core.h>

class SurfaceApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Surface application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupCore::init_display();
	}

	virtual void deinit_modules()
	{
		CL_SetupCore::deinit_display();
		CL_SetupCore::deinit();
	}

	virtual int main(int, char **)
	{
		try
		{
			// Set mode: 320x200 16 bpp
			CL_Display::set_videomode(320, 200, 16, true);

			// Load surface from pcx file:
			CL_Surface *surface = CL_PCXProvider::create("survivor.pcx", NULL);

			// Loop until the user hits escape:
			while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
			{
				// Draw surface:
				surface->put_screen(0, 0);
				
				// Flip front and backbuffer. This makes the changes visible:
				CL_Display::flip_display();
				
				// Update keyboard input and handle system events:
				// Exits the loop if ClanLib requests shutdown - for instance if
				// someone closes the window.
				CL_System::keep_alive();
			}

			delete surface;
		}
		catch (CL_Error err)
		{
			std::cout << "Error: " << err.message.c_str() << std::endl;
		}

		return 0;
	}
} app;
