/*
	drawing primitives test app
*/

#include <ClanLib/core.h>

class DrawingApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Drawing application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupCore::init_display();
	}
	
	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}
	
	virtual int main(int, char **)
	{
		try
		{
			CL_Display::set_videomode(320,200,16);

			CL_Canvas *canvas = new CL_Canvas(320, 200);
			
			int color = CL_Color::get_color(canvas, 255, 255, 255); //white
			canvas->lock();
			canvas->draw_pixel(100, 100, color);
			canvas->draw_pixel(110, 100, 255, 255, 255, 255); 
			canvas->unlock();

			canvas->draw_line(0, 0, 40, 40, 1.0, 1.0, 1.0, 1.0);
			canvas->draw_line(10, 0, 50, 40, 1.0, 1.0, 1.0, 1.0);
			
			canvas->draw_line(40, 0, 0, 40, 1.0, 1.0, 1.0, 1.0);
			canvas->draw_line(40, 0, 40, 40, 1.0, 1.0, 1.0, 1.0);
			canvas->draw_line(0, 40, 40, 40, 1.0, 1.0, 1.0, 1.0);			
			 
			//canvas->fill_rect(0, 0, 319, 199, 0.0f, 1.0f, 1.0f, 1.0f);			

			CL_Surface *surface = CL_Surface::create(canvas);
			
			surface->put_screen(0,0);
			CL_Display::flip_display();
			CL_System::sleep(1500);

			delete canvas;
			delete surface;

			return 0;
		}
		catch (CL_Error err)
		{
			cout << "Exception caught: " << err.message.c_str() << endl;
			return -1;
		}
		return -1;
	}
} app;
