/*
	$Id: implementation_ptc.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Initialization functions for PTC implementation.

*/

#include "Core/precomp.h"

#ifdef USE_PTC

#include <ptc/ptc.h>
#include "API/Core/Display/display.h"
#include "Core/System/Unix/implementation_ptc.h"
#include "Core/Display/PTC/displaycard_ptc.h"
#include "implementation_xwindow.h"
#include "API/Core/Display/display.h"
#include "Core/Display/X11/display_xwindow.h"
#include "API/Core/Input/input.h"
#include "Core/Input/X11/mouse_x11.h"
#include "Core/Input/X11/keyboard_x11.h"
#include "Core/Input/X11/joystick_linux.h"
#include "implementation.h"

extern "C"
{
        DL_PREFIX char* clan_module_identify() {
	  return "OpenPTC X11 target";
	}

        DL_PREFIX char* clan_module_abbreviation() {
	  return "ptc";
	}

	DL_PREFIX void clan_module_init()
	{
		CL_Implementation_PTC::add_display();
	}
}

char *ptc_identify() {
  return clan_module_identify();
}

char *ptc_abbreviation() {
  return clan_module_abbreviation();
}

void ptc_init() {
  return clan_module_init();
}

void CL_Implementation_PTC::add_display()
{
	int card_no = CL_Display::cards.size();
	CL_DisplayCard_PTC *card = new CL_DisplayCard_PTC(card_no);
	CL_Display::cards.push_back(card);

	CL_Input::keyboards.push_back(
		new CL_XWindowKeyboard(card));

	CL_Input::pointers.push_back(
		new CL_Mouse_XWin(card));
	
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)

	CL_LinuxJoystick *joy = new CL_LinuxJoystick();
	if (joy->init())
		CL_Input::joysticks.push_back(joy);
	else
		delete joy;

#endif
}

#endif



