/*
	$Id: netobject_controller.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"
#include <API/Core/IOData/inputsource_memory.h>
#include <API/Core/IOData/outputsource_memory.h>
#include <API/Core/Network/netgame.h>
#include <API/Core/Network/netgroup.h>
#include <API/Core/Network/netmessage.h>
#include <API/Core/NetObjects/netobject.h>
#include <API/Core/NetObjects/netobject_controller.h>
#include <API/Core/NetObjects/netobject_creator.h>
#include "API/Core/System/cl_assert.h"

CL_NetObjectController_Basic::CL_NetObjectController_Basic()
{
	// bug bug: obj_id must be unique across computers as well.
	next_obj_id = 0;
	
	creator = NULL;
}

CL_NetObjectController_Basic::~CL_NetObjectController_Basic()
{
	// hmm... maybe we should delete netobjects here?
	// maybe it'll be better if handled by the game? Not sure yet.
}

void CL_NetObjectController_Basic::add(CL_NetObject *netobj, int type)
{
	CL_NetObjectInfo *info = new CL_NetObjectInfo;
	info->obj = netobj;
	info->id = next_obj_id++;
	info->type = type;

	netobjects.push_back(info);
}

void CL_NetObjectController_Basic::remove(CL_NetObject *netobj)
{
	std::list<CL_NetObjectInfo *>::iterator i=netobjects.begin();
	while(i != netobjects.end())
	{
		if ((*i)->obj == netobj)
		{
			delete *i;
			netobjects.erase(i);
			break;
		}
		i++;
	}
}

int CL_NetObjectController_Basic::get_netobj_id(CL_NetObject *netobj)
{
	std::list<CL_NetObjectInfo *>::iterator i=netobjects.begin();
	while(i != netobjects.end())
	{
		if ((*i)->obj == netobj)
			return (*i)->id;
		i++;
	}

	return -1;
}

void CL_NetObjectController_Basic::set_creator(CL_NetObjectCreator *creator)
{
	this->creator = creator;
}

void CL_NetObjectController_Basic::update(CL_NetGame *game, int netchannel)
{
	while (game->peek(netchannel))
	{
		CL_NetMessage message = game->receive(netchannel);
		CL_InputSource_Memory input(message.data);
		
		cl_assert(input.size() > 0);

		int netobj_id = input.read_int32();
		int netobj_type = input.read_int32();

		// Performance bug: List of netobjects should be a hash list.

		std::list<CL_NetObjectInfo *>::iterator i=netobjects.begin();
		while(i != netobjects.end()) {
			if ((*i)->id == netobj_id)
			{
				(*i)->obj->receive_message(&input);
				break;
			}
			i++;
		}

		if (i == netobjects.end()) // didn't find netobj in list.
		{
			if (creator != NULL)
			{
				CL_NetObject *obj = creator->create(
					netobj_type,
					&input);
				
				if (obj != NULL)
				{
					CL_NetObjectInfo *info = new CL_NetObjectInfo;
					info->obj = obj;
					info->id = netobj_id++;
					info->type = netobj_type;

					netobjects.push_back(info);
				}
			}
		}
	}
}

void CL_NetObjectController_Basic::send(
	CL_NetGame *game,
	int channel,
	CL_NetObject *obj,
	CL_NetMessage msg,
	const CL_NetComputer *dest)
{
	CL_NetGroup group;
	group.computers.push_back((CL_NetComputer *) dest);
	
	send(game, channel, obj, msg, &group);
}

void CL_NetObjectController_Basic::send(
	CL_NetGame *game,
	int channel,
	CL_NetObject *obj,
	CL_NetMessage msg,
	const CL_NetGroup *dest)
{
	cl_assert_debug(game != NULL);
	cl_assert_debug(obj != NULL);
	if (dest == NULL) dest = game->get_all();

	// Performance bug: List of netobjects should be a hash list.

	std::list<CL_NetObjectInfo *>::iterator i=netobjects.begin();
	while(i != netobjects.end())
	{
		if ((*i)->obj == obj)
		{
			CL_OutputSource_Memory output;
			output.write_int32((*i)->id);
			output.write_int32((*i)->type);
			output.write(msg.data.data(), msg.data.size());

			game->send(
				channel,
				dest,
				CL_NetMessage(output.get_data()));

			return;
		}
		
		i++;
	}

	// if this assertion occours in your application, you tried to send an
	// object not added to this controller.
	cl_assert(false);
}
