/*
	$Id: display.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <API/Core/Display/cliprect.h>
#include <API/Core/Display/display.h>
#include <API/Core/Display/displaycard.h>
#include <API/Core/Display/palette.h>
#include <API/Core/Display/vidmode.h>
#include <API/Core/Display/pixelformat.h>
#include <API/Core/Display/target.h>

std::vector<CL_DisplayCard*> CL_Display::cards;

void CL_Display::flip_display(bool sync)
{
	CL_Display::get_current_card()->flip_display(sync);
}

void CL_Display::clear_display(float red, float green, float blue, float alpha)
{
	CL_Display::get_current_card()->clear_display(red, green, blue, alpha);
}

void CL_Display::set_palette(CL_Palette *palette)
{
	CL_Display::get_current_card()->set_palette(palette);
}

CL_Palette *CL_Display::get_palette()
{
	return CL_Display::get_current_card()->get_palette();
}

void CL_Display::set_videomode(CL_VidMode *mode)
{
	CL_Display::get_current_card()->set_videomode(mode);
}

void CL_Display::set_videomode(int width, int height, int bpp, bool fullscreen, bool allow_resize)
{
	CL_Display::get_current_card()->set_videomode(width, height, bpp, fullscreen, allow_resize);
}

CL_Target *CL_Display::get_target()
{
	return CL_Display::get_current_card()->get_target();
}

int CL_Display::get_width()
{
	return CL_Display::get_current_card()->get_width();
}

int CL_Display::get_height()
{
	return CL_Display::get_current_card()->get_height();
}

int CL_Display::get_bpp()
{
	return CL_Display::get_current_card()->get_bpp();
}

void CL_Display::push_clip_rect()
{
	CL_Display::get_current_card()->push_clip_rect();
}

void CL_Display::push_clip_rect(const CL_ClipRect &rect)
{
	CL_Display::get_current_card()->push_clip_rect(rect);
}

CL_ClipRect CL_Display::get_clip_rect()
{
	return CL_Display::get_current_card()->get_clip_rect();
}

void CL_Display::set_clip_rect(const CL_ClipRect &rect)
{
	CL_Display::get_current_card()->set_clip_rect(rect);
}

void CL_Display::pop_clip_rect()
{
	CL_Display::get_current_card()->pop_clip_rect();
}

void CL_Display::fill_rect(int x1, int y1, int x2, int y2, float r, float g, float b, float a)
{
	CL_Display::get_current_card()->fill_rect(x1, y1, x2, y2, r, g, b, a);
}

void CL_Display::draw_line(int x1, int y1, int x2, int y2, float r, float g, float b, float a)
{
	if (CL_Target *target = get_target())
	{
		target->draw_line(x1, y1, x2, y2, r, g, b, a);
	}
	else
	{
		CL_Display::get_current_card()->draw_line(x1, y1, x2, y2, r, g, b, a);
	}
}

void CL_Display::sync_buffers()
{
	CL_Display::get_current_card()->sync_buffers();
}
