/*
	Example of playing a soundbuffer from a wave file.
*/

#include <ClanLib/core.h>

#include <unistd.h>

class SoundbufferApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Soundbuffer application"; }

	virtual 
	void init_modules()
	{
		CL_SetupCore::init();	
	}

	virtual 
	void  deinit_modules()
	{
		CL_SetupCore::deinit();			
	}
	
	virtual int main(int, char **)
	{
		CL_SetupCore::init_sound();

		CL_SoundBuffer *soundbuffer = CL_Sample::create("beep.wav", NULL);
		
		CL_SoundBuffer_Session ses = soundbuffer->play();
		sleep(2);
		CL_System::keep_alive();
		
		delete soundbuffer;

		return 0;
	}
} app;
