#include <ClanLib/core.h>
#include <ClanLib/gui.h>

class myApp : public CL_ClanApplication, public CL_GApplication
{
public:
virtual char *get_title() { return "GUI Test"; }

myApp()
{
	register_slot(cl_slot(do_something));
	register_slot(cl_slot(echo));
}

virtual void init_modules()
{
	CL_SetupCore::init();
	CL_SetupCore::init_display();
}

virtual void deinit_modules()
{
	CL_SetupCore::deinit_display();
	CL_SetupCore::deinit();
}

virtual ~myApp() 
{	
	// not necessary
	deregister_slot(cl_slot(do_something));
	deregister_slot(cl_slot(echo));
};

DEF_SLOT_1(echo, CL_GButton*);
DEF_SLOT_1(do_something, int);

virtual int main(int argc, char **argv)
{
	// initialize the gui system
	init(640, 480, 16, true);
	
	CL_ResourceManager* resources = CL_ResourceManager::create("gui.dat", true);
	CL_Font* font = CL_Font::load("Fonts/simple_font", resources);
	setButtonFont(font);
	setTextFont(font);
	
	// create a generic widget, used as a panel in this case
	CL_GWidget *panel = new CL_GWidget(rootWindow(), 499, 0, 140, 479);
	panel->setBackground(CL_Surface::load("Panels/liquid_helium", resources));
	// create a label
	CL_GLabel* lblHello = new CL_GLabel(panel, 5, 40, 50, 50, font);
	lblHello->set_text("Hello");
	lblHello->setBackground(CL_Surface::load("Panels/liquid_helium", resources));

	// create a quit button and connect its 'clicked' signal to our 'quit' slot
	// defined in CL_GApplication. 
	CL_GPushButton *btnQuit = new CL_GPushButton(panel, 5, 445, 44, 29, 1001);
	connect(btnQuit, cl_signal(CL_GPushButton::clicked),
		this, cl_slot(quit));
	btnQuit->set_up_pic(CL_Surface::load("Buttons/btnQuit_up", resources));
	btnQuit->set_down_pic(CL_Surface::load("Buttons/btnQuit_down", resources));	

	
	// create a second button, its pressed and released signals are connected
	// to our echo slot.
	CL_GPushButton *btnEcho = new CL_GPushButton(panel, 5, 5, 53, 29, 1002);
//	btnEcho->set_repeat(true); // needs to be connected to a timer
//	btnEcho->set_text("Echo");
	CL_GTextfield *textfield=new CL_GTextfield(rootWindow(),60,80,100,50,font);	
	textfield->setBackground(CL_Surface::load("Panels/liquid_helium",resources));
	connect(btnEcho, cl_signal(CL_GPushButton::clicked),
		this, cl_slot(echo));
	textfield->set_align(CL_GTextfield::ALIGN_LEFT);
	btnEcho->set_up_pic(CL_Surface::load("Buttons/btnEcho_up", resources));
	btnEcho->set_down_pic(CL_Surface::load("Buttons/btnEcho_down", resources));	

	CL_GToggleButton *tglbtn = new CL_GToggleButton(rootWindow(), 60, 60, 10, 10, 1003);
	connect(tglbtn, cl_signal(CL_GToggleButton::pressed),
		this, cl_slot(echo));
	connect(tglbtn, cl_signal(CL_GToggleButton::released),
	                this, cl_slot(echo));
	
	// connect to the gui's 500ms timer signal	
	connect(this, cl_signal(CL_GApplication::timer500),
		this, cl_slot(do_something));
		
	// start the event loop
	exec();

	// cleanup
	delete lblHello;
	delete btnQuit;
	delete btnEcho;
	delete textfield;
	delete panel;

	resources->unload_all_resources();
	delete resources;
	
	return 0;
}


virtual int startupProc(void)
{
	cout << "starting up..." <<endl;
	return 0;
}

virtual bool handleEvent(const CL_GEvent *event)
{
	bool handled = CL_GApplication::handleEvent(event);
	
	if (!handled)
	{
		switch (event->type())
		{
			/* handle keyboard events */
			case (CL_GEvent::KEY):
			{
				CL_GKeyEvent *e = (CL_GKeyEvent*)event;
				
				// ignore the RELEASED event
				if (e->get_state() == CL_GKeyEvent::PRESSED)
				{
					CL_Key k = e->get_key();
					cout << "key event: key = " << k.id << endl;
					if (k.id == CL_KEY_ESCAPE)
					{
						quit(0);
						handled = true;
					}
				}
			}
				break;			
			

			default:
				break;
		} // end switch
	}
	
	return handled;
}

virtual int eventloopProc(void)
{
	a++;
}

virtual int shutdownProc(void)
{
	cout << "shutting down..." <<endl;
	return 0;
}

private:
	int a;

} app;


void myApp::echo(CL_GButton *btn)
{
	if (btn->get_pressed())
		cout << "button " << btn->get_id() << " pressed" << endl;
	else
        	cout << "button " << btn->get_id() << " released" << endl;
}

void myApp::do_something(int overrun)
{
	a--;
	
	cout << "Timer: " << overrun << endl;
}





