/*
	$Id: scrollbar_generic.h,v 1.22 2002/01/16 19:23:01 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef header_scrollbar_generic
#define header_scrollbar_generic

#include "API/Core/System/timer.h"
#include "API/Core/Math/rect.h"
#include "API/GUI/layout_manager.h"
#include "API/Display/Input/key.h"
#include "API/signals.h"

class CL_ScrollBar;
class CL_Button;
class CL_InputDevice;
class CL_Component;
class CL_ComponentOptions;
class CL_StyleManager;

class CL_ScrollBar_Generic
{
// Construction:
public:
	CL_ScrollBar_Generic(
		CL_ScrollBar *self,
		int min,
		int max,
		int value,
		bool orientation,
		bool tracking);

	~CL_ScrollBar_Generic();

// Attributes:
public:
	int get_range() const;

	CL_Component *client_area;

	int min_value;
	int max_value;
	int cur_value;

	bool tracking;
	bool vertical;
	bool fixed_length;

	bool dragging;

	CL_Rect rect_slider;
	int min_slider_length;
	int fixed_slider_length;
			
// Operations:
public:
	void set_vertical(bool enable);
	void set_range(int min_value, int max_value);
	void set_min_value(int value);
	void set_max_value(int value);
	void set_value(int value, bool using_slider = false);

// Signals:
public:
	CL_Signal_v1<int> sig_value_changed;
	CL_Signal_v0 sig_slider_pressed;
	CL_Signal_v1<int> sig_slider_moved;
	CL_Signal_v0 sig_slider_released;

// Slots:
private:
	CL_Slot slot_set_options;
	CL_Slot slot_timer;
	CL_Slot slot_keydown, slot_keyup, slot_mousemove;
	CL_Slot slot_button_decrease, slot_button_increase;
	CL_Slot slot_child_add, slot_child_remove;
	CL_Slot slot_resize;

// Callbacks:
private:
	void on_set_options(const CL_ComponentOptions &options);
	void on_child_add(CL_Component *child);
	void on_child_remove(CL_Component *child);
	void on_key_down(CL_Component *comp, CL_InputDevice *device, const CL_Key &key);
	void on_key_up(CL_Component *comp, CL_InputDevice *device, const CL_Key &key);
	void on_resize(int old_width, int old_height);
	void on_mouse_move(CL_Component *comp, int x, int y);
	void on_timer_scroll();

// Implementation:
private:
	void calculate_slider();

	CL_LayoutManager layout;
	CL_ScrollBar *scrollbar;

	bool mouse_captured;
	int capture_last_offset;

	CL_Timer timer_scroll;
	int scroll_delta;

	bool initialized;
};

#endif
