/*
	$Id: component_resize_handler.cpp,v 1.8 2001/12/22 17:03:35 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "API/GUI/component_resize_handler.h"
#include "API/GUI/component.h"
#include "API/GUI/component_options.h"
#include "API/Display/Input/input.h"
#include "API/Display/Input/inputdevice.h"

class CL_ComponentResizeHandler_Generic
{
public:
	CL_ComponentResizeHandler_Generic()
	: owner(NULL), client_area(NULL)
	{
	}

	void on_key_down(CL_Component *comp, CL_InputDevice *device, const CL_Key &key);
	void on_key_up(CL_Component *comp, CL_InputDevice *device, const CL_Key &key);
	void on_mouse_move(CL_Component *comp, int x, int y);

	CL_Slot slot_key_down;
	CL_Slot slot_key_up;
	CL_Slot slot_mouse_move;

	bool is_active;
	CL_Point mouse_origin;

	CL_Component *owner;
	CL_Component *client_area;
};

CL_ComponentResizeHandler::CL_ComponentResizeHandler(
	const CL_Rect &resize_area,
	CL_Component *owner,
	CL_StyleManager *style)
:
	impl(new CL_ComponentResizeHandler_Generic)
{
	impl->owner = owner;
	impl->is_active = false;

	impl->client_area = new CL_Component(resize_area, impl->owner, style);

	impl->slot_key_down = impl->client_area->sig_key_down().connect(
		impl, &CL_ComponentResizeHandler_Generic::on_key_down);

	impl->slot_key_up = impl->client_area->sig_key_up().connect(
		impl, &CL_ComponentResizeHandler_Generic::on_key_up);

	impl->slot_mouse_move = impl->client_area->sig_mouse_move().connect(
		impl, &CL_ComponentResizeHandler_Generic::on_mouse_move);
}

CL_ComponentResizeHandler::~CL_ComponentResizeHandler()
{
	if (impl->client_area != NULL)
	{
		impl->owner->remove_child(impl->client_area);
		delete impl->client_area;
	}
	delete impl;
}

void CL_ComponentResizeHandler_Generic::on_key_down(
	CL_Component *comp,
	CL_InputDevice *device,
	const CL_Key &key)
{
	if (device->get_type() != CL_InputDevice::type_mouse) return;

	mouse_origin = CL_Point((int)key.x, (int)key.y);
	is_active = true;
	client_area->capture_mouse();
}

void CL_ComponentResizeHandler_Generic::on_key_up(
	CL_Component *comp,
	CL_InputDevice *device,
	const CL_Key &key)
{
	if (device->get_type() != CL_InputDevice::type_mouse) return;

	is_active = false;
	client_area->release_mouse();
}

void CL_ComponentResizeHandler_Generic::on_mouse_move(
	CL_Component *comp,
	int x,
	int y)
{
	if(is_active == false)
		return;

	int delta_x = x - mouse_origin.x;
	int delta_y = y - mouse_origin.y;

	owner->set_size(owner->get_width() + delta_x, owner->get_height() + delta_y);

	CL_Rect rect = client_area->get_position();

	client_area->set_position(rect.x1 + delta_x, rect.y1 + delta_y);
}
